/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.jca;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.csapi.jr.slee.IpServiceConnection;
import org.mobicents.csapi.jr.slee.TpServiceIdentifier;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayConnectionProxy;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayConnectionProxyAssociation;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.IpCallControlManagerConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManager;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.IpMultiPartyCallControlManagerConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManager;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.IpUIManagerConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.fw.FwSessionException;
import org.mobicents.slee.resource.parlay.session.ParlaySession;
import org.mobicents.slee.resource.parlay.session.ServiceSession;

public class ManagedConnectionImpl
implements ManagedConnection,
ParlayConnectionProxy {
    private static final Log logger = LogFactory.getLog(ManagedConnectionImpl.class);
    private transient ParlaySession parlaySession = null;
    private transient PrintWriter logWriter;
    private ParlayConnectionProxyAssociation association = null;
    private transient ArrayList connectionEventListeners = new ArrayList(2);

    public ManagedConnectionImpl(ParlaySession session) {
        this.parlaySession = session;
    }

    public TpServiceIdentifier getService(String serviceTypeName, Properties serviceProperties) throws javax.slee.resource.ResourceException {
        try {
            return this.parlaySession.getService(serviceTypeName, serviceProperties);
        }
        catch (FwSessionException e) {
            logger.error((Object)"Failed to getService", (Throwable)e);
            throw new javax.slee.resource.ResourceException("Failed to getService", (Throwable)e);
        }
    }

    public IpServiceConnection getIpServiceConnection(TpServiceIdentifier serviceIdentifier) throws javax.slee.resource.ResourceException {
        Object result = null;
        ServiceSession serviceSession = this.parlaySession.getServiceSession(serviceIdentifier);
        if (serviceSession == null) {
            logger.error((Object)("Unrecognised serviceIdentifier:" + serviceIdentifier));
            throw new javax.slee.resource.ResourceException("Unrecognised serviceIdentifier:" + serviceIdentifier);
        }
        switch (serviceSession.getType()) {
            case 0: {
                result = new IpMultiPartyCallControlManagerConnectionImpl((MultiPartyCallControlManager)serviceSession);
                break;
            }
            case 2: {
                result = new IpCallControlManagerConnectionImpl((CallControlManager)serviceSession);
                break;
            }
            case 1: {
                result = new IpUIManagerConnectionImpl((UIManager)serviceSession);
                break;
            }
            default: {
                logger.error((Object)"Unsupported ServiceSession type");
                throw new javax.slee.resource.ResourceException("Unsupported ServiceSession type");
            }
        }
        return result;
    }

    public Object getConnection(Subject arg0, ConnectionRequestInfo arg1) throws ResourceException {
        this.association = new ParlayConnectionImpl();
        this.association.setParlayConnectionProxy(this);
        return this.association;
    }

    public void destroy() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"destroy()");
        }
        if (this.association != null) {
            this.association.setParlayConnectionProxy(null);
        }
        this.parlaySession = null;
        this.connectionEventListeners.clear();
    }

    public void cleanup() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cleanup()");
        }
        if (this.association != null) {
            this.association.setParlayConnectionProxy(null);
        }
    }

    public void associateConnection(Object arg0) throws ResourceException {
        if (this.association != null) {
            this.association.setParlayConnectionProxy(null);
        }
        this.association = (ParlayConnectionProxyAssociation)arg0;
        this.association.setParlayConnectionProxy(this);
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        if (!this.connectionEventListeners.contains(l)) {
            this.connectionEventListeners.add(l);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        this.connectionEventListeners.remove(l);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new ResourceException("getXAResource() not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new ResourceException("getLocalTransaction() not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new ResourceException("getMetaData() not supported");
    }

    public void setLogWriter(PrintWriter arg0) throws ResourceException {
        this.logWriter = arg0;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void associationClosed(ParlayConnectionProxyAssociation association) {
        if (this.association == association) {
            this.association = null;
            ConnectionEvent cev = new ConnectionEvent((ManagedConnection)this, 1);
            cev.setConnectionHandle((Object)association);
            this.fireConnectionClosed(cev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionClosed(ConnectionEvent e) {
        List listeners = null;
        ArrayList arrayList = this.connectionEventListeners;
        synchronized (arrayList) {
            listeners = (List)this.connectionEventListeners.clone();
        }
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ConnectionEventListener.connectionClosed()");
            }
            ((ConnectionEventListener)listeners.get(i)).connectionClosed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionErrorOccurred(ConnectionEvent e) {
        List listeners = null;
        ArrayList arrayList = this.connectionEventListeners;
        synchronized (arrayList) {
            listeners = (List)this.connectionEventListeners.clone();
        }
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ConnectionEventListener.connectionErrorOccurred()");
            }
            ((ConnectionEventListener)listeners.get(i)).connectionErrorOccurred(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof ManagedConnectionImpl;
    }

    public int hashCode() {
        return 1;
    }
}

