/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.session;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.slee.resource.ResourceException;
import org.csapi.fw.TpServiceProperty;

public class ServiceProperties {
    private static final String SERVICEP_PROPERTIES = "TpServiceProperty[]";
    private static final String CLOSE_BRACKET = "] :";
    private static final String VALUE = "Value [";
    private static final String PROPERTY_NAME = "Property Name :";
    private TpServiceProperty[] serviceProperties;
    private static final String lineSeparator = System.getProperty("line.separator");

    private ServiceProperties(TpServiceProperty[] properties) {
        this.serviceProperties = properties;
    }

    public static ServiceProperties load(Properties properties) throws ResourceException {
        if (properties == null) {
            throw new ResourceException("Null value not allowed for service properties");
        }
        Enumeration<Object> propertyNames = properties.keys();
        Vector<TpServiceProperty> propertiesVector = new Vector<TpServiceProperty>();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String[] values = properties.getProperty(propertyName).split(",");
            TpServiceProperty serviceProperty = new TpServiceProperty(propertyName, values);
            propertiesVector.add(serviceProperty);
        }
        TpServiceProperty[] serviceProperties = propertiesVector.toArray(new TpServiceProperty[0]);
        return new ServiceProperties(serviceProperties);
    }

    public String toString() {
        StringBuffer value = new StringBuffer(SERVICEP_PROPERTIES);
        value.append(lineSeparator);
        for (int i = 0; i < this.serviceProperties.length; ++i) {
            value.append(PROPERTY_NAME);
            value.append(this.serviceProperties[i].ServicePropertyName);
            value.append(lineSeparator);
            String[] propertyValues = this.serviceProperties[i].ServicePropertyValueList;
            for (int j = 0; j < propertyValues.length; ++j) {
                value.append(VALUE);
                value.append(j);
                value.append(CLOSE_BRACKET);
                value.append(propertyValues[j]);
                value.append(lineSeparator);
            }
        }
        value.append(lineSeparator);
        return value.toString();
    }

    public TpServiceProperty[] getServiceProperties() {
        return this.serviceProperties;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        boolean result = true;
        ServiceProperties rhs = (ServiceProperties)obj;
        for (int i = 0; i < rhs.getServiceProperties().length; ++i) {
            boolean matchFound = false;
            int match = 0;
            for (int j = 0; j < this.serviceProperties.length; ++j) {
                if (!rhs.getServiceProperties()[i].ServicePropertyName.equals(this.serviceProperties[j].ServicePropertyName)) continue;
                matchFound = true;
                match = j;
                break;
            }
            if (!matchFound) {
                result = false;
                break;
            }
            result = ServiceProperties.assertEquals(rhs.getServiceProperties()[i].ServicePropertyValueList, this.serviceProperties[match].ServicePropertyValueList);
        }
        return result;
    }

    public int hashCode() {
        return 1;
    }

    private static boolean assertEquals(String[] string1, String[] string2) {
        if (string1.length != string2.length) {
            return false;
        }
        for (int i = 0; i < string1.length; ++i) {
            if (string1[i].equals(string2[i])) continue;
            return false;
        }
        return true;
    }
}

