/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.event;

import javax.slee.Address;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.SleeEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.csapi.jr.slee.ResourceEvent;
import org.mobicents.slee.resource.parlay.util.event.EventSender;

public class EventSenderImpl
implements EventSender {
    private static final Log logger = LogFactory.getLog(EventSenderImpl.class);
    private final transient EventLookupFacility eventLookupFacility;
    private final transient SleeEndpoint sleeEndpoint;
    private final transient Address defaultAddress;
    private final transient int ERROR_EVENT_ID = -1;

    public EventSenderImpl(EventLookupFacility eventLookupFacility, SleeEndpoint sleeEndpoint, Address defaultAddress) {
        this.eventLookupFacility = eventLookupFacility;
        this.sleeEndpoint = sleeEndpoint;
        this.defaultAddress = defaultAddress;
    }

    public void sendEvent(ResourceEvent event, ActivityHandle activityHandle) {
        try {
            int eventID = this.eventLookupFacility.getEventID(event.getClass().getName(), "org.mobicents", "4.2");
            if (eventID != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Firing event " + event));
                }
                this.sleeEndpoint.fireEvent(activityHandle, (Object)event, eventID, this.defaultAddress);
            } else {
                logger.error((Object)("Lookup failed for event name " + event.getClass().getName()));
            }
        }
        catch (UnrecognizedEventException e) {
            logger.error((Object)("Failed to send event due to unrecognized event " + event), (Throwable)e);
        }
        catch (UnrecognizedActivityException e) {
            logger.error((Object)("Failed to send event due to unrecognized activity " + event), (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Failed to send event " + event), (Throwable)e);
        }
    }

    public EventLookupFacility getEventLookupFacility() {
        return this.eventLookupFacility;
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }
}

