/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpInterface;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_ASSIGNMENT_ID;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_EVENT_TYPE;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.P_UNSUPPORTED_ADDRESS_PLAN;
import org.csapi.TpAddressRange;
import org.csapi.TpCommonExceptions;
import org.csapi.cc.TpCallLoadControlMechanism;
import org.csapi.cc.gccs.IpAppCall;
import org.csapi.cc.gccs.IpAppCallControlManager;
import org.csapi.cc.gccs.IpAppCallControlManagerHelper;
import org.csapi.cc.gccs.IpAppCallHelper;
import org.csapi.cc.gccs.IpCallControlManager;
import org.csapi.cc.gccs.TpCallEventCriteria;
import org.csapi.cc.gccs.TpCallEventCriteriaResult;
import org.csapi.cc.gccs.TpCallEventInfo;
import org.csapi.cc.gccs.TpCallIdentifier;
import org.csapi.cc.gccs.TpCallTreatment;
import org.mobicents.csapi.jr.slee.TpServiceIdentifier;
import org.mobicents.csapi.jr.slee.cc.gccs.CallAbortedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallEventNotifyEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallNotificationContinuedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallNotificationInterruptedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallOverloadCeasedEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.CallOverloadEncounteredEvent;
import org.mobicents.csapi.jr.slee.cc.gccs.IpCallConnection;
import org.mobicents.slee.resource.parlay.csapi.jr.ParlayServiceActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.GccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.IpAppCallControlManagerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.IpAppCallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.IpCallConnectionImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call.Call;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.call.CallImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManager;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.ResourceIDFactory;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.corba.POAFactory;
import org.mobicents.slee.resource.parlay.util.corba.PolicyFactory;
import org.mobicents.slee.resource.parlay.util.corba.ServantActivationHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class CallControlManagerImpl
implements CallControlManager {
    private static final Log logger = LogFactory.getLog(CallControlManagerImpl.class);
    private static final String CALLBACK_FAILED = "Failed to set manager callback.";
    private final transient Map callMap;
    private final transient TpServiceIdentifier serviceIdentifier;
    private final transient Executor ipAppCallControlManagerExecutor;
    private final transient Executor[] ipAppCallExecutors;
    private final transient FwSession fwSession;
    private final transient ActivityManager activityManager;
    private final transient ActivityHandle activityHandle;
    private transient GccsListener eventListener;
    private transient POA ipAppCallControlManagerPOA;
    private transient POA ipAppCallPOA;
    private transient IpAppCallControlManagerImpl ipAppCallControlManagerImpl;
    private transient IpAppCallImpl ipAppCallImpl;
    private transient IpAppCallControlManager ipAppCallControlManager;
    private transient IpAppCall ipAppCall;
    private transient IpCallControlManager ipCallControlManager;
    private final transient ThreadFactory threadFactory;
    private static final int NUM_EXECUTORS = 20;
    private static final int THREAD_POOL_SIZE = 20;

    public CallControlManagerImpl(FwSession fwSession, IpCallControlManager ipCallControlManager, GccsListener eventListener, ActivityManager activityManager, TpServiceIdentifier serviceIdentifier) {
        this.fwSession = fwSession;
        this.ipCallControlManager = ipCallControlManager;
        this.eventListener = eventListener;
        this.activityManager = activityManager;
        this.serviceIdentifier = serviceIdentifier;
        this.callMap = new HashMap();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initialising threadpool with size 20");
        }
        this.ipAppCallControlManagerExecutor = new PooledExecutor(20);
        this.threadFactory = new ThreadFactory(){
            ThreadGroup threadGroup = new ThreadGroup("GCCS-ThreadGroup");
            final SynchronizedInt i = new SynchronizedInt(0);

            public Thread newThread(Runnable runnable) {
                return new Thread(this.threadGroup, runnable, "GCCS-Thread-" + this.i.increment());
            }
        };
        ((PooledExecutor)this.ipAppCallControlManagerExecutor).setThreadFactory(this.threadFactory);
        ((PooledExecutor)this.ipAppCallControlManagerExecutor).setKeepAliveTime(-1L);
        this.ipAppCallExecutors = new Executor[20];
        for (int i = 0; i < 20; ++i) {
            this.ipAppCallExecutors[i] = new QueuedExecutor();
            ((QueuedExecutor)this.ipAppCallExecutors[i]).setThreadFactory(this.threadFactory);
        }
        this.activityHandle = new ParlayServiceActivityHandle(this.serviceIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ResourceException {
        Policy[] policies = PolicyFactory.createTransientPoaPolicies(this.fwSession.getRootPOA());
        CallControlManagerImpl callControlManagerImpl = this;
        synchronized (callControlManagerImpl) {
            this.createPOAs(policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activating servants.");
            }
            this.activateIpAppCall();
            this.activateIpAppCallControlManager();
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Setting callback.");
            }
            try {
                this.ipCallControlManager.setCallback((IpInterface)this.ipAppCallControlManager);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)(CALLBACK_FAILED + ParlayExceptionUtil.stringify(e)), (Throwable)e);
                throw new ResourceException(CALLBACK_FAILED, (Throwable)e);
            }
            catch (TpCommonExceptions e) {
                logger.error((java.lang.Object)CALLBACK_FAILED, (Throwable)e);
                throw new ResourceException(CALLBACK_FAILED, (Throwable)e);
            }
            this.activityManager.add(this.activityHandle, this.serviceIdentifier);
            this.activityManager.activityStartedSuspended(this.activityHandle);
        }
    }

    protected void activateIpAppCall() throws ResourceException {
        this.ipAppCallImpl = new IpAppCallImpl(this, this.ipAppCallControlManagerPOA, this.ipAppCallExecutors);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppCallPOA, (Servant)this.ipAppCallImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppCall.");
            }
            this.ipAppCall = IpAppCallHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppCall.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppCall.", (Throwable)e);
        }
    }

    protected void activateIpAppCallControlManager() throws ResourceException {
        this.ipAppCallControlManagerImpl = new IpAppCallControlManagerImpl(this, this.ipAppCallControlManagerPOA, this.ipAppCallControlManagerExecutor);
        try {
            Object tmpRef = ServantActivationHelper.activateServant(this.ipAppCallControlManagerPOA, (Servant)this.ipAppCallControlManagerImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Activated ipAppCallControlManager.");
            }
            this.ipAppCallControlManager = IpAppCallControlManagerHelper.narrow((Object)tmpRef);
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to activate ipAppCallControlManager.", (Throwable)e);
            throw new ResourceException("Failed to activate ipAppCallControlManager.", (Throwable)e);
        }
    }

    protected void createPOAs(Policy[] policies) throws ResourceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Creating GCCS POAs.");
            }
            this.ipAppCallControlManagerPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppCallControlManagerPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppCallControlManagerPOA_" + this.serviceIdentifier.getServiceID()));
            }
            this.ipAppCallPOA = POAFactory.createPOA(this.fwSession.getRootPOA(), "ipAppCallPOA_" + this.serviceIdentifier.getServiceID(), this.fwSession.getRootPOA().the_POAManager(), policies);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Created ipAppCallPOA_" + this.serviceIdentifier.getServiceID()));
            }
        }
        catch (UserException e) {
            logger.error((java.lang.Object)"Failed to initialise POAs.", (Throwable)e);
            throw new ResourceException("Failed to initialise POAs.", (Throwable)e);
        }
    }

    protected void deactivateIpAppCall() {
        if (this.ipAppCallImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppCallImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppCall servant.", (Throwable)e);
            }
            this.ipAppCallImpl.dispose();
            this.ipAppCall = null;
            this.ipAppCallImpl = null;
        }
    }

    protected void deactivateIpAppCallControlManager() {
        if (this.ipAppCallControlManagerImpl != null) {
            try {
                ServantActivationHelper.deactivateServant((Servant)this.ipAppCallControlManagerImpl);
            }
            catch (UserException e) {
                logger.error((java.lang.Object)"Failed to deactivate IpAppCall servant.", (Throwable)e);
            }
            this.ipAppCallControlManagerImpl.dispose();
            this.ipAppCallControlManagerImpl = null;
            this.ipAppCallControlManager = null;
        }
    }

    public void destroy() {
        this.ipCallControlManager = null;
        this.ipAppCall = null;
        Collection calls = this.callMap.values();
        for (Call call : calls) {
            call.dispose();
        }
        this.callMap.clear();
        this.deactivateIpAppCall();
        this.deactivateIpAppCallControlManager();
        this.destroyPOAs();
        this.eventListener = null;
    }

    private void destroyPOAs() {
        if (this.ipAppCallPOA != null) {
            POAFactory.destroyPOA(this.ipAppCallPOA);
            this.ipAppCallPOA = null;
        }
        if (this.ipAppCallControlManagerPOA != null) {
            POAFactory.destroyPOA(this.ipAppCallControlManagerPOA);
            this.ipAppCallControlManagerPOA = null;
        }
    }

    public Call getCall(int callSessionID) {
        return (Call)this.callMap.get(new Integer(callSessionID));
    }

    public Call removeCall(int callSessionID) {
        return (Call)this.callMap.remove(new Integer(callSessionID));
    }

    public void addCall(int callSessionID, Call call) {
        this.callMap.put(new Integer(callSessionID), call);
    }

    public Call createCall(TpCallIdentifier corbaTpCallIdentifier) {
        int callID = ResourceIDFactory.getNextID();
        org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier callIdentifier = new org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier(callID, corbaTpCallIdentifier.CallSessionID);
        CallImpl call = new CallImpl(this, corbaTpCallIdentifier.CallReference, corbaTpCallIdentifier.CallSessionID, callIdentifier, this.activityManager, this.eventListener);
        call.init();
        this.addCall(corbaTpCallIdentifier.CallSessionID, call);
        this.activityManager.add(call.getActivityHandle(), call.getTpCallIdentifier());
        this.activityManager.activityStartedSuspended(call.getActivityHandle());
        return call;
    }

    public void callAborted(int callReference) {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            CallAbortedEvent event = null;
            Call call = this.getCall(callReference);
            if (call != null) {
                event = new CallAbortedEvent(this.serviceIdentifier, call.getTpCallIdentifier());
                this.eventListener.onCallAbortedEvent(event);
                this.activityManager.remove(call.getActivityHandle(), call.getTpCallIdentifier());
                this.activityManager.activityEnding(call.getActivityHandle());
                call.dispose();
            }
        }
    }

    public void callEventNotify(org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier callReference, TpCallEventInfo eventInfo, int assignmentID) {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            Call call = this.getCall(callReference.getCallSessionID());
            if (call != null) {
                this.activityManager.add(call.getActivityHandle(), call.getTpCallIdentifier());
                this.activityManager.activityStarted(this.activityHandle);
            }
            CallEventNotifyEvent event = new CallEventNotifyEvent(this.serviceIdentifier, callReference, eventInfo, assignmentID);
            this.eventListener.onCallEventNotifiyEvent(event);
        }
    }

    public void callNotificationInterrupted() {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            CallNotificationInterruptedEvent event = new CallNotificationInterruptedEvent(this.serviceIdentifier);
            this.eventListener.onCallNotificationInterruptedEvent(event);
        }
    }

    public void callNotificationContinued() {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            CallNotificationContinuedEvent event = new CallNotificationContinuedEvent(this.serviceIdentifier);
            this.eventListener.onCallNotificationContinuedEvent(event);
        }
    }

    public void callOverloadEncountered(int assignmentID) {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            CallOverloadEncounteredEvent event = new CallOverloadEncounteredEvent(this.serviceIdentifier, assignmentID);
            this.eventListener.onCallOverloadEncounteredEvent(event);
        }
    }

    public void callOverloadCeased(int assignmentID) {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            CallOverloadCeasedEvent event = new CallOverloadCeasedEvent(this.serviceIdentifier, assignmentID);
            this.eventListener.onCallOverloadCeasedEvent(event);
        }
    }

    public IpCallConnection getIpCallConnection(org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier callIdentifier) throws ResourceException {
        Call call = this.getCall(callIdentifier.getCallSessionID());
        if (call != null) {
            return new IpCallConnectionImpl(call);
        }
        throw new ResourceException("Unrecognized TpCallIdentifier");
    }

    public org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier createCall() throws TpCommonExceptions, ResourceException {
        org.mobicents.csapi.jr.slee.cc.gccs.TpCallIdentifier result = null;
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            try {
                TpCallIdentifier callReference = callControlManager.createCall(this.getIpAppCall());
                result = this.createCall(callReference).getTpCallIdentifier();
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
            }
        }
        return result;
    }

    public int enableCallNotification(TpCallEventCriteria eventCriteria) throws ResourceException, P_INVALID_EVENT_TYPE, TpCommonExceptions, P_INVALID_CRITERIA {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        int result = 0;
        if (callControlManager != null) {
            try {
                result = callControlManager.enableCallNotification(this.getIpAppCallControlManager(), eventCriteria);
            }
            catch (P_INVALID_INTERFACE_TYPE e) {
                logger.error((java.lang.Object)ParlayExceptionUtil.stringify(e), (Throwable)e);
                throw new ResourceException("Unexpected Parlay exception", (Throwable)e);
            }
        }
        return result;
    }

    public void disableCallNotification(int assignmentID) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, ResourceException {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            callControlManager.disableCallNotification(assignmentID);
        }
    }

    public int setCallLoadControl(int duration, TpCallLoadControlMechanism mechanism, TpCallTreatment treatment, TpAddressRange addressRange) throws TpCommonExceptions, P_INVALID_ADDRESS, P_UNSUPPORTED_ADDRESS_PLAN, ResourceException {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        int result = 0;
        if (callControlManager != null) {
            result = callControlManager.setCallLoadControl(duration, mechanism, treatment, addressRange);
        }
        return result;
    }

    public void changeCallNotification(int assignmentID, TpCallEventCriteria eventCriteria) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, P_INVALID_CRITERIA, P_INVALID_EVENT_TYPE, ResourceException {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        if (callControlManager != null) {
            callControlManager.changeCallNotification(assignmentID, eventCriteria);
        }
    }

    public TpCallEventCriteriaResult[] getCriteria() throws TpCommonExceptions, ResourceException {
        IpCallControlManager callControlManager = this.getIpCallControlManager();
        TpCallEventCriteriaResult[] result = null;
        if (callControlManager != null) {
            result = callControlManager.getCriteria();
        }
        return result;
    }

    public void closeConnection() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public IpAppCall getIpAppCall() {
        return this.ipAppCall;
    }

    public TpServiceIdentifier getTpServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public int getType() {
        return 2;
    }

    public IpAppCallControlManagerImpl getIpAppCallControlManagerImpl() {
        return this.ipAppCallControlManagerImpl;
    }

    public IpAppCallImpl getIpAppCallImpl() {
        return this.ipAppCallImpl;
    }

    public IpCallControlManager getIpCallControlManager() {
        return this.ipCallControlManager;
    }

    public IpAppCallControlManager getIpAppCallControlManager() {
        return this.ipAppCallControlManager;
    }
}

