/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util;

public class Convert {
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Convert() {
    }

    public static String toHexString(byte b) {
        return Integer.toString((b & 0xFF) + 256, 16).substring(1);
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            b[j] = (byte)(Convert.charToNibble(s.charAt(i)) << 4 | Convert.charToNibble(s.charAt(i + 1)));
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static boolean assertEquals(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] toByteArray(int x) {
        byte[] oid = new byte[]{(byte)(x >> 24 & 0xFF), (byte)(x >> 16 & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF)};
        return oid;
    }
}

