/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.corba;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NamingServiceHelper {
    private static final Log logger = LogFactory.getLog(NamingServiceHelper.class);

    public static NamingContextExt getNamingService(ORB orb, String host, int port) throws IOException {
        NamingContextExt result = null;
        String ior = "";
        ior = NamingServiceHelper.readIORFromSocket(host, port);
        Object objref = orb.string_to_object(ior);
        result = NamingContextExtHelper.narrow((Object)objref);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readIORFromSocket(String host, int port) throws UnknownHostException, IOException {
        String ior = "";
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Reading IOR from " + host + ":" + port));
        }
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            DataInputStream dis = new DataInputStream(socket.getInputStream());
            int n = 1000;
            byte[] stringifiedIOR = new byte[n];
            while ((n = dis.read(stringifiedIOR)) > 0) {
                ior = ior + new String(stringifiedIOR, 0, n);
            }
            ior = ior.substring(0, ior.length() - 1);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Stringified IOR :  " + ior));
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                    socket = null;
                }
                catch (RuntimeException ex) {
                    socket = null;
                }
            }
        }
        return ior;
    }

    public static NamingContextExt getDefaultNamingService(ORB orb) throws org.omg.CORBA.ORBPackage.InvalidName {
        NamingContextExt result = null;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Obtaining reference to the NameService ...");
        }
        Object objref = orb.resolve_initial_references("NameService");
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Narrowing to a NamingContextExt ....");
        }
        result = NamingContextExtHelper.narrow((Object)objref);
        return result;
    }

    public static NamingContextExt getNamingService(ORB orb, String nsIOR) throws org.omg.CORBA.ORBPackage.InvalidName {
        NamingContextExt result = null;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Obtaining reference to the NameService ...");
        }
        Object objref = orb.string_to_object(nsIOR);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Narrowing to a NamingContextExt ....");
        }
        result = NamingContextExtHelper.narrow((Object)objref);
        return result;
    }

    public static Object getCorbaObjectReference(String objectName, NamingContextExt namingContextExt) throws CannotProceed, NotFound, InvalidName {
        Object result = null;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Resolving the supplied string name... <" + objectName + ">"));
        }
        NameComponent[] tmpName = namingContextExt.to_name(objectName);
        result = namingContextExt.resolve(tmpName);
        return result;
    }
}

