/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay;

import java.io.Serializable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.parlay.ParlayActivityContextInterfaceFactory;
import org.mobicents.slee.resource.parlay.ParlayActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.parlay.ParlayMarshaler;
import org.mobicents.slee.resource.parlay.ParlayProvider;
import org.mobicents.slee.resource.parlay.ParlayProviderImpl;
import org.mobicents.slee.resource.parlay.ParlayResourceAdaptorProperties;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManagerImpl;

public class ParlayResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static final String SERVICE_KEY = "serviceKey = ";
    private static final String FLAGS = "flags = ";
    private static final String ADDRESS = "address = ";
    private static final String PARAM = "param = ";
    private static final String OBJ = "obj = ";
    private static final String ACTIVITY_HANDLE = "activityHandle = ";
    public static final String VENDOR = "org.mobicents";
    public static final String VERSION = "4.2";
    private static final String CREATED_PARLAY_RESOURCE_ADAPTER = "Created Parlay Resource Adapter";
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient ParlayActivityContextInterfaceFactory activityConextInterfaceFactory = null;
    private transient ParlayProvider parlayProvider = null;
    private final transient ParlayResourceAdaptorProperties adaptorProperties;
    private transient ActivityManager activityManager = null;
    private transient Marshaler marshaler = null;
    private static final Log logger = LogFactory.getLog(ParlayResourceAdaptor.class);

    public ParlayResourceAdaptor(Properties properties) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdaptor(Properties properties) called.");
        }
        this.adaptorProperties = new ParlayResourceAdaptorProperties();
        try {
            this.adaptorProperties.load(properties);
        }
        catch (ResourceException e) {
            logger.error((Object)"Failed to load specified properties. Loading defaults ...");
            try {
                this.adaptorProperties.loadDefaults();
            }
            catch (ResourceException e1) {
                logger.fatal((Object)"Failed to load default properties.");
            }
        }
        logger.info((Object)CREATED_PARLAY_RESOURCE_ADAPTER);
    }

    public ParlayResourceAdaptor(String ipInitialIOR, String namingServiceIOR, String ipInitialLocation, String ipInitialURL, String domainID, String authenticationSequence) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdaptor(String ipInitialIOR, String namingServiceIOR, String ipInitialLocation, String ipInitialURL, String domainID, String authenticationSequence) called.");
        }
        this.adaptorProperties = new ParlayResourceAdaptorProperties();
        this.adaptorProperties.setIpInitialIOR(ipInitialIOR);
        this.adaptorProperties.setNamingServiceIOR(namingServiceIOR);
        this.adaptorProperties.setIpInitialLocation(ipInitialLocation);
        this.adaptorProperties.setIpInitialURL(ipInitialURL);
        if (!this.adaptorProperties.isIpInitialConfigValid()) {
            logger.error((Object)"Invalid properties. Loading defaults ...");
            try {
                this.adaptorProperties.loadDefaults();
            }
            catch (ResourceException e1) {
                logger.fatal((Object)"Failed to load default properties.");
            }
        }
        this.adaptorProperties.setDomainID(domainID);
        this.adaptorProperties.setAuthenticationSequence(authenticationSequence);
        logger.info((Object)CREATED_PARLAY_RESOURCE_ADAPTER);
    }

    public ParlayResourceAdaptor() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdaptor() called.");
        }
        this.adaptorProperties = new ParlayResourceAdaptorProperties();
        try {
            this.adaptorProperties.loadDefaults();
        }
        catch (ResourceException e) {
            logger.fatal((Object)"Failed to load default properties.");
        }
        logger.info((Object)CREATED_PARLAY_RESOURCE_ADAPTER);
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.entityCreated()");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
    }

    public void entityRemoved() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.entityRemoved()");
        }
        this.bootstrapContext = null;
        this.sleeEndpoint = null;
    }

    public void entityActivated() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.entityActivated()");
        }
        try {
            this.initializeRAActivityContextInterfaceFactory();
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to init ResourceAdapterActivityContextInterfaceFactory");
            throw new ResourceException("Failed to init ResourceAdapterActivityContextInterfaceFactory", (Throwable)e);
        }
        this.registerRAActivityContextInterfaceFactoryWithJndi((ResourceAdaptorActivityContextInterfaceFactory)this.activityConextInterfaceFactory);
        this.activityManager = new ActivityManagerImpl(this.sleeEndpoint);
        this.parlayProvider = new ParlayProviderImpl(this.bootstrapContext, this.adaptorProperties, this.activityManager);
        this.parlayProvider.start();
        this.marshaler = new ParlayMarshaler();
    }

    public void entityDeactivating() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.entityDeactivating()");
        }
        try {
            this.parlayProvider.stop();
        }
        catch (ResourceException e) {
            logger.error((Object)"Problem stopping Parlay Provider.", (Throwable)e);
        }
    }

    public void entityDeactivated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.entityDeactivated()");
        }
        this.unRegisterRAActivityContextInterfaceFactoryWithJndi((ResourceAdaptorActivityContextInterfaceFactory)this.activityConextInterfaceFactory);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter stopped.");
        }
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object obj, int param, Address address, int flags) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.eventProcessingSuccessful()");
            logger.debug((Object)(ACTIVITY_HANDLE + activityHandle));
            logger.debug((Object)(OBJ + obj));
            logger.debug((Object)(PARAM + param));
            logger.debug((Object)(ADDRESS + address));
            logger.debug((Object)(FLAGS + flags));
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object obj, int param, Address address, int flags, FailureReason failureReason) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.eventProcessingFailed()");
            logger.debug((Object)(ACTIVITY_HANDLE + activityHandle));
            logger.debug((Object)(OBJ + obj));
            logger.debug((Object)(PARAM + param));
            logger.debug((Object)(ADDRESS + address));
            logger.debug((Object)(FLAGS + flags));
            logger.debug((Object)("failureReason = " + failureReason));
        }
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.activityEnded()");
            logger.debug((Object)(ACTIVITY_HANDLE + activityHandle));
        }
        this.activityManager.activityEnded(activityHandle);
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.activityUnreferenced()");
            logger.debug((Object)(ACTIVITY_HANDLE + activityHandle));
        }
        this.activityManager.activityUnreferenced(activityHandle);
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.queryLiveness()");
            logger.debug((Object)(ACTIVITY_HANDLE + activityHandle));
        }
        this.activityManager.queryLiveness(activityHandle);
    }

    public Object getActivity(ActivityHandle handle) {
        return this.activityManager.getActivity(handle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return this.activityManager.getActivityHandle(arg0);
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this.parlayProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] serviceOptions) {
        if (logger.isDebugEnabled()) {
            int i;
            logger.debug((Object)"ParlayResourceAdapter.serviceInstalled()");
            logger.debug((Object)(SERVICE_KEY + serviceKey));
            for (i = 0; i < eventIDs.length; ++i) {
                logger.debug((Object)("eventIDs[" + i + "] = " + eventIDs[i]));
            }
            for (i = 0; i < serviceOptions.length; ++i) {
                logger.debug((Object)("serviceOptions[" + i + "] = " + serviceOptions[i]));
            }
        }
    }

    public void serviceUninstalled(String serviceKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.serviceUninstalled()");
            logger.debug((Object)(SERVICE_KEY + serviceKey));
        }
    }

    public void serviceActivated(String serviceKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.serviceActivated()");
            logger.debug((Object)(SERVICE_KEY + serviceKey));
        }
    }

    public void serviceDeactivated(String serviceKey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ParlayResourceAdapter.serviceDeactivated()");
            logger.debug((Object)(SERVICE_KEY + serviceKey));
        }
    }

    private void initializeRAActivityContextInterfaceFactory() throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing RA ActivityContextInterfaceFactory");
        }
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.activityConextInterfaceFactory = new ParlayActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.activityConextInterfaceFactory);
    }

    private void registerRAActivityContextInterfaceFactoryWithJndi(ResourceAdaptorActivityContextInterfaceFactory factory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering ResourceAdaptorActivityContextInterfaceFactory in JNDI");
        }
        try {
            if (factory != null) {
                String jndiName = factory.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.activityConextInterfaceFactory);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.error((Object)"Failed to register ResourceAdaptorActivityContextInterfaceFactory in JNDI", (Throwable)e);
        }
    }

    private void unRegisterRAActivityContextInterfaceFactoryWithJndi(ResourceAdaptorActivityContextInterfaceFactory factory) {
        if (factory != null) {
            String jndiName = factory.getJndiName();
            int begind = jndiName.indexOf(58);
            int toind = jndiName.lastIndexOf(47);
            String prefix = jndiName.substring(begind + 1, toind);
            String name = jndiName.substring(toind + 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JNDI name to unregister: prefix =" + prefix + "; jndiName = " + name));
            }
            SleeContainer.unregisterWithJndi((String)prefix, (String)name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"JNDI name unregistered.");
            }
        }
    }
}

