/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay;

import java.io.IOException;
import java.util.Properties;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParlayResourceAdaptorProperties {
    private static final Log logger = LogFactory.getLog(ParlayResourceAdaptorProperties.class);
    private transient String ipInitialIOR;
    private transient String namingServiceIOR;
    private transient String ipInitialLocation;
    private transient String ipInitialURL;
    private transient String domainID;
    private transient String authenticationSequence;
    private transient String parlayVersion;
    private transient String sharedSecret;

    public String toString() {
        StringBuffer result = new StringBuffer("ParlayResourceAdaptorProperties:");
        result.append("IpInitialIOR,").append(this.namingServiceIOR).append(';').append("NamingServiceIOR,").append(this.ipInitialIOR).append(';').append("IpInitialLocation,").append(this.ipInitialLocation).append(';').append("IpInitialURL,").append(this.ipInitialURL).append(';').append("domainID,").append(this.domainID).append(';').append("authenticationSequence,").append(this.authenticationSequence).append(';').append(this.parlayVersion).append(';').append(this.sharedSecret);
        return result.toString();
    }

    public String getIpInitialLocation() {
        return this.ipInitialLocation;
    }

    public void setIpInitialLocation(String ipInitialLocation) {
        this.ipInitialLocation = ipInitialLocation;
    }

    public String getIpInitialURL() {
        return this.ipInitialURL;
    }

    public void setIpInitialURL(String ipInitialURL) {
        this.ipInitialURL = ipInitialURL;
    }

    public String getNamingServiceIOR() {
        return this.namingServiceIOR;
    }

    public void setNamingServiceIOR(String namingServiceIOR) {
        this.namingServiceIOR = namingServiceIOR;
    }

    public void loadDefaults() throws ResourceException {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("ParlayResourceAdaptor.properties"));
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load default properties", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading default PARLAY RA properties: " + properties));
        }
        this.load(properties);
    }

    public void load(Properties properties) throws ResourceException {
        this.setIpInitialIOR(properties.getProperty("org.mobicents.slee.resource.parlay.ipInitialIOR"));
        this.setIpInitialLocation(properties.getProperty("org.mobicents.slee.resource.parlay.ipInitialLocation"));
        this.setIpInitialURL(properties.getProperty("org.mobicents.slee.resource.parlay.ipInitialURL"));
        this.setNamingServiceIOR(properties.getProperty("org.mobicents.slee.resource.parlay.namingServiceIOR"));
        if (!this.isIpInitialConfigValid()) {
            throw new ResourceException("IpInitial configuration is invalid.");
        }
        this.setDomainID(properties.getProperty("org.mobicents.slee.resource.parlay.domainID"));
        this.setAuthenticationSequence(properties.getProperty("org.mobicents.slee.resource.parlay.authenticationSequence"));
        this.setParlayVersion(properties.getProperty("org.mobicents.slee.resource.parlay.fw.parlayVersion"));
        this.setSharedSecret(properties.getProperty("org.mobicents.slee.resource.parlay.fw.sharedSecret"));
    }

    public String getAuthenticationSequence() {
        return this.authenticationSequence;
    }

    public void setAuthenticationSequence(String authenticationSequence) {
        this.authenticationSequence = authenticationSequence;
    }

    public String getDomainID() {
        return this.domainID;
    }

    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    public String getIpInitialIOR() {
        return this.ipInitialIOR;
    }

    public void setIpInitialIOR(String ipInitialIOR) {
        this.ipInitialIOR = ipInitialIOR;
    }

    public boolean isIpInitialConfigValid() {
        return this.ipInitialIOR != null && this.ipInitialIOR != "" || this.ipInitialLocation != null && this.ipInitialLocation != "" && this.namingServiceIOR != null && this.namingServiceIOR != "" || this.ipInitialURL != null && this.ipInitialURL != "";
    }

    public String getParlayVersion() {
        return this.parlayVersion;
    }

    public void setParlayVersion(String parlayVersion) {
        this.parlayVersion = parlayVersion;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }
}

