/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui;

import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.P_INVALID_ADDRESS;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.TpCommonExceptions;
import org.csapi.ui.IpUI;
import org.csapi.ui.P_ID_NOT_FOUND;
import org.csapi.ui.P_ILLEGAL_ID;
import org.csapi.ui.P_ILLEGAL_RANGE;
import org.csapi.ui.P_INVALID_COLLECTION_CRITERIA;
import org.csapi.ui.TpUICollectCriteria;
import org.csapi.ui.TpUIInfo;
import org.csapi.ui.TpUIVariableInfo;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.UiListener;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.AbstractUI;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public abstract class AbstractUIImpl
implements AbstractUI {
    public static final String UI_NOT_VALID = "UI session is no longer valid.";
    private int userInteractionSessionID;
    private ActivityManager activityManager;
    private UiListener eventListener;
    private ActivityHandle activityHandle;
    private UIManager uiManager;
    private static final Log logger = LogFactory.getLog(AbstractUIImpl.class);

    public abstract IpUI getIpUI();

    public AbstractUIImpl(UIManager uiManager, int userInteractionSessionID, ActivityManager activityManager, UiListener eventListener, ActivityHandle activityHandle) {
        this.setUiManager(uiManager);
        this.setUserInteractionSessionID(userInteractionSessionID);
        this.setActivityManager(activityManager);
        this.setEventListener(eventListener);
        this.setActivityHandle(activityHandle);
    }

    private void setUserInteractionSessionID(int userInteractionSessionID) {
        this.userInteractionSessionID = userInteractionSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractUIImpl abstractUIImpl = this;
        synchronized (abstractUIImpl) {
            if (this.getUiManager() != null) {
                this.getUiManager().removeUI(this.getUserInteractionSessionID());
                this.setUiManager(null);
            }
            this.setEventListener(null);
        }
    }

    public final ActivityHandle getActivityHandle() {
        return this.activityHandle;
    }

    protected void setActivityHandle(ActivityHandle activityHandle) {
        this.activityHandle = activityHandle;
    }

    public void closeConnection() throws ResourceException {
    }

    public final int sendInfoReq(TpUIInfo info, String language, TpUIVariableInfo[] variableInfo, int repeatIndicator, int responseRequested) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, P_ILLEGAL_ID, P_ID_NOT_FOUND, ResourceException {
        IpUI ui = this.getIpUI();
        int assignmentID = 0;
        try {
            assignmentID = ui.sendInfoReq(this.getUserInteractionSessionID(), info, language, variableInfo, repeatIndicator, responseRequested);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UI_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UI_NOT_VALID);
        }
        return assignmentID;
    }

    public final int sendInfoAndCollectReq(TpUIInfo info, String language, TpUIVariableInfo[] variableInfo, TpUICollectCriteria criteria, int responseRequested) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, P_ILLEGAL_ID, P_ID_NOT_FOUND, P_ILLEGAL_RANGE, P_INVALID_COLLECTION_CRITERIA, ResourceException {
        IpUI ui = this.getIpUI();
        int assignmentID = 0;
        try {
            assignmentID = ui.sendInfoAndCollectReq(this.getUserInteractionSessionID(), info, language, variableInfo, criteria, responseRequested);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UI_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UI_NOT_VALID);
        }
        return assignmentID;
    }

    public final void setOriginatingAddress(String origin) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, P_INVALID_ADDRESS, ResourceException {
        IpUI ui = this.getIpUI();
        try {
            ui.setOriginatingAddress(this.getUserInteractionSessionID(), origin);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UI_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UI_NOT_VALID);
        }
    }

    public final String getOriginatingAddress() throws TpCommonExceptions, P_INVALID_NETWORK_STATE, ResourceException {
        String result;
        IpUI ui = this.getIpUI();
        try {
            result = ui.getOriginatingAddress(this.getUserInteractionSessionID());
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UI_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UI_NOT_VALID);
        }
        return result;
    }

    protected void setUiManager(UIManager uiManager) {
        this.uiManager = uiManager;
    }

    protected UIManager getUiManager() {
        return this.uiManager;
    }

    protected void setEventListener(UiListener eventListener) {
        this.eventListener = eventListener;
    }

    public UiListener getEventListener() {
        return this.eventListener;
    }

    protected void setActivityManager(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    protected ActivityManager getActivityManager() {
        return this.activityManager;
    }

    protected int getUserInteractionSessionID() {
        return this.userInteractionSessionID;
    }
}

