/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uicall;

import javax.slee.resource.ResourceException;
import org.apache.log4j.Logger;
import org.csapi.P_INVALID_ASSIGNMENT_ID;
import org.csapi.P_INVALID_CRITERIA;
import org.csapi.P_INVALID_NETWORK_STATE;
import org.csapi.P_INVALID_SESSION_ID;
import org.csapi.TpCommonExceptions;
import org.csapi.ui.IpUI;
import org.csapi.ui.IpUICall;
import org.csapi.ui.P_ID_NOT_FOUND;
import org.csapi.ui.P_ILLEGAL_ID;
import org.csapi.ui.TpUIError;
import org.csapi.ui.TpUIFault;
import org.csapi.ui.TpUIInfo;
import org.csapi.ui.TpUIMessageCriteria;
import org.csapi.ui.TpUIReport;
import org.mobicents.csapi.jr.slee.ui.AbortActionErrEvent;
import org.mobicents.csapi.jr.slee.ui.AbortActionResEvent;
import org.mobicents.csapi.jr.slee.ui.DeleteMessageErrEvent;
import org.mobicents.csapi.jr.slee.ui.DeleteMessageResEvent;
import org.mobicents.csapi.jr.slee.ui.RecordMessageErrEvent;
import org.mobicents.csapi.jr.slee.ui.RecordMessageResEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoAndCollectErrEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoAndCollectResEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoErrEvent;
import org.mobicents.csapi.jr.slee.ui.SendInfoResEvent;
import org.mobicents.csapi.jr.slee.ui.TpUICallIdentifier;
import org.mobicents.csapi.jr.slee.ui.UserInteractionFaultDetectedEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.TpUICallActivityHandle;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.UiListener;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.ui.AbstractUIImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uicall.UICall;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;

public class UICallImpl
extends AbstractUIImpl
implements UICall {
    private static final Logger logger = Logger.getLogger(UICallImpl.class);
    private static final String UICALL_NOT_VALID = "UICall session is no longer valid.";
    private final transient IpUICall ipUICall;
    private final transient TpUICallIdentifier tpUICallIdentifier;

    public UICallImpl(UIManager manager, IpUICall ipUICall, int userInteractionSessionID, TpUICallIdentifier sleeTpUICallIdentifier, ActivityManager activityManager, UiListener eventListener) {
        super(manager, userInteractionSessionID, activityManager, eventListener, new TpUICallActivityHandle(sleeTpUICallIdentifier));
        this.ipUICall = ipUICall;
        this.tpUICallIdentifier = sleeTpUICallIdentifier;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UICallImpl activity created for userInteractionSessionID =[" + userInteractionSessionID + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpUICall getIpUICall() {
        UICallImpl uICallImpl = this;
        synchronized (uICallImpl) {
            return this.ipUICall;
        }
    }

    public TpUICallIdentifier getTpUICallIdentifier() {
        return this.tpUICallIdentifier;
    }

    public void init() {
    }

    public final int recordMessageReq(TpUIInfo info, TpUIMessageCriteria criteria) throws TpCommonExceptions, P_INVALID_NETWORK_STATE, P_ILLEGAL_ID, P_ID_NOT_FOUND, P_INVALID_CRITERIA, ResourceException {
        int assignmentID = 0;
        try {
            assignmentID = this.getIpUICall().recordMessageReq(this.getUserInteractionSessionID(), info, criteria);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UICALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UICALL_NOT_VALID);
        }
        return assignmentID;
    }

    public final int deleteMessageReq(int messageID) throws TpCommonExceptions, P_ILLEGAL_ID, P_ID_NOT_FOUND, ResourceException {
        int assignmentID = 0;
        try {
            assignmentID = this.getIpUICall().deleteMessageReq(this.getUserInteractionSessionID(), messageID);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UICALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UICALL_NOT_VALID);
        }
        return assignmentID;
    }

    public void abortActionReq(int assignmentID) throws TpCommonExceptions, P_INVALID_ASSIGNMENT_ID, ResourceException {
        try {
            this.getIpUICall().abortActionReq(this.getUserInteractionSessionID(), assignmentID);
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UICALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UICALL_NOT_VALID);
        }
    }

    public void recordMessageRes(int userInteractionSessionID, int assignmentID, TpUIReport response, int messageID) {
        if (this.getIpUICall() != null) {
            RecordMessageResEvent event = new RecordMessageResEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, assignmentID, response, messageID);
            this.getEventListener().onRecordMessageResEvent(event);
        }
    }

    public void recordMessageErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUICall() != null) {
            RecordMessageErrEvent event = new RecordMessageErrEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, assignmentID, error);
            this.getEventListener().onRecordMessageErrEvent(event);
        }
    }

    public void deleteMessageRes(int usrInteractionSessionID, TpUIReport response, int assignmentID) {
        if (this.getIpUICall() != null) {
            DeleteMessageResEvent event = new DeleteMessageResEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, response, assignmentID);
            this.getEventListener().onDeleteMessageResEvent(event);
        }
    }

    public void deleteMessageErr(int usrInteractionSessionID, TpUIError error, int assignmentID) {
        if (this.getIpUICall() != null) {
            DeleteMessageErrEvent event = new DeleteMessageErrEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, error, assignmentID);
            this.getEventListener().onDeleteMessageErrEvent(event);
        }
    }

    public void abortActionRes(int userInteractionSessionID, int assignmentID) {
        if (this.getIpUICall() != null) {
            AbortActionResEvent event = new AbortActionResEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, assignmentID);
            this.getEventListener().onAbortActionResEvent(event);
        }
    }

    public void abortActionErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUICall() != null) {
            AbortActionErrEvent event = new AbortActionErrEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, assignmentID, error);
            this.getEventListener().onAbortActionErrEvent(event);
        }
    }

    public final void sendInfoRes(int userInteractionSessionID, int assignmentID, TpUIReport response) {
        if (this.getIpUI() != null) {
            SendInfoResEvent event = new SendInfoResEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, null, assignmentID, response);
            this.getEventListener().onSendInfoResEvent(event);
        }
    }

    public final void sendInfoErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUI() != null) {
            SendInfoErrEvent event = new SendInfoErrEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, null, assignmentID, error);
            this.getEventListener().onSendInfoErrEvent(event);
        }
    }

    public final void sendInfoAndCollectRes(int userInteractionSessionID, int assignmentID, TpUIReport response, String collectedInfo) {
        if (this.getIpUI() != null) {
            SendInfoAndCollectResEvent event = new SendInfoAndCollectResEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, null, assignmentID, response, collectedInfo);
            this.getEventListener().onSendInfoAndCollectResEvent(event);
        }
    }

    public final void sendInfoAndCollectErr(int userInteractionSessionID, int assignmentID, TpUIError error) {
        if (this.getIpUI() != null) {
            SendInfoAndCollectErrEvent event = new SendInfoAndCollectErrEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, null, assignmentID, error);
            this.getEventListener().onSendInfoAndCollectErrEvent(event);
        }
    }

    public final void userInteractionFaultDetected(int userInteractionSessionID, TpUIFault fault) {
        if (this.getIpUI() != null) {
            UserInteractionFaultDetectedEvent event = new UserInteractionFaultDetectedEvent(this.getUiManager().getTpServiceIdentifier(), this.tpUICallIdentifier, null, fault);
            this.getEventListener().onUserInteractionFaultDetectedEvent(event);
            this.getActivityManager().remove(this.getActivityHandle(), this.tpUICallIdentifier);
            this.getActivityManager().activityEnding(this.getActivityHandle());
            this.dispose();
        }
    }

    public IpUI getIpUI() {
        return this.getIpUICall();
    }

    public final void release() throws TpCommonExceptions, ResourceException {
        IpUI ui = this.getIpUI();
        try {
            ui.release(this.getUserInteractionSessionID());
        }
        catch (P_INVALID_SESSION_ID e) {
            logger.warn((Object)(UICALL_NOT_VALID + ParlayExceptionUtil.stringify(e)));
            throw new ResourceException(UICALL_NOT_VALID);
        }
        this.getActivityManager().remove(this.getActivityHandle(), this.tpUICallIdentifier);
        this.getActivityManager().activityEnding(this.getActivityHandle());
        this.dispose();
    }
}

