/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpService;
import org.csapi.TpCommonExceptions;
import org.csapi.fw.P_ACCESS_DENIED;
import org.csapi.fw.P_ILLEGAL_SERVICE_TYPE;
import org.csapi.fw.P_INVALID_PROPERTY;
import org.csapi.fw.P_UNKNOWN_SERVICE_TYPE;
import org.csapi.fw.TpProperty;
import org.csapi.fw.TpService;
import org.csapi.fw.TpServiceProperty;
import org.csapi.fw.fw_application.discovery.IpServiceDiscovery;
import org.mobicents.csapi.jr.slee.fw.TerminateAccessEvent;
import org.mobicents.csapi.jr.slee.fw.TerminateServiceAgreementEvent;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.fw.FwSessionException;
import org.mobicents.slee.resource.parlay.fw.FwSessionListener;
import org.mobicents.slee.resource.parlay.fw.FwSessionProperties;
import org.mobicents.slee.resource.parlay.fw.ServiceAndToken;
import org.mobicents.slee.resource.parlay.fw.TokenAndServiceMap;
import org.mobicents.slee.resource.parlay.fw.access.TSMBean;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanException;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanImpl;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanListener;
import org.mobicents.slee.resource.parlay.fw.application.SABean;
import org.mobicents.slee.resource.parlay.fw.application.SABeanException;
import org.mobicents.slee.resource.parlay.fw.application.SABeanListener;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;

public class FwSessionImpl
implements FwSession,
TSMBeanListener,
SABeanListener {
    private static final Log logger = LogFactory.getLog(FwSessionImpl.class);
    private static final String TERMINATION_TEXT = "FwSession terminating service agreement";
    private static final String AGREEMENT_TEXT = "FwSession signing service agreement";
    private static final String EXCEPTION_INVOKING = "Exception invoking ";
    private static final String SERVICE_DISCOVERY = "org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery";
    private static final String DISCOVER_SERVICE = ".discoverService()";
    private transient Vector fwSessionListeners;
    protected final transient TokenAndServiceMap tokenAndServiceMap;
    protected TSMBean tsmBean = null;
    private final FwSessionProperties fwSessionProperties;
    private IpServiceDiscovery serviceDiscovery = null;

    public FwSessionImpl(FwSessionProperties fwSessionProperties) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"FwSessionImpl created");
        }
        this.fwSessionProperties = fwSessionProperties;
        this.tokenAndServiceMap = new TokenAndServiceMap();
    }

    public void init() throws FwSessionException {
        try {
            this.tsmBean = new TSMBeanImpl(this, this.fwSessionProperties);
            this.tsmBean.initialize();
            this.tsmBean.addTSMBeanListener(this);
        }
        catch (TSMBeanException e) {
            throw new FwSessionException(e);
        }
    }

    public void addFwSessionListener(FwSessionListener listener) {
        Vector v;
        Vector vector = v = this.fwSessionListeners == null ? new Vector(2) : (Vector)this.fwSessionListeners.clone();
        if (!v.contains(listener)) {
            v.addElement(listener);
            this.fwSessionListeners = v;
        }
    }

    public void removeFwSessionListener(FwSessionListener listener) {
        if (this.fwSessionListeners != null && this.fwSessionListeners.contains(listener)) {
            Vector v = (Vector)this.fwSessionListeners.clone();
            v.removeElement(listener);
            this.fwSessionListeners = v;
        }
        if (this.tsmBean != null) {
            this.tsmBean.removeTSMBeanListener(this);
            if (this.tsmBean.getSABean() != null) {
                this.tsmBean.getSABean().removeSABeanListener(this);
            }
        }
    }

    public void authenticate() throws FwSessionException {
        try {
            this.tsmBean.authenticate();
        }
        catch (TSMBeanException ex) {
            logger.error((Object)("TSMBeanException " + ex.toString()));
            if (this.tsmBean.getState() == 2) {
                this.shutdown();
            }
            throw new FwSessionException(ex);
        }
        catch (IllegalStateException ex) {
            logger.error((Object)("IllegalStateException " + ex.toString()));
            throw new FwSessionException(ex);
        }
    }

    public void endAccess(TpProperty[] endAccessProperties) throws FwSessionException {
        try {
            if (this.tsmBean != null) {
                this.tsmBean.endAccess(endAccessProperties);
            }
        }
        catch (TSMBeanException ex) {
            logger.error((Object)("TSMBeanException " + ex.toString()));
            throw new FwSessionException(ex);
        }
        catch (IllegalStateException ex) {
            logger.error((Object)("IllegalStateException " + ex.toString()));
            throw new FwSessionException(ex);
        }
    }

    public ServiceAndToken getService(String serviceTypeName, TpServiceProperty[] serviceProperties) throws FwSessionException {
        SABean saBean = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting service from Gateway ...");
        }
        ServiceAndToken serviceAndToken = null;
        try {
            String serviceID = this.discoverServiceID(serviceTypeName, serviceProperties);
            saBean = this.tsmBean.getSABean();
            if (saBean == null) {
                saBean = this.tsmBean.createSABean();
                saBean.addSABeanListener(this);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Got SABean reference");
                }
                serviceAndToken = saBean.selectAndSignServiceAgreement(serviceID, AGREEMENT_TEXT);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Selected and signed service.");
                }
                this.tokenAndServiceMap.put(serviceAndToken.getServiceToken(), serviceAndToken.getIpService());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Storing service and token :" + serviceAndToken));
                }
            }
        }
        catch (SABeanException ex) {
            throw new FwSessionException("Failed to getService", ex);
        }
        catch (TSMBeanException ex) {
            throw new FwSessionException("Failed to getService", ex);
        }
        catch (IllegalStateException ex) {
            throw new FwSessionException("Failed to getService", ex);
        }
        catch (FwSessionException ex) {
            throw ex;
        }
        return serviceAndToken;
    }

    private String discoverServiceID(String serviceTypeName, TpServiceProperty[] desiredPropertyList) throws FwSessionException {
        String result = null;
        TpService[] serviceList = null;
        boolean MAX_SERVICES = true;
        try {
            if (this.serviceDiscovery == null) {
                this.serviceDiscovery = this.tsmBean.obtainDiscoveryInterface();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Got serviceDiscovery interface.");
                }
            }
            serviceList = this.serviceDiscovery.discoverService(serviceTypeName, desiredPropertyList, 1);
        }
        catch (TpCommonExceptions ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (P_ILLEGAL_SERVICE_TYPE ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (P_UNKNOWN_SERVICE_TYPE ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (P_INVALID_PROPERTY ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((Object)("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService() " + ex.toString()));
            throw new FwSessionException("Exception invoking org::csapi::fw::fw_applications::service_discovery::IpServiceDiscovery.discoverService()", (Exception)((Object)ex));
        }
        catch (TSMBeanException ex) {
            throw new FwSessionException(ex);
        }
        catch (IllegalStateException ex) {
            throw new FwSessionException(ex);
        }
        if (serviceList == null) {
            logger.warn((Object)"Null service list returned");
            throw new FwSessionException("Null service list returned");
        }
        if (serviceList.length == 0) {
            logger.warn((Object)"No services discovered");
            throw new FwSessionException("No services discovered");
        }
        if (serviceList.length != 1) {
            logger.warn((Object)("Framework returned " + serviceList.length + " services, only 1 was requested"));
            throw new FwSessionException("Framework returned " + serviceList.length + " services, only 1 was requested");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting service ID from returned service list.");
        }
        result = serviceList[0].ServiceID;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Shutting down the FwSession...");
        }
        if (this.tsmBean != null) {
            TSMBean tSMBean = this.tsmBean;
            synchronized (tSMBean) {
                SABean saBean = this.tsmBean.getSABean();
                if (saBean != null) {
                    saBean.cleanup();
                    Object var2_2 = null;
                }
            }
            this.tsmBean.shutdown();
            this.tsmBean = null;
        }
        this.tokenAndServiceMap.clear();
        this.serviceDiscovery = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"...FwSession shutdown OK");
        }
    }

    public FwSessionProperties getFwSessionProperties() {
        return this.fwSessionProperties;
    }

    public ORB getORB() {
        return this.tsmBean.getOrbHandler().getOrb();
    }

    public POA getRootPOA() {
        return this.tsmBean.getOrbHandler().getRootPOA();
    }

    public void releaseService(ServiceAndToken service) throws FwSessionException {
        SABean saBean = this.tsmBean.getSABean();
        String serviceToken = service.getServiceToken();
        if (saBean != null) {
            try {
                saBean.terminateServiceAgreement(serviceToken, TERMINATION_TEXT);
                this.removeServiceTokenService(serviceToken);
            }
            catch (SABeanException ex) {
                throw new FwSessionException(ex);
            }
        } else {
            logger.error((Object)"SABean is null cannot terminate service agreement.");
            throw new FwSessionException("SABean is null cannot terminate service agreement.");
        }
    }

    private IpService removeServiceTokenService(String serviceToken) {
        return this.tokenAndServiceMap.remove(serviceToken);
    }

    public void terminateAccess(TerminateAccessEvent event) {
        if (this.fwSessionListeners != null) {
            int count = this.fwSessionListeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((FwSessionListener)this.fwSessionListeners.elementAt(i)).terminateAccess(event);
                    continue;
                }
                catch (RuntimeException ex) {
                    logger.error((Object)("Caught exception invoking application TSMBeanListener " + ex.toString()));
                }
            }
        }
    }

    public void terminateServiceAgreement(TerminateServiceAgreementEvent event) {
        if (this.fwSessionListeners != null) {
            int count = this.fwSessionListeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((FwSessionListener)this.fwSessionListeners.elementAt(i)).terminateServiceAgreement(event);
                    continue;
                }
                catch (RuntimeException ex) {
                    logger.error((Object)("Caught exception invoking application TSMBeanListener " + ex.toString()));
                }
            }
        }
    }
}

