/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw.access;

import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpInterface;
import org.csapi.P_INVALID_INTERFACE_TYPE;
import org.csapi.P_INVALID_VERSION;
import org.csapi.TpCommonExceptions;
import org.csapi.fw.P_ACCESS_DENIED;
import org.csapi.fw.P_INVALID_ACCESS_TYPE;
import org.csapi.fw.P_INVALID_AUTH_TYPE;
import org.csapi.fw.P_INVALID_DOMAIN_ID;
import org.csapi.fw.P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM;
import org.csapi.fw.P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY;
import org.csapi.fw.TpAuthDomain;
import org.csapi.fw.fw_access.trust_and_security.IpAPILevelAuthentication;
import org.csapi.fw.fw_access.trust_and_security.IpAPILevelAuthenticationHelper;
import org.csapi.fw.fw_access.trust_and_security.IpAccess;
import org.csapi.fw.fw_access.trust_and_security.IpAccessHelper;
import org.csapi.fw.fw_access.trust_and_security.IpInitial;
import org.mobicents.slee.resource.parlay.fw.access.AuthenticationHandler;
import org.mobicents.slee.resource.parlay.fw.access.TSMBean;
import org.mobicents.slee.resource.parlay.fw.access.TSMBeanException;
import org.mobicents.slee.resource.parlay.util.Convert;
import org.mobicents.slee.resource.parlay.util.ParlayExceptionUtil;
import org.mobicents.slee.resource.parlay.util.crypto.CHAPUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtil;
import org.mobicents.slee.resource.parlay.util.crypto.RSAUtilException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class AuthenticationHandlerImpl
implements AuthenticationHandler {
    private TSMBean tsmBean = null;
    private static IpAPILevelAuthentication apiLevelAuthentication = null;
    private CHAPUtil chapUtil = null;
    private boolean clean = false;
    private static final Log logger = LogFactory.getLog(AuthenticationHandlerImpl.class);
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String INVOKING = "Invoking ";
    private static final String INVOKED = "Invoked ";
    private static final String EXCEPTION_INVOKING = "Exception invoking ";
    private static final String INITIAL = "org::csapi::fw::fw_access::trust_and_security::IpInitial";
    private static final String APILEVELAUTHENTICATION = "org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication";
    private static final String REQUEST_ACCESS = ".requestAccess()";
    private static final String ABORT_AUTHENTICATION = "abortAuthentication";
    private static final String INITIATE_AUTHENTICATION = ".initiateAuthentication()";
    private static final String INITIATE_AUTHENTICATION_WITH_VERSION = ".initiateAuthenticationWithVersion()";
    private static final String SELECT_ENCRYPTION_METHOD = ".selectEncryptionMethod()";
    private static final String SELECT_AUTHENTICATION_MECHANISM = ".selectAuthenticationMechanism()";
    private static final String AUTHENTICATE = ".authenticate()";
    private static final String AUTHENTICATION_SUCCEEDED = ".authenticationSucceeded()";
    private static final String CHALLENGE = ".challenge()";
    private static final int HEADER_SIZE = 4;
    private static final int HEADER_TOTAL = 5;

    public AuthenticationHandlerImpl(TSMBean tsmBean) {
        this.tsmBean = tsmBean;
        this.chapUtil = new CHAPUtil();
    }

    public String toString() {
        StringBuffer value = new StringBuffer("AuthenticationHandlerImpl");
        value.append(lineSeparator);
        return value.toString();
    }

    public void initiateAuthentication(TpAuthDomain clientAuthDomain) throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initiating authentication");
        }
        TpAuthDomain result = null;
        IpInitial initial = this.tsmBean.getInitial();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()");
                logger.debug((java.lang.Object)"Authentication Type = P_OSA_AUTHENTICATION");
            }
            result = initial.initiateAuthentication(clientAuthDomain, "P_OSA_AUTHENTICATION");
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_DOMAIN_ID ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_INTERFACE_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication() " + ParlayExceptionUtil.stringify(ex)));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_AUTH_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthentication()", (Exception)((java.lang.Object)ex));
        }
        apiLevelAuthentication = IpAPILevelAuthenticationHelper.narrow((Object)result.AuthInterface);
    }

    public void initiateAuthenticationWithVersion(TpAuthDomain clientAuthDomain, String version) throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initiating Authentication With Version");
        }
        TpAuthDomain result = null;
        IpInitial initial = this.tsmBean.getInitial();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()");
                logger.debug((java.lang.Object)"Authentication Type = P_OSA_AUTHENTICATION");
            }
            result = initial.initiateAuthenticationWithVersion(clientAuthDomain, "P_OSA_AUTHENTICATION", version);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_DOMAIN_ID ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_INTERFACE_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ParlayExceptionUtil.stringify(ex)));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_AUTH_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_VERSION ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fw_access::trust_and_security::IpInitial.initiateAuthenticationWithVersion()", (Exception)((java.lang.Object)ex));
        }
        apiLevelAuthentication = IpAPILevelAuthenticationHelper.narrow((Object)result.AuthInterface);
    }

    public String selectEncryptionMethod(String authCapabilityList) throws TSMBeanException {
        String result = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()");
                logger.debug((java.lang.Object)("Authentication Capability List = " + authCapabilityList));
            }
            result = apiLevelAuthentication.selectEncryptionMethod(authCapabilityList);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()", (Exception)((java.lang.Object)ex));
        }
        catch (P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectEncryptionMethod()", (Exception)((java.lang.Object)ex));
        }
        return result;
    }

    public String selectAuthenticationMechanism(String authMechanismList) throws TSMBeanException {
        String result = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism()");
                logger.debug((java.lang.Object)("Authentication Capability List = " + authMechanismList));
            }
            result = apiLevelAuthentication.selectAuthenticationMechanism(authMechanismList);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism()", (Exception)((java.lang.Object)ex));
        }
        catch (P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.selectAuthenticationMechanism()", (Exception)((java.lang.Object)ex));
        }
        return result;
    }

    public void authenticate(String encryptionMethod) throws TSMBeanException {
        byte[] challenge = null;
        challenge = this.generateRandomChallenge();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Challenge = <<" + Convert.toHexString(challenge) + ">>"));
        }
        byte[] response = null;
        byte[] encryptedChallenge = null;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Chosen encryption method =" + encryptionMethod));
        }
        encryptedChallenge = this.encryptChallenge(challenge, encryptionMethod);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Encrypted Challenge = <<" + Convert.toHexString(encryptedChallenge) + ">>"));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate()");
            }
            response = apiLevelAuthentication.authenticate(encryptedChallenge);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate()");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Response = <<" + Convert.toHexString(response) + ">>"));
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticate()", (Exception)((java.lang.Object)ex));
        }
        if (!Convert.assertEquals(challenge, response)) {
            logger.warn((java.lang.Object)"Gateway response does not match original challenge");
            throw new TSMBeanException("Gateway response does not match original challenge");
        }
    }

    public void challenge(String authMechanism) throws TSMBeanException {
        byte[] challenge = null;
        byte[] hashChallenge = null;
        challenge = this.generateRandomChallenge();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Challenge = <<" + Convert.toHexString(challenge) + ">>"));
        }
        byte[] response = null;
        byte[] chapChallenge = null;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Chosen authentication mechanism =" + authMechanism));
        }
        chapChallenge = this.chapUtil.generateCHAPRequestPacket(challenge);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge()");
            }
            response = apiLevelAuthentication.challenge(chapChallenge);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge()");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)("Response = <<" + Convert.toHexString(response) + ">>"));
            }
            byte[] responseValue = new byte[response[4]];
            for (int i = 0; i < responseValue.length; ++i) {
                responseValue[i] = response[i + 5];
            }
            if (!authMechanism.equalsIgnoreCase("P_OSA_MD5")) {
                logger.error((java.lang.Object)"The Authentication Mechanism was not recognised, hashing cannot continue!");
                throw new TSMBeanException("The Authentication Mechanism was not recognised, hashing cannot continue!");
            }
            hashChallenge = this.chapUtil.generateMD5HashChallenge(chapChallenge[1], this.tsmBean.getFwProperties().getSharedSecret(), challenge);
            if (!Convert.assertEquals(responseValue, hashChallenge)) {
                logger.warn((java.lang.Object)"Gateway response does not match original MD5 Hash challenge");
                throw new TSMBeanException("Gateway response does not match original MD5 Hash challenge");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.challenge()", (Exception)((java.lang.Object)ex));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn((java.lang.Object)("Error generating MD5 Challenge " + e.toString()));
            throw new TSMBeanException("Error generating MD5 Challenge", e);
        }
    }

    public void authenticationSucceeded() throws TSMBeanException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded()");
            }
            apiLevelAuthentication.authenticationSucceeded();
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded()");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.authenticationSucceeded()", (Exception)((java.lang.Object)ex));
        }
    }

    public IpAccess requestAccess(IpInterface clientAccess) throws TSMBeanException {
        IpAccess result;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Requesting access");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()");
                logger.debug((java.lang.Object)"Access Type = P_OSA_ACCESS");
            }
            IpInterface ipInterface = apiLevelAuthentication.requestAccess("P_OSA_ACCESS", clientAccess);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()");
            }
            result = IpAccessHelper.narrow((Object)ipInterface);
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_ACCESS_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (P_INVALID_INTERFACE_TYPE ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess() " + ParlayExceptionUtil.stringify(ex)));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()", (Exception)((java.lang.Object)ex));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess() " + ex.toString()));
            throw new TSMBeanException("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthentication.requestAccess()", (Exception)((java.lang.Object)ex));
        }
        return result;
    }

    public synchronized void cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Cleaning up " + this.toString()));
        }
        if (!this.clean) {
            apiLevelAuthentication = null;
            this.tsmBean = null;
            this.clean = true;
        }
    }

    protected byte[] generateRandomChallenge() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Generating a random challenge.");
        }
        byte[] result = new byte[50];
        Random random = new Random();
        random.nextBytes(result);
        return result;
    }

    protected byte[] encryptChallenge(byte[] challenge, String encryptionMethod) throws TSMBeanException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Encrypting challenge");
        }
        byte[] encryptedChallenge = null;
        if (encryptionMethod.startsWith("P_RSA")) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"RSA Encryption.");
            }
            try {
                encryptedChallenge = RSAUtil.encryptMessage(challenge, this.getAppRSAPublicKey(encryptionMethod), this.tsmBean.getFwProperties().getEncryptionCipherAlgorithm());
            }
            catch (RSAUtilException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)("RSA Utility Exception " + ex.toString()));
                }
                throw new TSMBeanException("RSA Utility Exception", ex);
            }
        } else if (encryptionMethod.equals("NULL")) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"No encryption transform needed.");
            }
            encryptedChallenge = challenge;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Framework chose an unsupported encryption method");
            }
            throw new TSMBeanException("Framework chose an unsupported encryption method");
        }
        return encryptedChallenge;
    }

    protected RSAPublicKey getAppRSAPublicKey(String encryptionMethod) throws RSAUtilException, TSMBeanException {
        int keySize;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Getting application RSA public key.");
        }
        RSAPublicKey publicKey = null;
        if (encryptionMethod.equals("P_RSA_1024")) {
            keySize = 1024;
        } else if (encryptionMethod.equals("P_RSA_512")) {
            keySize = 512;
        } else {
            throw new TSMBeanException(encryptionMethod + " is not a supported RSA encryption method.");
        }
        String filename = this.getAppRSAPublicKeyFilename(this.tsmBean.getClientID(), keySize);
        publicKey = RSAUtil.getPublicKey(filename, this.tsmBean.getClientID());
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Key Size = " + keySize));
        }
        return publicKey;
    }

    protected String getAppRSAPublicKeyFilename(String clientID, int keySize) {
        String result = null;
        String fileLocation = this.tsmBean.getFwProperties().getCertificateVault();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Using X509 Certificate file.");
        }
        result = fileLocation + clientID + "CSWAY" + keySize + ".pem";
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Key filename = " + result));
        }
        return result;
    }

    public void abortAuthentication() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Aborting authentication");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthenticationabortAuthentication");
            }
            apiLevelAuthentication.abortAuthentication();
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Invoked org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthenticationabortAuthentication");
            }
        }
        catch (TpCommonExceptions ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthenticationabortAuthentication " + ex.toString()));
        }
        catch (P_ACCESS_DENIED ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthenticationabortAuthentication " + ex.toString()));
        }
        catch (SystemException ex) {
            logger.warn((java.lang.Object)("Exception invoking org::csapi::fw::fwaccess::trust_and_security::IpAPILevelAuthenticationabortAuthentication " + ex.toString()));
        }
    }

    public static void setApiLevelAuthentication(IpAPILevelAuthentication apiLevelAuthentication) {
        AuthenticationHandlerImpl.apiLevelAuthentication = apiLevelAuthentication;
    }
}

