/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw;

import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpService;
import org.csapi.cc.gccs.IpCallControlManager;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManager;
import org.csapi.fw.TpProperty;
import org.csapi.fw.TpServiceProperty;
import org.csapi.ui.IpUIManager;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.fw.FwSessionException;
import org.mobicents.slee.resource.parlay.fw.FwSessionListener;
import org.mobicents.slee.resource.parlay.fw.FwSessionProperties;
import org.mobicents.slee.resource.parlay.fw.ServiceAndToken;
import org.mobicents.slee.resource.parlay.fw.TestProperties;
import org.mobicents.slee.resource.parlay.util.corba.CorbaUtilException;
import org.mobicents.slee.resource.parlay.util.corba.ORBHandler;
import org.mobicents.slee.resource.parlay.util.corba.ServiceManagerFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;

public class BypassedFwSession
implements FwSession {
    private static final Log logger = LogFactory.getLog(BypassedFwSession.class);
    private final transient FwSessionProperties fwSessionProperties;
    private final transient Vector fwSessionListeners;
    private final transient TestProperties testProperties;
    private ORBHandler handler;

    public BypassedFwSession(FwSessionProperties properties, TestProperties testProperties) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"BypassedFwSession created");
        }
        this.fwSessionProperties = properties;
        this.testProperties = testProperties;
        this.fwSessionListeners = new Vector(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws FwSessionException {
        try {
            this.handler = ORBHandler.getInstance();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create ORBHandler.");
            throw new FwSessionException("Failed to create ORBHandler.", e);
        }
        ORBHandler oRBHandler = this.handler;
        synchronized (oRBHandler) {
            try {
                this.handler.init();
            }
            catch (UserException e) {
                logger.error((Object)"Failed to initialise corba server.", (Throwable)e);
                throw new FwSessionException("Failed to initialise corba server.", (Exception)((Object)e));
            }
            for (int numberOfRetries = 20; !this.handler.getIsServerReady() && numberOfRetries > 0; --numberOfRetries) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Waiting for orb to initialise ...");
                    }
                    this.handler.wait(2000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Wait interrupted.");
                }
            }
        }
        if (!this.handler.getIsServerReady()) {
            throw new FwSessionException("Failed to initialise ORB.");
        }
    }

    public void addFwSessionListener(FwSessionListener listener) {
        if (!this.fwSessionListeners.contains(listener)) {
            this.fwSessionListeners.addElement(listener);
        }
    }

    public void removeFwSessionListener(FwSessionListener listener) {
        if (this.fwSessionListeners.contains(listener)) {
            this.fwSessionListeners.removeElement(listener);
        }
    }

    public void authenticate() throws FwSessionException {
    }

    public void endAccess(TpProperty[] endAccessProperties) throws FwSessionException {
    }

    public void releaseService(ServiceAndToken service) throws FwSessionException {
    }

    public ServiceAndToken getService(String serviceTypeName, TpServiceProperty[] serviceProperties) throws FwSessionException {
        ServiceAndToken result = null;
        if (serviceTypeName.equals("P_MULTI_PARTY_CALL_CONTROL")) {
            try {
                IpMultiPartyCallControlManager manager = ServiceManagerFactory.loadIpMultiPartyCallControlManager(this.handler, this.testProperties.getIpMultiPartyCallControlManagerFileName());
                result = new ServiceAndToken((IpService)manager, serviceTypeName);
            }
            catch (CorbaUtilException e) {
                throw new FwSessionException(e);
            }
        } else if (serviceTypeName.equals("P_GENERIC_CALL_CONTROL")) {
            try {
                IpCallControlManager manager = ServiceManagerFactory.loadIpCallControlManager(this.handler, this.testProperties.getIpCallControlManagerFileName());
                result = new ServiceAndToken((IpService)manager, serviceTypeName);
            }
            catch (CorbaUtilException e) {
                throw new FwSessionException(e);
            }
        } else if (serviceTypeName.equals("P_USER_INTERACTION")) {
            try {
                IpUIManager manager = ServiceManagerFactory.loadIpUIManager(this.handler, this.testProperties.getIpUIManagerFileName());
                result = new ServiceAndToken((IpService)manager, serviceTypeName);
            }
            catch (CorbaUtilException e) {
                throw new FwSessionException(e);
            }
        } else {
            throw new IllegalArgumentException("Service type " + serviceTypeName + " is not supported in bypassFw mode.");
        }
        return result;
    }

    public void shutdown() {
        try {
            if (this.handler != null) {
                this.handler.shutdown();
                this.handler = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to shut down Bypassed FwSession.", (Throwable)e);
        }
    }

    public ORB getORB() {
        return this.handler != null ? this.handler.getOrb() : null;
    }

    public FwSessionProperties getFwSessionProperties() {
        return this.fwSessionProperties;
    }

    public POA getRootPOA() {
        return this.handler != null ? this.handler.getRootPOA() : null;
    }
}

