/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.fw.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.fw.P_INVALID_SERVICE_TOKEN;
import org.csapi.fw.P_INVALID_SIGNATURE;
import org.csapi.fw.fw_application.service_agreement.IpAppServiceAgreementManagementPOA;
import org.mobicents.slee.resource.parlay.fw.application.SABean;
import org.mobicents.slee.resource.parlay.fw.application.TerminateServiceAgreementHandler;
import org.mobicents.slee.resource.parlay.util.Convert;
import org.omg.PortableServer.POA;

public class IpAppServiceAgreementManagementImpl
extends IpAppServiceAgreementManagementPOA {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final Log logger = LogFactory.getLog(IpAppServiceAgreementManagementImpl.class);
    private static final String P_MD5_RSA_1024 = "P_MD5_RSA_1024";
    private static final String P_MD5_RSA_512 = "P_MD5_RSA_512";
    private static final String RECEIVED = "Received ";
    private static final String EXITING = "Exiting ";
    private static final String APPSERVICEAGREEMENTMANAGEMENT = "org::csapi::fw::fwapplication::service_agreement::IpAppServiceAgreementManagement";
    private static final String SIGN_SERVICE_AGREEMENT = ".signServiceAgreement()";
    private static final String TERMINATE_SERVICE_AGREEMENT = ".terminateServiceAgreement()";
    private SABean saBean = null;
    private boolean clean = false;
    boolean isClient = false;
    POA _poa = null;

    public IpAppServiceAgreementManagementImpl(POA the_poa) {
        this._poa = the_poa;
    }

    public static IpAppServiceAgreementManagementImpl _create(POA the_poa) {
        return new IpAppServiceAgreementManagementImpl(the_poa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signServiceAgreement(String serviceToken, String agreementText, String signingAlgorithm) {
        Object monitor;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwapplication::service_agreement::IpAppServiceAgreementManagement.signServiceAgreement()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Service Token = " + serviceToken));
            logger.debug((Object)("Agreement Text = " + agreementText));
            logger.debug((Object)("Signing Algorithm = " + signingAlgorithm));
        }
        byte[] digitalSignature = new byte[]{};
        digitalSignature = signingAlgorithm.equals(P_MD5_RSA_512) || signingAlgorithm.equals(P_MD5_RSA_1024) ? this.saBean.generateDigitalSignature(agreementText, serviceToken, signingAlgorithm) : new byte[]{};
        Object object = monitor = this.saBean.getServiceAgreementMonitor();
        synchronized (object) {
            this.saBean.putServiceTokenSigningAlgorithm(serviceToken, signingAlgorithm);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Gateway has signed service agreement, notifying application thread");
            }
            this.saBean.setIsAgreementSigned(true);
            monitor.notify();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning digital signature " + Convert.toHexString(digitalSignature)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwapplication::service_agreement::IpAppServiceAgreementManagement.signServiceAgreement()");
        }
        return digitalSignature;
    }

    public void terminateServiceAgreement(String serviceToken, String terminationText, byte[] digitalSignature) throws P_INVALID_SERVICE_TOKEN, P_INVALID_SIGNATURE {
        String signingAlgorithm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received org::csapi::fw::fwapplication::service_agreement::IpAppServiceAgreementManagement.terminateServiceAgreement()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Service Token = " + serviceToken));
            logger.debug((Object)("Termination Text = " + terminationText));
            logger.debug((Object)("Digintal Signature = " + Convert.toHexString(digitalSignature)));
        }
        if ((signingAlgorithm = this.saBean.removeSigningAlgorithm(serviceToken)) != null) {
            if (!this.saBean.verifyDigitalSignature(terminationText, serviceToken, signingAlgorithm, digitalSignature)) {
                throw new P_INVALID_SIGNATURE();
            }
        } else {
            throw new P_INVALID_SERVICE_TOKEN();
        }
        TerminateServiceAgreementHandler event = new TerminateServiceAgreementHandler(this.saBean, serviceToken, terminationText);
        try {
            this.saBean.getTSMBean().getEventsQueue().execute((Runnable)event);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed to execute TerminatServiceAgreement event.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting org::csapi::fw::fwapplication::service_agreement::IpAppServiceAgreementManagement.terminateServiceAgreement()");
        }
    }

    public void setSABean(SABean saBean) {
        this.saBean = saBean;
    }

    public String toString() {
        StringBuffer value = new StringBuffer("IpAppServiceAgreementManagementImpl");
        value.append(lineSeparator);
        return value.toString();
    }

    public synchronized void cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up " + this.toString()));
        }
        if (!this.clean) {
            this.saBean = null;
            this.clean = true;
        }
    }

    public POA _default_POA() {
        if (this._poa != null) {
            return this._poa;
        }
        return super._default_POA();
    }
}

