package org.mobicents.slee.resource.parlay.csapi.jr.ui.eventHandlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.csapi.jr.slee.ui.TpUIIdentifier;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManager;

/**
 * 
 */
public class ReportNotificationHandler implements Runnable {
    /**
     * Log4J Logger for this class.
     */
    private static final Log logger = LogFactory
            .getLog(ReportNotificationHandler.class);

    private final transient UIManager uiManager;

    private final transient TpUIIdentifier uiReference;

    private final transient org.csapi.ui.TpUIEventInfo eventInfo;

    private final transient int assignmentID;

    public ReportNotificationHandler(UIManager uiManager,
            TpUIIdentifier uiReference, org.csapi.ui.TpUIEventInfo eventInfo,
            int assignmentID) {
        super();
        this.uiManager = uiManager;
        this.uiReference = uiReference;
        this.eventInfo = eventInfo;
        this.assignmentID = assignmentID;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        try {
            if (uiManager != null) {
                uiManager.reportNotification(uiReference, eventInfo,
                        assignmentID);
            } else {
                if (logger.isDebugEnabled()) {
                    logger
                            .debug("UIManager activity no longer exists. AssignmentID = ["
                                    + assignmentID + "]");
                }
            }
        } catch (RuntimeException e) {
            // Catch all
            logger.error("ReportNotificationHandler failed", e);
        }

    }

}
