package org.mobicents.slee.resource.parlay.fw;

import org.csapi.IpService;

/**
 * This class contains a Parlay service interface and its corresponding service
 * token generated by the gateway during service agreement.
 */
public final class ServiceAndToken {

    /**
     * @param ipService
     * @param serviceToken
     */
    public ServiceAndToken(IpService ipService, String serviceToken) {
        super();
        this.ipService = ipService;
        this.serviceToken = serviceToken;
    }

    private transient IpService ipService;

    private transient String serviceToken;

    /**
     * @return Returns the ipService.
     */
    public IpService getIpService() {
        return ipService;
    }

    /**
     * @return Returns the serviceToken.
     */
    public String getServiceToken() {
        return serviceToken;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass().equals(ServiceAndToken.class)) {
            ServiceAndToken rhs = (ServiceAndToken) obj;
            if (rhs.ipService.equals(this.ipService)
                    && rhs.serviceToken.equals(this.serviceToken)) {
                result = true;
            }
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        // Note: shouldn't toString a corba stub as the output can cause
        // problems
        // in certain terminals

        StringBuffer result = new StringBuffer("ServiceAndToken:");
        result.append("IpService,").append(ipService.hashCode()).append(";")
                .append("serviceToken").append(serviceToken).append(";");

        return result.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return ipService.hashCode() ^ serviceToken.hashCode();
    }
}