/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.jca;

import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManagerImpl
implements ConnectionManager,
ConnectionEventListener {
    private static final Log logger = LogFactory.getLog(ConnectionManagerImpl.class);
    private final transient Set connectionPool;

    public ConnectionManagerImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Default ConnectionManager implementation created");
        }
        this.connectionPool = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Allocating connection.");
        }
        Object result = null;
        ManagedConnection managedConnection = null;
        Subject subject = null;
        Set set = this.connectionPool;
        synchronized (set) {
            if (!this.connectionPool.isEmpty()) {
                managedConnection = managedConnectionFactory.matchManagedConnections(this.connectionPool, subject, connectionRequestInfo);
            }
            if (managedConnection != null) {
                this.connectionPool.remove(managedConnection);
            }
        }
        if (managedConnection == null) {
            managedConnection = managedConnectionFactory.createManagedConnection(subject, connectionRequestInfo);
            managedConnection.addConnectionEventListener((ConnectionEventListener)this);
        }
        result = managedConnection.getConnection(subject, connectionRequestInfo);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent event) {
        block8: {
            ManagedConnection managedConnection = (ManagedConnection)event.getSource();
            try {
                managedConnection.cleanup();
                Set set = this.connectionPool;
                synchronized (set) {
                    this.connectionPool.add(managedConnection);
                }
            }
            catch (ResourceException e) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Exception cleaning managed connnection. ", (Throwable)e);
                    }
                    managedConnection.destroy();
                }
                catch (ResourceException e1) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Object)"Exception destroying managed connnection. ", (Throwable)e1);
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        block2: {
            ManagedConnection managedConnection = (ManagedConnection)event.getSource();
            managedConnection.removeConnectionEventListener((ConnectionEventListener)this);
            try {
                managedConnection.cleanup();
                managedConnection.destroy();
            }
            catch (ResourceException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Exception destroying managed connection.", (Throwable)e);
            }
        }
    }

    public void localTransactionCommitted(ConnectionEvent arg0) {
    }

    public void localTransactionRolledback(ConnectionEvent arg0) {
    }

    public void localTransactionStarted(ConnectionEvent arg0) {
    }
}

