/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.corba;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class ORBHandler
implements Runnable {
    private static final Log logger = LogFactory.getLog(ORBHandler.class);
    private transient Thread orbThread = null;
    private transient boolean isServerReady = false;
    private transient ORB orb = null;
    private transient POA rootPOA = null;
    private Properties orbProperties;
    private static ORBHandler instance = null;

    public static synchronized ORBHandler getInstance() throws IOException {
        if (instance == null) {
            instance = new ORBHandler();
            Properties props = new Properties();
            props.load(instance.getClass().getResourceAsStream("parlayra-orb.properties"));
            instance.setOrbProperties(props);
        }
        return instance;
    }

    private ORBHandler() {
    }

    public synchronized void init() throws UserException {
        if (!this.isServerReady) {
            this.initialiseCorbaSetup();
            this.orbThread = new Thread(this);
            this.orbThread.setName("Parlay RA Orb Thread");
            this.orbThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Running the CORBA handler thread ...");
        }
        try {
            this.isServerReady = true;
            ORBHandler oRBHandler = this;
            synchronized (oRBHandler) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Notifying waiting thread ...");
                }
                this.notify();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Orb is ready for CORBA requests...");
            }
            this.orb.run();
            this.isServerReady = false;
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"ORB.run has terminated");
            }
        }
        catch (RuntimeException ex) {
            logger.error((java.lang.Object)("Unexpected Exception during CORBA initialization: " + ex));
        }
    }

    private void initialiseCorbaSetup() throws InvalidName, AdapterInactive {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initializing for CORBA...");
        }
        this.orbInit();
        this.initRootPOA();
        this.rootPOA.the_POAManager().activate();
        this.isServerReady = true;
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"... initialised ok");
        }
    }

    private void orbInit() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initialising Parlay RA ORB ...");
        }
        this.orb = ORB.init((String[])new String[0], (Properties)this.orbProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"...ORB.init was OK");
            logger.debug((java.lang.Object)("Running ORB " + this.orb.toString()));
        }
    }

    private void initRootPOA() throws InvalidName {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Initialising Root POA ...");
        }
        Object rootPoaRef = this.orb.resolve_initial_references("RootPOA");
        this.rootPOA = POAHelper.narrow((Object)rootPoaRef);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"... Root POA init was OK");
        }
    }

    public synchronized boolean getIsServerReady() {
        return this.isServerReady;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public POA getRootPOA() {
        return this.rootPOA;
    }

    public Properties getOrbProperties() {
        return this.orbProperties;
    }

    public synchronized void shutdown() {
        if (this.orb != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Shutting down the ORB...");
            }
            try {
                this.orb.shutdown(true);
            }
            catch (RuntimeException e) {
                logger.error((java.lang.Object)"Exception shutting down ORB.", (Throwable)e);
            }
            try {
                this.orb.destroy();
            }
            catch (RuntimeException e) {
                logger.error((java.lang.Object)"Exception destroying down ORB.", (Throwable)e);
            }
            this.isServerReady = false;
            this.rootPOA = null;
            this.orbThread = null;
            this.orb = null;
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"...ORB shutdown OK");
            }
        }
    }

    public void setOrbProperties(Properties orbProperties) {
        this.orbProperties = orbProperties;
    }
}

