/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.corba;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.IpInterface;
import org.csapi.IpInterfaceHelper;
import org.csapi.cc.gccs.IpCallControlManager;
import org.csapi.cc.gccs.IpCallControlManagerHelper;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManager;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManagerHelper;
import org.csapi.ui.IpUIManager;
import org.csapi.ui.IpUIManagerHelper;
import org.mobicents.slee.resource.parlay.util.corba.CorbaUtilException;
import org.mobicents.slee.resource.parlay.util.corba.ORBHandler;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

public class ServiceManagerFactory {
    private static final Log logger = LogFactory.getLog(ServiceManagerFactory.class);

    private ServiceManagerFactory() {
    }

    public static void writeReference(ORBHandler orbHandler, Object corbaObject, String fileName) throws CorbaUtilException {
        String stringifiedObject = orbHandler.getOrb().object_to_string(corbaObject);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Writing stringified object reference to: " + fileName));
        }
        try {
            FileWriter store = new FileWriter(fileName);
            store.write(stringifiedObject);
            store.flush();
            store.close();
        }
        catch (IOException ex) {
            logger.error((java.lang.Object)("Failed to write the stringified object reference write to: " + fileName));
            throw new CorbaUtilException("Failed to write the stringified object reference write to: " + fileName);
        }
    }

    public static Object readReference(ORBHandler orbHandler, String fileName) throws CorbaUtilException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Reading stringified object reference from..." + fileName));
        }
        Object result = null;
        FileReader retrieve = null;
        try {
            retrieve = new FileReader(fileName);
            BufferedReader in = new BufferedReader(retrieve);
            String ref = in.readLine();
            result = orbHandler.getOrb().string_to_object(ref);
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)"Could not read reference from file", (Throwable)ex);
            }
            throw new CorbaUtilException("Failed to read IOR from " + fileName);
        }
        finally {
            block13: {
                if (retrieve != null) {
                    try {
                        retrieve.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block13;
                        logger.debug((java.lang.Object)"Could not read reference from file", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public static IpInterface getIpInterfaceFromFile(ORBHandler orbHandler, String fileName) throws CorbaUtilException {
        IpInterface result = null;
        Object ref = ServiceManagerFactory.readReference(orbHandler, fileName);
        if (ref != null) {
            try {
                result = IpInterfaceHelper.narrow((Object)ref);
            }
            catch (BAD_PARAM ex) {
                logger.error((java.lang.Object)"Failed to narrow corba object.", (Throwable)ex);
                throw new CorbaUtilException("Failed to narrow IOR to IpInterface");
            }
        }
        return result;
    }

    public static IpMultiPartyCallControlManager loadIpMultiPartyCallControlManager(ORBHandler orbHandler, String fileName) throws CorbaUtilException {
        IpMultiPartyCallControlManager result = null;
        IpInterface tmpRef = ServiceManagerFactory.getIpInterfaceFromFile(orbHandler, fileName);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("IOR = " + tmpRef));
        }
        if (tmpRef != null) {
            try {
                result = IpMultiPartyCallControlManagerHelper.narrow((Object)tmpRef);
            }
            catch (BAD_PARAM e) {
                logger.error((java.lang.Object)"Failed to narrow IOR to IpMultiPartyCallControlManager.");
                throw new CorbaUtilException("Failed to narrow IOR to IpMultiPartyCallControlManager");
            }
        }
        return result;
    }

    public static IpCallControlManager loadIpCallControlManager(ORBHandler orbHandler, String fileName) throws CorbaUtilException {
        IpCallControlManager result = null;
        IpInterface tmpRef = ServiceManagerFactory.getIpInterfaceFromFile(orbHandler, fileName);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("IOR = " + tmpRef));
        }
        if (tmpRef != null) {
            try {
                result = IpCallControlManagerHelper.narrow((Object)tmpRef);
            }
            catch (BAD_PARAM e) {
                logger.error((java.lang.Object)"Failed to narrow IOR to IpCallControlManager.");
                throw new CorbaUtilException("Failed to narrow IOR to IpCallControlManager");
            }
        }
        return result;
    }

    public static IpUIManager loadIpUIManager(ORBHandler orbHandler, String fileName) throws CorbaUtilException {
        IpUIManager result = null;
        IpInterface tmpRef = ServiceManagerFactory.getIpInterfaceFromFile(orbHandler, fileName);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("IOR = " + tmpRef));
        }
        if (tmpRef != null) {
            try {
                result = IpUIManagerHelper.narrow((Object)tmpRef);
            }
            catch (BAD_PARAM e) {
                logger.error((java.lang.Object)"Failed to narrow IOR to IpCallControlManager.");
                throw new CorbaUtilException("Failed to narrow IOR to IpCallControlManager");
            }
        }
        return result;
    }
}

