/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.util.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CHAPUtil {
    private static final Log logger = LogFactory.getLog(CHAPUtil.class);
    private static final int HEADER_TOTAL = 5;
    private static final int RESPONSE = 2;
    private static final int REQUEST = 1;
    private transient byte identifier = 0;
    private MessageDigest md5Digest;

    public byte[] generateCHAPRequestPacket(byte[] challenge) {
        byte[] chapPacket = new byte[5 + challenge.length];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateCHAPRequestPacket() - start");
        }
        chapPacket[0] = 1;
        chapPacket[1] = this.getNextIdentifier();
        chapPacket[2] = (byte)(chapPacket.length / 256);
        chapPacket[3] = (byte)(chapPacket.length % 256);
        chapPacket[4] = (byte)challenge.length;
        for (int i = 5; i < chapPacket.length; ++i) {
            chapPacket[i] = challenge[i - 5];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateCHAPRequestPacket() - end");
        }
        return chapPacket;
    }

    public byte[] generateCHAPResponsePacket(byte identifier, byte[] challenge, byte[] responseName) {
        byte[] chapPacket = new byte[5 + challenge.length + responseName.length];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateCHAPResponsePacket() - start");
        }
        chapPacket[0] = 2;
        chapPacket[1] = identifier;
        chapPacket[2] = (byte)(chapPacket.length / 256);
        chapPacket[3] = (byte)(chapPacket.length % 256);
        chapPacket[4] = (byte)challenge.length;
        for (int i = 0; i < challenge.length; ++i) {
            chapPacket[i + 5] = challenge[i];
        }
        for (int j = 0; j < responseName.length; ++j) {
            chapPacket[j + challenge.length + 5] = responseName[j];
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateCHAPResponsePacket() - end");
        }
        return chapPacket;
    }

    private byte getNextIdentifier() {
        this.identifier = (byte)(this.identifier + 1);
        if (this.identifier > 255) {
            this.identifier = 0;
        }
        return this.identifier;
    }

    public byte[] generateMD5HashChallenge(byte request_id, String sharedSecret, byte[] challenge) throws NoSuchAlgorithmException {
        byte[] sSecret = sharedSecret.getBytes();
        byte[] toDigest = new byte[1 + sSecret.length + challenge.length];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateMD5HashChallenge() - start");
        }
        toDigest[0] = request_id;
        System.arraycopy(sSecret, 0, toDigest, 0, sSecret.length);
        for (int j = 1 + sSecret.length; j < toDigest.length; ++j) {
            toDigest[j] = challenge[j - (1 + sSecret.length)];
        }
        MessageDigest md5 = this.getMd5Digest();
        md5.reset();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"generateMD5HashChallenge() - end");
        }
        return md5.digest(toDigest);
    }

    protected MessageDigest getMd5Digest() throws NoSuchAlgorithmException {
        if (this.md5Digest == null) {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        return this.md5Digest;
    }
}

