/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.parlay.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.slee.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csapi.cc.gccs.IpCallControlManager;
import org.csapi.cc.gccs.IpCallControlManagerHelper;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManager;
import org.csapi.cc.mpccs.IpMultiPartyCallControlManagerHelper;
import org.csapi.fw.TpProperty;
import org.csapi.ui.IpUIManager;
import org.csapi.ui.IpUIManagerHelper;
import org.mobicents.csapi.jr.slee.TpServiceIdentifier;
import org.mobicents.csapi.jr.slee.fw.TerminateAccessEvent;
import org.mobicents.csapi.jr.slee.fw.TerminateServiceAgreementEvent;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.GccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.gccs.activity.callcontrolmanager.CallControlManagerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.MpccsListener;
import org.mobicents.slee.resource.parlay.csapi.jr.cc.mpccs.activity.multipartycallcontrolmanager.MultiPartyCallControlManagerImpl;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.UiListener;
import org.mobicents.slee.resource.parlay.csapi.jr.ui.activity.uimanager.UIManagerImpl;
import org.mobicents.slee.resource.parlay.fw.FwSession;
import org.mobicents.slee.resource.parlay.fw.FwSessionException;
import org.mobicents.slee.resource.parlay.fw.FwSessionFactory;
import org.mobicents.slee.resource.parlay.fw.FwSessionListener;
import org.mobicents.slee.resource.parlay.fw.FwSessionProperties;
import org.mobicents.slee.resource.parlay.fw.ServiceAndToken;
import org.mobicents.slee.resource.parlay.session.ParlaySession;
import org.mobicents.slee.resource.parlay.session.ServiceProperties;
import org.mobicents.slee.resource.parlay.session.ServiceSession;
import org.mobicents.slee.resource.parlay.util.activity.ActivityManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ParlaySessionImpl
implements ParlaySession,
FwSessionListener {
    private static final String P_GENERIC_CALL_CONTROL = "P_GENERIC_CALL_CONTROL";
    private static final String P_MULTI_PARTY_CALL_CONTROL = "P_MULTI_PARTY_CALL_CONTROL";
    private static final String P_USER_INTERACTION = "P_USER_INTERACTION";
    private static final String FAILED_TO_CREATE_SERVICE_SESSION = "Failed to createServiceSession";
    private static final Log logger = LogFactory.getLog(ParlaySessionImpl.class);
    protected transient FwSession fwSession = null;
    private transient FwSessionProperties fwSessionProperties = null;
    private transient Map serviceIdentifierToServiceSessionMap;
    private transient Map propertiesToServiceIdentifierMap;
    private transient ActivityManager activityManager;
    private transient MpccsListener mpccsListener;
    private transient GccsListener gccsListener;
    private transient UiListener uiListener;

    public ParlaySessionImpl(FwSessionProperties fwProperties, ActivityManager activityManager) {
        this.fwSessionProperties = fwProperties;
        this.activityManager = activityManager;
        this.serviceIdentifierToServiceSessionMap = new HashMap();
        this.propertiesToServiceIdentifierMap = new HashMap();
    }

    public void init() throws FwSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Init Parlay Session");
        }
        this.fwSession = FwSessionFactory.createFwSession(this.fwSessionProperties);
        this.fwSession.addFwSessionListener(this);
        try {
            this.fwSession.init();
        }
        catch (FwSessionException e) {
            this.fwSession.removeFwSessionListener(this);
            this.fwSession.shutdown();
            throw e;
        }
        try {
            this.fwSession.authenticate();
        }
        catch (FwSessionException e) {
            this.fwSession.removeFwSessionListener(this);
            this.fwSession.shutdown();
            throw e;
        }
    }

    public synchronized void destroy() {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"Destroying Parlay Session");
        }
        if (this.fwSession != null) {
            this.fwSession.removeFwSessionListener(this);
            this.endAccess();
            this.fwSession.shutdown();
        }
        this.propertiesToServiceIdentifierMap.clear();
        this.serviceIdentifierToServiceSessionMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TpServiceIdentifier getService(String serviceTypeName, Properties serviceProperties) throws FwSessionException, ResourceException {
        TpServiceIdentifier result = null;
        ServiceProperties properties = ServiceProperties.load(serviceProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)"handling getService()");
            logger.debug((java.lang.Object)properties);
        }
        ParlaySessionImpl parlaySessionImpl = this;
        synchronized (parlaySessionImpl) {
            if (this.propertiesToServiceIdentifierMap.get(properties) != null) {
                result = (TpServiceIdentifier)this.propertiesToServiceIdentifierMap.get(properties);
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Found a matching service identifier");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"No matching service found. Selecting new service instance.");
                }
                try {
                    ServiceAndToken serviceAndToken = this.fwSession.getService(serviceTypeName, properties.getServiceProperties());
                    String ior = this.fwSession.getORB().object_to_string((Object)serviceAndToken.getIpService());
                    if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)("IpService IOR = " + ior));
                    }
                    result = new TpServiceIdentifier(serviceAndToken.getServiceToken().hashCode());
                    ServiceSession serviceSession = this.createServiceSession(serviceTypeName, serviceAndToken, result, this.fwSession, this.activityManager);
                    serviceSession.init();
                    this.propertiesToServiceIdentifierMap.put(properties, result);
                    this.serviceIdentifierToServiceSessionMap.put(result, serviceSession);
                }
                catch (FwSessionException e) {
                    throw e;
                }
                catch (ResourceException e) {
                    throw e;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)("Returning :" + result));
        }
        return result;
    }

    public ServiceSession getServiceSession(TpServiceIdentifier serviceIdentifier) {
        return (ServiceSession)this.serviceIdentifierToServiceSessionMap.get(serviceIdentifier);
    }

    public void terminateAccess(TerminateAccessEvent event) {
        this.fwSession.removeFwSessionListener(this);
        this.fwSession.shutdown();
    }

    public void terminateServiceAgreement(TerminateServiceAgreementEvent event) {
        this.fwSession.removeFwSessionListener(this);
        this.endAccess();
        this.fwSession.shutdown();
    }

    private void endAccess() {
        TpProperty[] properties = new TpProperty[]{};
        try {
            this.fwSession.endAccess(properties);
        }
        catch (FwSessionException e) {
            logger.error((java.lang.Object)"Exception performing endAccess", (Throwable)e);
        }
    }

    public FwSession getFwSession() {
        return this.fwSession;
    }

    public MpccsListener getMpccsListener() {
        return this.mpccsListener;
    }

    public void setMpccsListener(MpccsListener mpccsListener) {
        this.mpccsListener = mpccsListener;
    }

    public ServiceSession createServiceSession(String serviceTypeName, ServiceAndToken serviceAndToken, TpServiceIdentifier serviceIdentifier, FwSession fwSession, ActivityManager activityManager) throws ResourceException {
        ServiceSession result = null;
        try {
            if (serviceTypeName.equals(P_MULTI_PARTY_CALL_CONTROL)) {
                IpMultiPartyCallControlManager manager = IpMultiPartyCallControlManagerHelper.narrow((Object)serviceAndToken.getIpService());
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Creating MpccsSession");
                }
                result = new MultiPartyCallControlManagerImpl(serviceIdentifier, manager, fwSession, activityManager, this.mpccsListener);
            } else if (serviceTypeName.equals(P_GENERIC_CALL_CONTROL)) {
                IpCallControlManager ipCallControlManager = IpCallControlManagerHelper.narrow((Object)serviceAndToken.getIpService());
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Creating GccsSession");
                }
                result = new CallControlManagerImpl(fwSession, ipCallControlManager, this.gccsListener, activityManager, serviceIdentifier);
            } else if (serviceTypeName.equals(P_USER_INTERACTION)) {
                IpUIManager ipUIManager = IpUIManagerHelper.narrow((Object)serviceAndToken.getIpService());
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)"Creating UiSession");
                }
                result = new UIManagerImpl(this, fwSession, ipUIManager, this.uiListener, activityManager, serviceIdentifier);
            } else {
                logger.error((java.lang.Object)("Invalid service Type: " + serviceTypeName));
            }
        }
        catch (SystemException e) {
            logger.error((java.lang.Object)FAILED_TO_CREATE_SERVICE_SESSION);
            throw new ResourceException(FAILED_TO_CREATE_SERVICE_SESSION);
        }
        return result;
    }

    public GccsListener getGccsListener() {
        return this.gccsListener;
    }

    public void setGccsListener(GccsListener gccsListener) {
        this.gccsListener = gccsListener;
    }

    public UiListener getUiListener() {
        return this.uiListener;
    }

    public void setUiListener(UiListener uiListener) {
        this.uiListener = uiListener;
    }
}

