/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.persistence.ra;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.mobicents.slee.resource.persistence.ra.ActivityManipulation;
import org.mobicents.slee.resource.persistence.ra.SbbEntityManagerImpl;
import org.mobicents.slee.resource.persistence.ratype.PersistenceResourceAdaptorSbbInterface;
import org.mobicents.slee.resource.persistence.ratype.SbbEntityManager;

public class PersistenceResourceAdaptorSbbInterfaceImpl
implements PersistenceResourceAdaptorSbbInterface {
    private ActivityManipulation am = null;
    private HashMap<String, EntityManagerFactory> emfsHeldHere = new HashMap();
    private boolean hasBeenClosed = false;

    public PersistenceResourceAdaptorSbbInterfaceImpl(ActivityManipulation am) {
        this.am = am;
    }

    public void close() {
        if (this.hasBeenClosed) {
            return;
        }
        for (String s : this.emfsHeldHere.keySet()) {
            this.am.unsubscribeForEntityManagerFactoryForPU(s);
        }
        this.hasBeenClosed = true;
    }

    public boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    public EntityManager createEntityManager(Map emfProperties, String puName) {
        if (this.hasBeenClosed) {
            throw new RuntimeException("Wrong state RASbbInterface has been closed.");
        }
        return this.prepareManager(emfProperties, null, puName);
    }

    public EntityManager createEntityManager(Map emfProperties, Map emProps, String puName) {
        if (this.hasBeenClosed) {
            throw new RuntimeException("Wrong state RASbbInterface has been closed.");
        }
        return this.prepareManager(emfProperties, emProps, puName);
    }

    public boolean isOpen(String puName) {
        EntityManagerFactory t_emf = null;
        if (this.emfsHeldHere.containsKey(puName)) {
            t_emf = this.emfsHeldHere.get(puName);
            return t_emf.isOpen();
        }
        return this.am.isEMFOpen(puName);
    }

    private SbbEntityManager prepareManager(Map emfProperties, Map emProperties, String puName) {
        EntityManagerFactory t_emf = null;
        EntityManager em = null;
        t_emf = this.am.subscribeForEntityManagerFactoryForPU(puName, emfProperties);
        if (t_emf == null) {
            return null;
        }
        this.emfsHeldHere.put(puName, t_emf);
        em = emProperties != null ? t_emf.createEntityManager(emProperties) : t_emf.createEntityManager();
        SbbEntityManagerImpl sbe = new SbbEntityManagerImpl(em, this.am);
        this.am.addActivity(sbe);
        return sbe;
    }

    public void finalize() {
        this.close();
    }
}

