/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.persistence.ra;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.slee.Address;
import javax.slee.InvalidStateException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.persistence.ra.ActivityManipulation;
import org.mobicents.slee.resource.persistence.ra.PersistenceActivityContextInterfaceFactoryImp;
import org.mobicents.slee.resource.persistence.ra.PersistenceActivityHandle;
import org.mobicents.slee.resource.persistence.ra.PersistenceResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.resource.persistence.ra.SbbEntityManagerImpl;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class PersistenceResourceAdaptor
implements ResourceAdaptor,
Serializable,
ActivityManipulation {
    private static transient Logger log = Logger.getLogger(PersistenceResourceAdaptor.class);
    private String entityName = "PersistenceRA";
    private ResourceAdaptorState state = null;
    private transient Map activities = new ConcurrentReaderHashMap();
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeContainer serviceContainer = null;
    private transient SleeTransactionManager tm = null;
    private ActivityContextFactory activityContextFactory;
    private String PERSISTENCE_UNIT_NAME = "persistence-ra-unit";
    private String EMFS_MAP_NAME = "EMFS[" + this + "]";
    private String EMFS_SCOUNT_MAP_NAME = "EMFS_SCOUNT[" + this + "]";
    CacheableMap emfsMap = new CacheableMap((Object)this.EMFS_MAP_NAME);
    CacheableMap emfsSubsriptionCounts = new CacheableMap((Object)this.EMFS_SCOUNT_MAP_NAME);
    private PersistenceActivityContextInterfaceFactoryImp acif = null;

    private void init(BootstrapContext bootstrapContext) {
        log.debug((Object)"PersistenceResourceAdaptor: init()");
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    private void configure(Properties props) throws InvalidStateException {
    }

    private void start() throws ResourceException {
        try {
            this.initializeNamingContext();
            this.activities = new ConcurrentReaderHashMap();
            this.state = ResourceAdaptorState.ACTIVE;
        }
        catch (Exception e) {
            throw new ResourceException("Couldnt start Resource Adaptor[" + this.entityName + "]", (Throwable)e);
        }
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container;
        this.serviceContainer = container = SleeContainer.lookupFromJndi();
        this.activityContextFactory = this.serviceContainer.getActivityContextFactory();
        PersistenceResourceAdaptor persistenceResourceAdaptor = this;
        this.tm = persistenceResourceAdaptor.serviceContainer.getTransactionManager();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.entityName = this.bootstrapContext.getEntityName();
        this.acif = new PersistenceActivityContextInterfaceFactoryImp(this.serviceContainer, this.entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                log.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.debug((Object)e);
        }
    }

    public void stopping() {
        this.state = ResourceAdaptorState.STOPPING;
    }

    public void stop() {
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.error((Object)"Cannot unbind naming context");
        }
        log.debug((Object)"Persistence Resource Adaptor stopped.");
    }

    public void stopEntityManagers() {
        for (SbbEntityManagerImpl sbei : this.activities.values()) {
            if (!sbei.isOpen()) continue;
            sbei.close();
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.debug((Object)e);
        }
    }

    public void entityCreated(BootstrapContext ctx) throws ResourceException {
        this.init(ctx);
    }

    public void entityActivated() throws ResourceException {
        try {
            try {
                this.configure(null);
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivated() {
        this.stop();
    }

    public void entityDeactivating() {
        this.stopping();
    }

    public void activityEnded(ActivityHandle arg0) {
        this.activities.remove(arg0);
    }

    public void activityUnreferenced(ActivityHandle arg0) {
        ((SbbEntityManagerImpl)((Object)this.activities.get(arg0))).close();
    }

    public void entityRemoved() {
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
    }

    public Object getActivity(ActivityHandle arg0) {
        return this.activities.get(arg0);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return new PersistenceResourceAdaptorSbbInterfaceImpl(this);
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public void serviceActivated(String arg0) {
    }

    public void serviceDeactivated(String arg0) {
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
    }

    public void serviceUninstalled(String arg0) {
    }

    public String getPersistanceUnitName() {
        return this.PERSISTENCE_UNIT_NAME;
    }

    public void setPersistenceUnitName(String name) {
        this.PERSISTENCE_UNIT_NAME = name;
    }

    public void addActivity(SbbEntityManagerImpl em) {
        PersistenceActivityHandle pah = new PersistenceActivityHandle(em);
        this.activities.put(pah, em);
    }

    public void removeActivity(SbbEntityManagerImpl em) {
        PersistenceActivityHandle pah = new PersistenceActivityHandle(em);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)pah);
        }
        catch (NullPointerException e) {
            this.activities.remove(pah);
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            this.activities.remove(pah);
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            this.activities.remove(pah);
            e.printStackTrace();
        }
    }

    public EntityManagerFactory subscribeForEntityManagerFactoryForPU(String puName, Map emfProperties) {
        EntityManagerFactory emf = null;
        if (!this.emfsMap.containsKey((Object)puName)) {
            emf = emfProperties == null ? Persistence.createEntityManagerFactory((String)puName) : Persistence.createEntityManagerFactory((String)puName, (Map)emfProperties);
            this.emfsMap.put((Object)puName, (Object)emf);
            this.emfsSubsriptionCounts.put((Object)puName, (Object)new Integer(1));
        } else {
            emf = (EntityManagerFactory)this.emfsMap.get((Object)puName);
            Integer val = (Integer)this.emfsSubsriptionCounts.get((Object)puName);
            this.emfsSubsriptionCounts.put((Object)puName, (Object)new Integer(val + 1));
        }
        return emf;
    }

    public void unsubscribeForEntityManagerFactoryForPU(String puName) {
        if (!this.emfsMap.containsKey((Object)puName)) {
            return;
        }
        Integer val = (Integer)this.emfsSubsriptionCounts.get((Object)puName);
        int newVal = val - 1;
        if (newVal != 0) {
            this.emfsSubsriptionCounts.put((Object)puName, (Object)new Integer(newVal));
        }
    }

    public boolean isEMFOpen(String puName) {
        if (this.emfsMap.containsKey((Object)puName)) {
            return ((EntityManagerFactory)this.emfsMap.get((Object)puName)).isOpen();
        }
        return false;
    }
}

