/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.rules.ra;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.jboss.logging.Logger;
import org.mobicents.slee.resource.rules.ratype.RulesSession;

public class RulesSessionImpl
implements RulesSession {
    private Logger log = Logger.getLogger(this.getClass());
    String rulesFileName = null;
    WorkingMemory workingMemory = null;
    private String sessionID = new UID().toString();

    public RulesSessionImpl(String rulesFileName, WorkingMemory workingMemory) {
        this.rulesFileName = rulesFileName;
        this.workingMemory = workingMemory;
    }

    public String getId() {
        return this.sessionID;
    }

    private WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public List executeRules(List objects) {
        ArrayList results;
        WorkingMemory workingMemory = this.getWorkingMemory();
        Object obj = workingMemory.getGlobal("result");
        if (obj != null) {
            results = (ArrayList)obj;
            results.clear();
        } else {
            results = new ArrayList();
        }
        workingMemory.setGlobal("result", results);
        for (Object fact : objects) {
            FactHandle callFactHandle = workingMemory.getFactHandle(fact);
            if (callFactHandle != null) {
                workingMemory.modifyObject(callFactHandle, fact);
                continue;
            }
            workingMemory.assertObject(fact);
        }
        workingMemory.fireAllRules();
        return results;
    }

    public void dispose() {
        this.log.debug((Object)"dispose() of RulesSession called. Calling dispose on WorkingMemory");
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
    }
}

