/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.rules.ra;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import org.apache.log4j.Logger;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.event.WorkingMemoryEventListener;
import org.mobicents.slee.resource.rules.ra.CallWorkingMemoryListener;
import org.mobicents.slee.resource.rules.ra.RulesActivityHandle;
import org.mobicents.slee.resource.rules.ra.RulesResourceAdaptor;
import org.mobicents.slee.resource.rules.ra.RulesSessionImpl;
import org.mobicents.slee.resource.rules.ratype.RulesProvider;
import org.mobicents.slee.resource.rules.ratype.RulesSession;

public class RulesProviderImpl
implements RulesProvider {
    private static Logger logger = Logger.getLogger(RulesProviderImpl.class);
    public static final String RULES_BASE_JNDI_PREFIX = "java:rulebase/";
    private RulesResourceAdaptor ra;

    public RulesProviderImpl(RulesResourceAdaptor ra) {
        logger.debug((Object)"Constructor RulesResourceAdaptorSbbInterfaceImpl(RulesResourceAdaptor ra) called.");
        this.ra = ra;
    }

    public RulesSession getNewRulesSession(String drlFile) {
        System.out.println("getNewRulesSession() of RulesProviderImpl called fact = :  drlFile = " + drlFile);
        RulesSessionImpl activity = null;
        try {
            WorkingMemory wm = null;
            RuleBase rb = null;
            if (activity == null) {
                InitialContext ctx = new InitialContext();
                String rulebaseJndi = RULES_BASE_JNDI_PREFIX + drlFile;
                try {
                    rb = (RuleBase)ctx.lookup(rulebaseJndi);
                }
                catch (NameNotFoundException ex) {
                    logger.error((Object)("Lookup of RuleBase failed " + rulebaseJndi), (Throwable)ex);
                    throw new RuntimeException("Lookup of RuleBase failed " + rulebaseJndi, ex);
                }
                wm = rb.newWorkingMemory(false);
                activity = new RulesSessionImpl(drlFile, wm);
                RulesActivityHandle handle = new RulesActivityHandle(activity.getId());
                CallWorkingMemoryListener listener = new CallWorkingMemoryListener(handle, this.ra.getBootstrapContext());
                wm.addEventListener((WorkingMemoryEventListener)listener);
                this.ra.addActivity(handle, activity);
                this.ra.getSleeEndpoint().activityStarted((ActivityHandle)handle);
            }
            return activity;
        }
        catch (FacilityException fe) {
            logger.error((Object)"Caught a FacilityException: ");
            fe.printStackTrace();
            throw new RuntimeException("RAFrameResourceAdapter.onEvent(): FacilityException caught. ", fe);
        }
        catch (Exception e) {
            logger.error((Object)"Caught an UnrecognizedEventException: ");
            e.printStackTrace();
            throw new RuntimeException("RAFrameResourceAdaptor.onEvent(): UnrecognizedEventException caught.", e);
        }
    }
}

