/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.rules.ra;

import java.io.Serializable;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.rules.ra.RulesActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.rules.ra.RulesProviderImpl;
import org.mobicents.slee.resource.rules.ratype.RulesActivityContextInterfaceFactory;
import org.mobicents.slee.resource.rules.ratype.RulesProvider;
import org.mobicents.slee.resource.rules.ratype.RulesSession;

public class RulesResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static transient Logger logger = Logger.getLogger(RulesResourceAdaptor.class);
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient HashMap activities = null;
    private transient RulesActivityContextInterfaceFactory acif = null;
    private transient RulesProvider raProvider = null;

    public RulesResourceAdaptor() {
        logger.debug((Object)"RulesResourceAdaptor() called.");
    }

    public void addActivity(ActivityHandle activityHandle, RulesSession rulesSession) {
        this.activities.put(activityHandle, rulesSession);
    }

    public void activityEnded(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        logger.debug((Object)"RulesResourceAdaptor.activityEnded() called.");
    }

    public void activityUnreferenced(ActivityHandle arg0) {
        logger.debug((Object)"RulesResourceAdaptor.activityUnreferenced() called.");
    }

    public void entityActivated() throws ResourceException {
        logger.debug((Object)"RulesResourceAdaptor.entityActivated() called.");
        try {
            logger.debug((Object)"Starting ");
            try {
                this.raProvider = new RulesProviderImpl(this);
                this.initializeNamingContext();
            }
            catch (Exception ex) {
                logger.error((Object)"RAFrameResouceAdaptor.start(): Exception caught! ");
                ex.printStackTrace();
                throw new ResourceException(ex.getMessage());
            }
            this.activities = new HashMap();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("RAFrameResourceAdaptor.entityActivated(): Failed to activate RAFrame Resource Adaptor!", (Throwable)e);
        }
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.debug((Object)"RulesResourceAdaptor.entityCreated() called.");
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityDeactivated() {
        logger.debug((Object)"RulesResourceAdaptor.entityDeactivated() called.");
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind naming context");
        }
        logger.debug((Object)"Rules Resource Adaptor stopped.");
    }

    public void entityDeactivating() {
        logger.debug((Object)"RulesResourceAdaptor.entityDeactivating() called.");
    }

    public void entityRemoved() {
        logger.debug((Object)"RulesResourceAdaptor.entityRemoved() called.");
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
        logger.debug((Object)"RulesResourceAdaptor.eventProcessingFailed() called.");
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
        logger.debug((Object)"RulesResourceAdaptor.eventProcessingSuccessful() called.");
    }

    public Object getActivity(ActivityHandle activityHandle) {
        logger.debug((Object)"RulesResourceAdaptor.getActivity() called.");
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        logger.debug((Object)"RuResourceAdaptor.getActivityHandle(obj) called.");
        return null;
    }

    public Marshaler getMarshaler() {
        logger.debug((Object)"RulesResourceAdaptor.getMarshaler() called.");
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        logger.debug((Object)("RulesResourceAdaptor.getSBBResourceAdapterInterface(" + str + ") called."));
        return this.raProvider;
    }

    public void queryLiveness(ActivityHandle arg0) {
        logger.debug((Object)"RulesResourceAdaptor.queryLifeness() called.");
    }

    public void serviceActivated(String arg0) {
        logger.debug((Object)"RulesResourceAdaptor.serviceActivated() called.");
    }

    public void serviceDeactivated(String arg0) {
        logger.debug((Object)"RulesResourceAdaptor.serviceDeactivated() called.");
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
        logger.debug((Object)"RulesResourceAdaptor.serviceInstalled() called.");
    }

    public void serviceUninstalled(String arg0) {
        logger.debug((Object)"RulesResourceAdaptor.serviceUninstalled() called.");
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new RulesActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("JNDI name to unregister: " + javaJNDIName));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"JNDI name unregistered.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)e);
        }
    }

    SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }
}

