/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.rmi.server.UID;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.SuperTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogWrapper
implements DialogActivity,
WrapperSuperInterface {
    protected Dialog wrappedDialog = null;
    protected SipActivityHandle sipActivityHandle;
    protected String initiatingTransctionId = null;
    protected SipResourceAdaptor ra;
    protected ConcurrentHashMap<String, ClientTransaction> ongoingClientTransactions = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, ServerTransaction> ongoingServerTransactions = new ConcurrentHashMap();
    protected SleeSipProviderImpl provider = null;
    protected static final Logger logger = Logger.getLogger(DialogWrapper.class);

    public DialogWrapper(Dialog wrappedDialog, String initTxID, SleeSipProviderImpl provider, SipResourceAdaptor ra) {
        if (wrappedDialog.getApplicationData() != null) {
            if (wrappedDialog.getApplicationData() instanceof DialogWrapper) {
                throw new IllegalArgumentException("Dialog to wrap has alredy a wrapper!!!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overwriting application data present - " + wrappedDialog.getApplicationData()));
            }
        }
        this.wrappedDialog = wrappedDialog;
        this.wrappedDialog.setApplicationData((Object)this);
        this.initiatingTransctionId = initTxID;
        this.provider = provider;
        this.ra = ra;
        this.sipActivityHandle = new SipActivityHandle(new UID().toString());
    }

    @Override
    public void cleanup() {
        this.wrappedDialog.setApplicationData(null);
        this.wrappedDialog = null;
        this.sipActivityHandle = null;
        this.initiatingTransctionId = null;
        this.ra = null;
        this.ongoingClientTransactions = null;
        this.ongoingServerTransactions = null;
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            throw new IllegalArgumentException("Client transaction is not in ongoing transaction list!!!");
        }
        if (st != null) {
            if (!((DialogWrapper)st.getDialog()).hasOngoingServerTransaction(st.getBranchId())) {
                throw new IllegalArgumentException("Server transaction is not in ongoing transaction list!!!");
            }
            ((ClientTransactionWrapper)ct).associateServerTransaction(st.getBranchId(), ((DialogWrapper)st.getDialog()).getActivityHandle());
        } else {
            ((ClientTransactionWrapper)ct).associateServerTransaction(null, null);
        }
    }

    public Request createRequest(Request origRequest) throws SipException {
        Request forgedRequest = this.wrappedDialog.createRequest(origRequest.getMethod());
        HashSet<String> headersToOmmit = new HashSet<String>();
        headersToOmmit.add("Route");
        headersToOmmit.add("Record-Route");
        headersToOmmit.add("Via");
        headersToOmmit.add("Call-ID");
        headersToOmmit.add("CSeq");
        this.forgeMessage((Message)origRequest, (Message)forgedRequest, headersToOmmit);
        return forgedRequest;
    }

    public Response createResponse(ServerTransaction origServerTransaction, Response receivedResponse) throws SipException {
        Response forgedResponse;
        if (!this.hasOngoingServerTransaction(origServerTransaction.getBranchId())) {
            throw new IllegalArgumentException("Passed server transaction is not in ongoing STX list for this dialog!!!!");
        }
        try {
            forgedResponse = this.provider.getMessageFactory().createResponse(receivedResponse.getStatusCode(), origServerTransaction.getRequest());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SipException("Failed to forge message", (Throwable)e);
        }
        HashSet<String> headersToOmmit = new HashSet<String>();
        headersToOmmit.add("Route");
        headersToOmmit.add("Record-Route");
        headersToOmmit.add("Via");
        headersToOmmit.add("Call-ID");
        headersToOmmit.add("CSeq");
        headersToOmmit.add("Contact");
        this.forgeMessage((Message)receivedResponse, (Message)forgedResponse, headersToOmmit);
        forgedResponse.addHeader((Header)this.provider.getHeaderFactory().createContactHeader(this.getLocalParty()));
        return forgedResponse;
    }

    public ServerTransaction getAssociatedServerTransaction(ClientTransaction ct) {
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            throw new IllegalArgumentException("Passed client transaction is not running for this dialog");
        }
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        if (ctw.getAssociatedTransactionBranchId() == null || this.ra.getActivity(ctw.getAssociationHandle()) == null) {
            return null;
        }
        DialogActivity da = (DialogActivity)this.ra.getActivity(ctw.getAssociationHandle());
        return da.getServerTransaction(ctw.getAssociatedTransactionBranchId());
    }

    public ClientTransaction getClientTransaction(String id) {
        return this.ongoingClientTransactions.get(id);
    }

    public String getInitiatingTransactionId() {
        return this.initiatingTransctionId;
    }

    public ServerTransaction getServerTransaction(String id) {
        return this.ongoingServerTransactions.get(id);
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        ClientTransactionWrapper CTW = (ClientTransactionWrapper)this.provider.getNewClientTransaction(request, false);
        this.wrappedDialog.sendRequest((ClientTransaction)CTW.getWrappedTransaction());
        return CTW;
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createAck(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        return this.wrappedDialog.createPrack(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createReliableProvisionalResponse(arg0);
    }

    public Request createRequest(String arg0) throws SipException {
        return this.wrappedDialog.createRequest(arg0);
    }

    public void delete() {
        if (this.wrappedDialog.getState() == null) {
            this.ra.processDialogTerminated(new DialogTerminatedEvent((Object)this.provider, this.wrappedDialog));
        }
        this.wrappedDialog.delete();
    }

    public Object getApplicationData() {
        throw new SecurityException();
    }

    public CallIdHeader getCallId() {
        return this.wrappedDialog.getCallId();
    }

    public String getDialogId() {
        return this.wrappedDialog.getDialogId();
    }

    public Transaction getFirstTransaction() {
        return this.wrappedDialog.getFirstTransaction();
    }

    public Address getLocalParty() {
        return this.wrappedDialog.getLocalParty();
    }

    public long getLocalSeqNumber() {
        return this.wrappedDialog.getLocalSeqNumber();
    }

    public int getLocalSequenceNumber() {
        return this.wrappedDialog.getLocalSequenceNumber();
    }

    public String getLocalTag() {
        return this.wrappedDialog.getLocalTag();
    }

    public Address getRemoteParty() {
        return this.wrappedDialog.getRemoteParty();
    }

    public long getRemoteSeqNumber() {
        return this.wrappedDialog.getRemoteSeqNumber();
    }

    public int getRemoteSequenceNumber() {
        return this.wrappedDialog.getRemoteSequenceNumber();
    }

    public String getRemoteTag() {
        return this.wrappedDialog.getRemoteTag();
    }

    public Address getRemoteTarget() {
        return this.wrappedDialog.getRemoteTarget();
    }

    public Iterator getRouteSet() {
        return this.wrappedDialog.getRouteSet();
    }

    public DialogState getState() {
        return this.wrappedDialog.getState();
    }

    public void incrementLocalSequenceNumber() {
        this.wrappedDialog.incrementLocalSequenceNumber();
    }

    public boolean isSecure() {
        return this.wrappedDialog.isSecure();
    }

    public boolean isServer() {
        return this.wrappedDialog.isServer();
    }

    public void sendAck(Request arg0) throws SipException {
        this.wrappedDialog.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.wrappedDialog.sendReliableProvisionalResponse(arg0);
    }

    public void sendRequest(ClientTransaction arg0) throws TransactionDoesNotExistException, SipException {
        this.wrappedDialog.sendRequest((ClientTransaction)((ClientTransactionWrapper)arg0).getWrappedTransaction());
    }

    public void setApplicationData(Object arg0) {
        throw new SecurityException();
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.wrappedDialog.terminateOnBye(arg0);
    }

    @Override
    public SipActivityHandle getActivityHandle() {
        return this.sipActivityHandle;
    }

    public Object getWrappedObject() {
        return this.wrappedDialog;
    }

    public boolean hasOngoingServerTransaction(String branchID) {
        return this.ongoingServerTransactions.containsKey(branchID);
    }

    public boolean hasOngoingClientTransaction(String branchID) {
        return this.ongoingClientTransactions.containsKey(branchID);
    }

    public void addOngoingTransaction(ServerTransactionWrapper stw) {
        this.ongoingServerTransactions.putIfAbsent(stw.getBranchId(), stw);
    }

    public void addOngoingTransaction(ClientTransactionWrapper ctw) {
        this.ongoingClientTransactions.putIfAbsent(ctw.getBranchId(), ctw);
    }

    public void removeOngoingTransaction(ClientTransactionWrapper ctw) {
        this.ongoingClientTransactions.remove(ctw.getBranchId());
    }

    public void removeOngoingTransaction(ServerTransactionWrapper stw) {
        this.ongoingServerTransactions.remove(stw.getBranchId());
    }

    public void removeOngoingTransaction(SuperTransactionWrapper stw) {
    }

    public void clearOngoingTransaction() {
        this.ongoingClientTransactions.clear();
        this.ongoingServerTransactions.clear();
    }

    public void clearAssociations() {
    }

    private void forgeMessage(Message originalMessage, Message forgedMessage, Set<String> headerstoOmmit) throws SipException {
        ListIterator lit = originalMessage.getHeaderNames();
        while (lit.hasNext()) {
            String headerName = (String)lit.next();
            if (headerName.equals("To") || headerName.equals("From")) {
                Parameters origHeader = (Parameters)originalMessage.getHeader(headerName);
                Parameters forgedHeader = (Parameters)forgedMessage.getHeader(headerName);
                Iterator it = origHeader.getParameterNames();
                HashSet<String> toOmmit = new HashSet<String>();
                toOmmit.add("tag");
                this.copyParameters(headerName, origHeader, forgedHeader, toOmmit);
                continue;
            }
            if (headerstoOmmit.contains(headerName)) continue;
            if (forgedMessage.getHeaders(headerName).hasNext()) {
                forgedMessage.removeHeader(headerName);
            }
            ListIterator headersIterator = originalMessage.getHeaders(headerName);
            while (headersIterator.hasNext()) {
                Header origHeader = (Header)headersIterator.next();
                Header forgedHeader = null;
                try {
                    forgedHeader = this.provider.getHeaderFactory().createHeader(headerName, origHeader.toString().substring(origHeader.toString().indexOf(":") + 1));
                    forgedMessage.addLast(forgedHeader);
                }
                catch (ParseException e) {
                    logger.error((Object)("Failed to generate header on [" + headerName + "]. To copy value [" + origHeader + "]\n"), (Throwable)e);
                    throw new SipException("Major failure", (Throwable)e);
                }
            }
        }
        byte[] rawOriginal = originalMessage.getRawContent();
        if (rawOriginal != null && rawOriginal.length != 0) {
            byte[] copy = new byte[rawOriginal.length];
            System.arraycopy(rawOriginal, 0, copy, 0, copy.length);
            try {
                forgedMessage.setContent((Object)new String(copy), (ContentTypeHeader)forgedMessage.getHeader("Content-Type"));
            }
            catch (ParseException e) {
                logger.error((Object)("Failed to set content on forged message. To copy value [" + new String(copy) + "] Type [" + forgedMessage.getHeader("Content-Type") + "]\n"), (Throwable)e);
            }
        }
    }

    private void copyParameters(String name, Parameters origHeader, Parameters forgedHeader, Set<String> toOmmit) {
        Iterator it = origHeader.getParameterNames();
        while (it.hasNext()) {
            String p_name = (String)it.next();
            if (toOmmit.contains(p_name) || forgedHeader.getParameter(p_name) != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ommiting parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]"));
                continue;
            }
            try {
                forgedHeader.setParameter(p_name, origHeader.getParameter(p_name));
            }
            catch (ParseException e) {
                logger.error((Object)("Failed to pass parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]"), (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Dialog Id[" + this.getDialogId() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.size() + "] OngoingSTX[" + this.ongoingServerTransactions.size() + "]";
    }
}

