package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.message.SIPRequest;

import java.rmi.server.UID;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.Parameters;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.AddressPlan;

import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.DialogForkedEvent;

import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;

public class DialogWrapper implements DialogActivity, WrapperSuperInterface {

	
	public final static Set<String> dialogCreatingMethods;
	static {
		Set<String> set = new HashSet<String>();
		set.add(Request.INVITE);
		set.add(Request.REFER);
		set.add(Request.SUBSCRIBE);
		dialogCreatingMethods = Collections.unmodifiableSet(set);
	}
	
	protected javax.sip.Dialog wrappedDialog = null;
	protected SipActivityHandle sipActivityHandle;
	protected String initiatingTransctionId = null;
	protected SipResourceAdaptor ra;
	
	protected ConcurrentHashMap<String, ClientTransaction> ongoingClientTransactions = new ConcurrentHashMap<String, ClientTransaction>();
	protected ConcurrentHashMap<String, ServerTransaction> ongoingServerTransactions = new ConcurrentHashMap<String, ServerTransaction>();

	protected String lastCancelableTransactionId = null;

	// Forging kit?
	protected SleeSipProviderImpl provider = null;

	protected static final Logger logger = Logger.getLogger(DialogWrapper.class);

	// ######################
	// # STRICTLY FORK AREA #
	// ######################

	private enum DialogForkState {
		AWAIT_FIRST_TAG, AWAIT_FINAL, END
	}

	// Comment: JSIP set ToTag and route list on first provisional response
	// with ToTag and 2xx, so we have to keep track of those for each activity,
	// in order to allow it to send responses to proper peer.
	// This is due to having one SIPDialog for all forks - this is standard for
	// no auto dialog support.
	/**
	 * Indicates sip activity handle for initial dialog activity created for
	 * this dialog - created as first. Child dialogs are represented by dialog
	 * activities with the same wrappedDialog object.
	 * wrappedDialog.getApplicationData() returns always initial dialog activity
	 * or one that won race to get 2xx response
	 */
	SipActivityHandle forkInitialActivityHandle = null;

	protected DialogForkState forkState = DialogForkState.AWAIT_FIRST_TAG;
	/**
	 * Used when: {@link #forkInitialActivityHandle} !=null
	 */
	protected ArrayList<RouteHeader> forkRouteSet = new ArrayList<RouteHeader>();

	/**
	 * Represents local ToTag - see comment above
	 */
	protected String localToTag = null;
	protected SipURI reqeustURI = null;
	// private Address localRemoteParty;
	/**
	 * Cotnains activity handles of fork children.
	 */
	protected ConcurrentHashMap<String, SipActivityHandle> toTag2DialogHandle = new ConcurrentHashMap<String, SipActivityHandle>();
	
	public DialogWrapper(SleeSipProviderImpl provider, SipResourceAdaptor ra) {
		this.provider = provider;
		this.ra = ra;
		// TODO: Come up with something way better, we cant hash on
		// dialogId, since it changes
		// We cant make ID inside change, since this would make Container to
		// leak attached SBBE - we would loose them, as in container view,
		// hash contract on handle would be broken
		// and on each change dialog would be considered as different activity
		sipActivityHandle = new SipActivityHandle(new UID().toString());

		//long id = (long) (System.currentTimeMillis() * ((double) Math.random()) * 100000);
		//long high32 = (id & 0xffffffff00000000L) >> 32;
		//long low32 = (id & 0xffffffffL);
		//autoGeneratedFromTag = high32 + "_" + low32;
		autoGeneratedFromTag = gov.nist.javax.sip.Utils.generateTag();

	}

	public DialogWrapper(Dialog wrappedDialog, SipActivityHandle forkInitialActivityHandle, SleeSipProviderImpl provider, SipResourceAdaptor ra) {
		this(provider, ra);

		this.wrappedDialog = wrappedDialog;
		this.forkInitialActivityHandle = forkInitialActivityHandle;
		if (forkInitialActivityHandle == null) {
			if (wrappedDialog.getApplicationData() != null) {
				if (wrappedDialog.getApplicationData() instanceof DialogWrapper) {
					throw new IllegalArgumentException("Dialog to wrap has alredy a wrapper!!!");
				} else {
					if (logger.isDebugEnabled()) {
						logger.debug("Overwriting application data present - " + wrappedDialog.getApplicationData());
					}
				}

			}

			this.wrappedDialog.setApplicationData(this);
		} else {
			// do nothing
		}

	}

	public void cleanup() {

		if (wrappedDialog != null && this.forkInitialActivityHandle == null) {

			this.wrappedDialog.setApplicationData(null);
			if (!wrappedDialog.isServer()) {

				String key = this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId();
				this.ra.removeClientDialogMapping(key);

			}
				
		}

		this.wrappedDialog = null;
		this.sipActivityHandle = null;

		this.ra = null;
		// FIXE: Clean this ?
		this.ongoingClientTransactions = null;
		this.ongoingServerTransactions = null;
	}

	

	public ClientTransaction getClientTransaction(String id) {
		return this.ongoingClientTransactions.get(id);
	}

	public String getInitiatingTransactionId() {
		return initiatingTransctionId;
	}

	public ServerTransaction getServerTransaction(String id) {
		return this.ongoingServerTransactions.get(id);
	}

	

	public Request createAck(long arg0) throws InvalidArgumentException, SipException {
		return wrappedDialog.createAck(arg0);
	}

	public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
		return this.wrappedDialog.createPrack(arg0);
	}

	public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
		return this.wrappedDialog.createReliableProvisionalResponse(arg0);
	}

	public Request createRequest(String arg0) throws SipException {
		return this.wrappedDialog.createRequest(arg0);
	}

	public void delete() {
		// This ensures that dialog will be removed
		if (wrappedDialog == null) {
			ra.processDialogTerminated(new DialogTerminatedEvent(this.provider, this));

		} else if (this.forkInitialActivityHandle == null) {

			// We are master, if we die, everything else does
			// FIXME: is above statement correct?
			try {
				this.terminateFork(this.getActivityHandle());
			} finally {

				if (wrappedDialog.getState() == null) {

					ra.processDialogTerminated(new DialogTerminatedEvent(this.provider, wrappedDialog));
				}
			}
			wrappedDialog.delete();
			
		} else {

			ra.processDialogTerminated(new DialogTerminatedEvent(this.provider, this));
		}


	}

	public Object getApplicationData() {
		throw new SecurityException();
	}

	public CallIdHeader getCallId() {
		return this.wrappedDialog.getCallId();
	}

	public String getDialogId() {
		return this.wrappedDialog.getDialogId();
	}

	public Transaction getFirstTransaction() {
		return this.wrappedDialog.getFirstTransaction();
	}

	public Address getLocalParty() {
		return this.wrappedDialog.getLocalParty();
	}

	public long getLocalSeqNumber() {
		return this.wrappedDialog.getLocalSeqNumber();
	}

	public int getLocalSequenceNumber() {
		return this.wrappedDialog.getLocalSequenceNumber();
	}

	public String getLocalTag() {
		return this.wrappedDialog.getLocalTag();
	}

	public Address getRemoteParty() {
		return this.wrappedDialog.getRemoteParty();
	}

	public long getRemoteSeqNumber() {
		return this.wrappedDialog.getRemoteSeqNumber();
	}

	public int getRemoteSequenceNumber() {
		return this.wrappedDialog.getRemoteSequenceNumber();
	}

	public String getRemoteTag() {
		return this.wrappedDialog.getRemoteTag();
	}

	public Address getRemoteTarget() {
		return this.wrappedDialog.getRemoteTarget();
	}

	public Iterator getRouteSet() {
		return this.wrappedDialog.getRouteSet();
	}

	public DialogState getState() {
		return this.wrappedDialog.getState();
	}

	public void incrementLocalSequenceNumber() {

		this.wrappedDialog.incrementLocalSequenceNumber();

	}

	public boolean isSecure() {
		return wrappedDialog.isSecure();
	}

	public boolean isServer() {
		return wrappedDialog.isServer();
	}

	public void sendAck(Request arg0) throws SipException {
		wrappedDialog.sendAck(arg0);
	}

	public void sendReliableProvisionalResponse(Response arg0) throws SipException {
		wrappedDialog.sendReliableProvisionalResponse(arg0);
	}

	public void sendRequest(ClientTransaction arg0) throws TransactionDoesNotExistException, SipException {
		// TODO: add check for wrapper
		wrappedDialog.sendRequest((ClientTransaction) ((ClientTransactionWrapper) arg0).getWrappedTransaction());
	}

	public void setApplicationData(Object arg0) {
		throw new SecurityException();
	}

	public void terminateOnBye(boolean arg0) throws SipException {
		wrappedDialog.terminateOnBye(arg0);
	}

	public SipActivityHandle getActivityHandle() {
		return this.sipActivityHandle;
	}

	public Object getWrappedObject() {
		return this.wrappedDialog;
	}

	public boolean hasOngoingServerTransaction(String branchID) {
		return this.ongoingServerTransactions.containsKey(branchID);
	}

	public boolean hasOngoingClientTransaction(String branchID) {
		return this.ongoingClientTransactions.containsKey(branchID);
	}

	public void addOngoingTransaction(ServerTransactionWrapper stw) {
		this.ongoingServerTransactions.putIfAbsent(stw.getBranchId(), stw);
	}

	public void addOngoingTransaction(ClientTransactionWrapper ctw) {
		this.ongoingClientTransactions.putIfAbsent(ctw.getBranchId(), ctw);
	}

	public void removeOngoingTransaction(ClientTransactionWrapper ctw) {
		// synchronized (this.wrappedDialog) {
		// if (this.getState() != DialogState.TERMINATED)
		this.ongoingClientTransactions.remove(ctw.getBranchId());

		// }

	}

	public void removeOngoingTransaction(ServerTransactionWrapper stw) {
		// synchronized (this.ongoingServerTransactions) {
		// if (this.getState() != DialogState.TERMINATED)
		this.ongoingServerTransactions.remove(stw.getBranchId());
		// }
	}

	public void removeOngoingTransaction(SuperTransactionWrapper stw) {

	}

	public void clearOngoingTransaction() {
		this.ongoingClientTransactions.clear();
		this.ongoingServerTransactions.clear();
	}

	public void clearAssociations() {

	}

	// =========================== XXX: Helper methods =====================
	private void forgeMessage(Message originalMessage, Message forgedMessage, Set<String> headerstoOmmit)
			throws SipException {
		// We leave to and from with tags from this dialog, but copy all other
		// parameters
		// Route headers are from this dialog
		ListIterator lit = originalMessage.getHeaderNames();
		while (lit.hasNext()) {

			String headerName = (String) lit.next();

			// FIXME: Could be wrong - but, if there is value in forgedRequest,
			// we leave original value
			// FIXME: What about address URI parameters?
			// FIXME: What about MaxForwards?
			if (headerName.equals(ToHeader.NAME) || headerName.equals(FromHeader.NAME)) {
				Parameters origHeader, forgedHeader;
				origHeader = (Parameters) originalMessage.getHeader(headerName);
				forgedHeader = (Parameters) forgedMessage.getHeader(headerName);
				Iterator it = origHeader.getParameterNames();
				Set<String> toOmmit = new HashSet<String>();
				toOmmit.add("tag");
				copyParameters(headerName, origHeader, forgedHeader, toOmmit);
			} else if (headerstoOmmit.contains(headerName)) {
				continue;
			} else {
				// FIXME: For now we simply copy everything, overwrte existing
				// headers

				if (forgedMessage.getHeaders(headerName).hasNext())
					forgedMessage.removeHeader(headerName);

				ListIterator headersIterator = originalMessage.getHeaders(headerName);

				while (headersIterator.hasNext()) {
					Header origHeader, forgedHeader;

					// origHeader = (Header)
					// originalMessage.getHeader(headerName);
					origHeader = (Header) headersIterator.next();

					forgedHeader = null;

					try {
						forgedHeader = (Header) this.provider.getHeaderFactory().createHeader(headerName,
								origHeader.toString().substring(origHeader.toString().indexOf(":") + 1));

						forgedMessage.addLast((javax.sip.header.Header) forgedHeader);
					} catch (ParseException e) {
						logger.error("Failed to generate header on [" + headerName + "]. To copy value [" + origHeader
								+ "]\n", e);
						throw new SipException("Major failure", e);
					}

				}
			}
		}

		// Copy content
		byte[] rawOriginal = originalMessage.getRawContent();
		if (rawOriginal != null && rawOriginal.length != 0) {
			byte[] copy = new byte[rawOriginal.length];
			System.arraycopy(rawOriginal, 0, copy, 0, copy.length);
			try {
				forgedMessage.setContent(new String(copy), (ContentTypeHeader) forgedMessage
						.getHeader(ContentTypeHeader.NAME));
			} catch (ParseException e) {
				logger.error("Failed to set content on forged message. To copy value [" + new String(copy) + "] Type ["
						+ forgedMessage.getHeader(ContentTypeHeader.NAME) + "]\n", e);
			}
		}

	}

	private void copyParameters(String name, Parameters origHeader, Parameters forgedHeader, Set<String> toOmmit) {

		// FIXME: This will fail for parameters such as lr ??
		Iterator it = origHeader.getParameterNames();

		while (it.hasNext()) {
			String p_name = (String) it.next();
			if (toOmmit.contains(p_name) || forgedHeader.getParameter(p_name) != null) {
				if (logger.isDebugEnabled()) {
					logger.debug("Ommiting parameter on [" + name + "]. To copy value ["
							+ origHeader.getParameter(p_name) + "]\nValue in forged ["
							+ forgedHeader.getParameter(p_name) + "]");
				}
			} else {
				try {
					forgedHeader.setParameter(p_name, origHeader.getParameter(p_name));
				} catch (ParseException e) {
					logger.error("Failed to pass parameter on [" + name + "]. To copy value ["
							+ origHeader.getParameter(p_name) + "]\nValue in forged ["
							+ forgedHeader.getParameter(p_name) + "]", e);
				}
			}
		}

	}

	public String toString() {
		return "Dialog Id[" + this.getDialogId() + "] State[" + this.getState() + "] OngoingCTX["
				+ this.ongoingClientTransactions.size() + "] OngoingSTX[" + this.ongoingServerTransactions.size() + "]";
	}

	
	// ###########################################
	// # Strictly DialogActivity defined methods #
	// ###########################################

	public ClientTransaction sendCancel() throws SipException {

		verifyDialogExistency();
		try {
			ClientTransaction inviteCTX = this.getClientTransaction(lastCancelableTransactionId);
			Request cancelRequest = inviteCTX.createCancel();
			ClientTransaction cancelTransaction = this.provider.getNewClientTransaction(cancelRequest, false);
			cancelTransaction.sendRequest();
			return cancelTransaction;
		} catch (NullPointerException npe) {
			if (logger.isDebugEnabled()) {
				logger.debug(npe);
			}
			throw new SipException("Possibly fialed to obtain client transaction or no INVITE transaction present");
		} catch (Exception e) {

			throw new SipException("Failed to send CANCEL due to:", e);
		}
	}

	public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
		// ct MUST be in ongoing transaction, its local, st - comes from another
		// dialog
		verifyDialogExistency();
		if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
			throw new IllegalArgumentException("Client transaction is not in ongoing transaction list!!!");
		}

		if (st != null) {
			if (!((DialogWrapper) st.getDialog()).hasOngoingServerTransaction(st.getBranchId())) {
				throw new IllegalArgumentException("Server transaction is not in ongoing transaction list!!!");
			}
			// XXX: ctx can be associated to only one stx, however stx can have
			// multiple ctx

			((ClientTransactionWrapper) ct).associateServerTransaction(st.getBranchId(), ((DialogWrapper) st.getDialog()).getActivityHandle());
		} else {
			((ClientTransactionWrapper) ct).associateServerTransaction(null, null);
		}

	}

	public Request createRequest(Request origRequest) throws SipException {
		
		Request forgedRequest = null;
		if (this.wrappedDialog != null) {
			forgedRequest = this.wrappedDialog.createRequest(origRequest.getMethod());
		} else {
			try {
				MaxForwardsHeader mf = this.provider.getHeaderFactory().createMaxForwardsHeader(70);

				forgedRequest = this.provider.getMessageFactory().createRequest(null);
				forgedRequest.setRequestURI(origRequest.getRequestURI());
				forgedRequest.addHeader(mf);
				forgedRequest.addHeader(callIdToReUse);
				CSeqHeader cseqHeader=(CSeqHeader) origRequest.getHeader(CSeqHeader.NAME);
				forgedRequest.addHeader(cseqHeader);
				// this will override CSeq number
				if(forgedRequest.getMethod()==null)
					((SIPRequest) forgedRequest).setMethod(cseqHeader.getMethod());
				fillRequestHeaders(forgedRequest);
			} catch (Exception e) {

				throw new SipException("", e);
			}

		}

		Set<String> headersToOmmit = new HashSet<String>();
		headersToOmmit.add(RouteHeader.NAME);
		headersToOmmit.add(RecordRouteHeader.NAME);
		// headersToOmmit.add(ViaHeader.NAME);
		headersToOmmit.add(CallIdHeader.NAME);
		headersToOmmit.add(CSeqHeader.NAME);

		forgeMessage(origRequest, forgedRequest, headersToOmmit);
		//FIXME: ???
		forgedRequest.addFirst(provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
		
		return forgedRequest;
	}

	public Response createResponse(ServerTransaction origServerTransaction, Response receivedResponse) throws SipException {

		
		if (!this.hasOngoingServerTransaction(origServerTransaction.getBranchId()))
			throw new IllegalArgumentException("Passed server transaction is not in ongoing STX list for this dialog!!!!");

		Response forgedResponse;
		try {
			// I thinks this will fail?
			forgedResponse = this.provider.getMessageFactory().createResponse(receivedResponse.getStatusCode(), origServerTransaction.getRequest());
		} catch (ParseException e) {

			e.printStackTrace();
			throw new SipException("Failed to forge message", e);
		}
		Set<String> headersToOmmit = new HashSet<String>();
		headersToOmmit.add(RouteHeader.NAME);
		headersToOmmit.add(RecordRouteHeader.NAME);
		headersToOmmit.add(ViaHeader.NAME);
		headersToOmmit.add(CallIdHeader.NAME);
		headersToOmmit.add(CSeqHeader.NAME);
		headersToOmmit.add(ContactHeader.NAME);
		forgeMessage(receivedResponse, forgedResponse, headersToOmmit);
		forgedResponse.addHeader(this.provider.getHeaderFactory().createContactHeader(this.getLocalParty()));
		//If we are client Dialog, we can receive response with ToTag, when local is not present, we shoudl copy
		ToHeader localToHeader=(ToHeader) forgedResponse.getHeader(ToHeader.NAME);
		System.out.println("{"+(localToHeader.getTag()==null)+"}{"+(!this.isServer())+"}");
		if(localToHeader.getTag()==null && this.isServer())
		{
			ToHeader otherToHeader=(ToHeader) receivedResponse.getHeader(ToHeader.NAME);
			try {

				localToHeader.setTag(otherToHeader.getTag());
			} catch (ParseException e) {
				e.printStackTrace();
				throw new SipException("Failed to set ToTag", e);
			}
		}
	
		return forgedResponse;
	}

	public ServerTransaction getAssociatedServerTransaction(ClientTransaction ct) {

		if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
			throw new IllegalArgumentException("Passed client transaction is not running for this dialog");
		}

		ClientTransactionWrapper ctw = (ClientTransactionWrapper) ct;
		if (ctw.getAssociatedTransactionBranchId() == null || ra.getActivity(ctw.getAssociationHandle()) == null) {
			return null;
		} else {
			DialogWrapper da = (DialogWrapper) ra.getActivity(ctw.getAssociationHandle());
			return da.getServerTransaction(ctw.getAssociatedTransactionBranchId());
		}
	}

	public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {

		if (wrappedDialog == null && !dialogCreatingMethods.contains(request.getMethod())) {
			throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod()
					+ " is not dialog creating one");
		}

		fillRequestHeaders(request);

		ClientTransactionWrapper CTW = (ClientTransactionWrapper) this.provider.getNewClientTransaction(request, false);

		if (request.getMethod().equals(Request.INVITE))
			lastCancelableTransactionId = CTW.getBranchId();
		if (wrappedDialog == null) {
			this.wrappedDialog = this.provider.getNewDialog(CTW,null, false);
			this.wrappedDialog.setApplicationData(this);
			// this.ra.addClientDialogMaping(this.wrappedDialog.getLocalTag()+"_"+this.wrappedDialog.getCallId().getCallId(),
			// this.getActivityHandle());
		}

		this.addOngoingTransaction(CTW);
		CTW.sendRequest();
		// logger.info("---------===================------ SENT REQUEST:\n" +
		// request);
		return CTW;
	}

	// ##############################################################
	// # Strictly dialog forge - used when no dialog is present yet #
	// ##############################################################
	protected Address fromAddress, toAddress;
	protected CallIdHeader callIdToReUse = null;
	protected String autoGeneratedFromTag = null;

	public void setFromAddress(Address fromAddress) {
		this.fromAddress = fromAddress;
	}

	public void setToAddress(Address toAddress) {
		this.toAddress = toAddress;
	}

	public void setCallIdToReUse(CallIdHeader callIdToReUse) {
		this.callIdToReUse = callIdToReUse;
	}

	private void verifyDialogExistency() {
		if (wrappedDialog == null) {
			throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet!");
		}
	}

	/**
	 * This should be used on reqeusts when wrapped dialog is null - this DW was
	 * created by getNewDialog(from,to) or
	 * getNewDialog(incomingDialog,reuseCallId).
	 * 
	 * @param request
	 * @throws SipException
	 */
	private void fillRequestHeaders(Request request) throws SipException {
		String method = request.getMethod();

		if (!method.equals(Request.CANCEL) && !method.equals(Request.ACK))
			try {

				if ((this.forkInitialActivityHandle != null || this.forkState != DialogForkState.END) && !wrappedDialog.isServer()) {
					// We have wrappedDialog, but we cant relly on its info,
					// only CallId, from address, to addres, fromheader are
					// static
					request.removeHeader(CallIdHeader.NAME);
					request.addLast(wrappedDialog.getCallId());

					ToHeader toHeader = (ToHeader) request.getHeader(ToHeader.NAME);
					FromHeader fromHeader = (FromHeader) request.getHeader(FromHeader.NAME);

					if (toHeader == null || !toHeader.getAddress().equals(wrappedDialog.getRemoteParty()))
						toHeader = this.provider.getHeaderFactory().createToHeader(toAddress, null);

					if (localToTag != null && !localToTag.equals(toHeader.getTag())) {
						toHeader.setTag(localToTag);
					}
					request.removeHeader(toHeader.NAME);
					request.addHeader(toHeader);

					if (fromHeader == null || !fromHeader.getAddress().equals(wrappedDialog.getLocalParty()))
						fromHeader = this.provider.getHeaderFactory().createFromHeader(wrappedDialog.getLocalParty(), wrappedDialog.getLocalTag());

					request.removeHeader(fromHeader.NAME);
					request.addHeader(fromHeader);

					if (forkRouteSet.size() > 0) {
						request.removeHeader(RouteHeader.NAME);
						for (int i = 0; i < forkRouteSet.size(); i++) {
							request.addLast(forkRouteSet.get(i));
						}
					}

					request.setRequestURI(this.reqeustURI);

				} else if (this.forkState == DialogForkState.END) {

				} else {
					//FIXME: this can be wrong
					request.removeHeader(CallIdHeader.NAME);
					request.addLast(callIdToReUse);

					ToHeader toHeader = (ToHeader) request.getHeader(ToHeader.NAME);
					FromHeader fromHeader = (FromHeader) request.getHeader(FromHeader.NAME);

					if (toHeader == null) {
						toHeader = this.provider.getHeaderFactory().createToHeader(toAddress, null);

					} else {
						toHeader.setAddress(toAddress);
						if (wrappedDialog != null) {
							toHeader.setTag(wrappedDialog.getRemoteTag());
						}
					}
					request.removeHeader(toHeader.NAME);
					request.addLast(toHeader);
					if (fromHeader == null || !fromHeader.getAddress().equals(fromAddress)) {
						fromHeader = this.provider.getHeaderFactory().createFromHeader(fromAddress, autoGeneratedFromTag);

					} else {
						fromHeader.setAddress(fromAddress);
						fromHeader.setTag(autoGeneratedFromTag);

					}
					request.removeHeader(fromHeader.NAME);
					request.addLast(fromHeader);

					// route header set process
					if (request.getHeader(RouteHeader.NAME) == null) {
						if (wrappedDialog != null) {
							Iterator routeIterator = wrappedDialog.getRouteSet();
							while (routeIterator.hasNext()) {
								request.addHeader((Header) routeIterator.next());
							}
						}
					}

				}

			} catch (Exception e) {

				throw new SipException("Couldnt add specs headers due to:", e);
			}
	}

	/**
	 * Does response processing in dialog
	 * 
	 * @param respEvent
	 * @return <ul>
	 *         <li><b>true</b> - if DialogWrapper finished processing and RA
	 *         doesnt have to take any action</li>
	 *         <li><b>false</b> - DialogWrapper did nothing, ra should triger
	 *         regular logic</li>
	 *         </ul>
	 */
	public boolean processIncomingResponse(ResponseEvent respEvent) {
		// public synchronized boolean processIncomingResponse(ResponseEvent
		// respEvent) {
		// FIXME: not very good idea to cross message sending logic between RA
		// and DW
		// possibly it would be better to move indialog sending logic entirely
		// to DW ?
		// But we need it only in cases DW ends,has to send message to child or
		// indicate forking
		Response response = respEvent.getResponse();
		boolean firedByDialogWrapper = false;
		int statusCode = response.getStatusCode();
		String toTag = ((ToHeader) response.getHeader(ToHeader.NAME)).getTag();
		DialogForkState oldForkState = this.forkState;
		SipActivityHandle masterActivityHandle = this.getActivityHandle();

		if (wrappedDialog.isServer()) {
			// FIXME: do nothing
			// action.setAction(DialogClientForkAction.DO_NOTHING);
			return false;
		}

		switch (this.forkState) {
		case AWAIT_FIRST_TAG:

			if (100 <= statusCode && statusCode < 200) {
				if (toTag != null) {

					this.localToTag = toTag;
					this.forkState = DialogForkState.AWAIT_FINAL;
					this.toTag2DialogHandle.put(this.localToTag, this.sipActivityHandle);
					this.fetchData(response);
					this.ra.addClientDialogMaping(this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId(), getActivityHandle());
				}
				if (logger.isDebugEnabled()) {
					logger.debug("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
				// FIXME: fire on this, original message
				firedByDialogWrapper = false;

			} else if (statusCode < 300) {
				this.forkState = DialogForkState.END;
				// This one is the master, here we can have only one dialog,
				// this one, so we dont care about simblings, we just dont have
				// those
				// baranowb: what should we do if no toTag?
				this.localToTag = toTag;
				this.toTag2DialogHandle.put(toTag, this.sipActivityHandle);
				this.fetchData(response);

				if (logger.isDebugEnabled()) {
					logger.debug("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
				// FIXME: fire on this, original message
				firedByDialogWrapper = false;

				// just in case
				terminateFork(masterActivityHandle);

			} else if (statusCode < 700) {

				this.forkState = DialogForkState.END;
				if (logger.isDebugEnabled()) {
					logger.debug("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
				// FIXME: fire on this, original message

				int eventID = this.ra.eventIdCache.getEventId(this.ra.getEventLookup(), response);
				ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, response);
				this.ra.fireEvent(REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME)).getAddress()
						.toString()));
				firedByDialogWrapper = true;

				terminateFork(null);

			} else {
				if (logger.isDebugEnabled()) {
					logger.debug("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
			}
			break;
		case AWAIT_FINAL:

			if (100 <= statusCode && statusCode < 200) {

				if (logger.isDebugEnabled()) {
					logger.debug("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
				if (toTag == null) {
					// FIXME: fire on this
					firedByDialogWrapper = false;
				} else if (toTag.equals(localToTag)) {

					this.fetchData(response);
					firedByDialogWrapper = false;
					// FIXME: fire on this
				} else if (this.toTag2DialogHandle.containsKey(toTag)) {

					// other dialog wins
					DialogWrapper child = (DialogWrapper) this.ra.getActivity(this.toTag2DialogHandle.get(toTag));
					if (child == null) {
						this.toTag2DialogHandle.remove(toTag);

						return true;
					}
					child.fetchData(response);
					// FIXME: fire on child, original message
					int eventID = this.ra.eventIdCache.getEventId(this.ra.getEventLookup(), response);
					logger.info("Received 1xx message: " + statusCode + ". ToTag:" + toTag + "EventId:" + eventID);
					ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, response);
					this.ra.fireEvent(REW, child.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME))
							.getAddress().toString()));
					firedByDialogWrapper = true;
				} else {
					// We create fake dialog that - as a child of master
					DialogWrapper child = this.provider.getNewDialogActivity(wrappedDialog, this.getActivityHandle(), null);
					child.forkState = this.forkState;

					child.localToTag = toTag;
					child.fetchData(response);
					this.toTag2DialogHandle.put(toTag, child.getActivityHandle());

					// FIXME: fire on original, dialog forked
					int eventID = this.ra.eventIdCache.getDialogForkEventId(this.ra.getEventLookup());

					DialogForkedEvent REW = new DialogForkedEvent(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, child, response);
					this.ra.fireEvent(REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME))
							.getAddress().toString()));
					firedByDialogWrapper = true;
				}

			} else if (statusCode < 300) {

				this.forkState = DialogForkState.END;
				if (logger.isDebugEnabled()) {
					logger.debug("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}

				if (this.localToTag != null && this.localToTag.equals(toTag)) {
					// we win
					this.fetchData(response);
					// FIXME: fire on original, original message
					firedByDialogWrapper = false;
				} else if (this.toTag2DialogHandle.containsKey(toTag)) {

					// other dialog wins

					DialogWrapper child = (DialogWrapper) this.ra.getActivity(this.toTag2DialogHandle.get(toTag));
					child.fetchData(response);
					masterActivityHandle = child.getActivityHandle();
					child.makeMaster();
					if (child != this)
						this.forkInitialActivityHandle = child.getActivityHandle();
					else {
						logger.error("Local: " + localToTag + " : " + toTag + " MSG:\n" + response);
					}

					// FIXME: fire on child, original message
					int eventID = this.ra.eventIdCache.getEventId(this.ra.getEventLookup(), response);
					ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, response);
					this.ra.fireEvent(REW, child.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME))
							.getAddress().toString()));
					firedByDialogWrapper = true;

				} else {
					// we have completly new master dialog
					// We create fake dialog as a child of master, but this one
					// becomes master
					DialogWrapper child = this.provider.getNewDialogActivity(wrappedDialog, this.getActivityHandle(), null);
					child.forkState = this.forkState;

					child.localToTag = toTag;
					this.toTag2DialogHandle.put(toTag, child.getActivityHandle());
					masterActivityHandle = child.getActivityHandle();
					child.makeMaster();
					this.forkInitialActivityHandle = child.getActivityHandle();
					child.fetchData(response);
					// FIXME: fire on child, original message
					int eventID = this.ra.eventIdCache.getDialogForkEventId(this.ra.getEventLookup());
					DialogForkedEvent REW = new DialogForkedEvent(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, child, response);
					this.ra.fireEvent(REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME))
							.getAddress().toString()));
					firedByDialogWrapper = true;
				}

				// just in case
				terminateFork(masterActivityHandle);
			} else if (statusCode < 700) {

				this.forkState = DialogForkState.END;
				if (logger.isDebugEnabled()) {
					logger.debug("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
				// FIXME: fire on this, original message
				int eventID = this.ra.eventIdCache.getEventId(this.ra.getEventLookup(), response);
				ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction) respEvent.getClientTransaction().getApplicationData(), this, response);
				this.ra.fireEvent(REW, getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader) response.getHeader(FromHeader.NAME)).getAddress()
						.toString()));
				firedByDialogWrapper = true;
				terminateFork(null);

			} else {
				if (logger.isDebugEnabled()) {
					logger.debug("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState + ". On dialog: "
							+ this.toString());
				}
			}

			break;
		case END:
			// Strictly for ending other dialogs - response may come late
			// FIXME: add terminate dialog

			if (!toTag.equals(wrappedDialog.getRemoteTag())) {

				// if 1xx+, 3xx+ we ignore it
				if (statusCode < 200 || statusCode > 300) {
					if (logger.isDebugEnabled()) {
						logger.debug("Received late message, action IGNORE: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + oldForkState + " - new" + this.forkState
								+ ". On dialog: " + this.toString());
					}

				} else {

					// we are in 2xx zone, we have to ack and send bye
					// FIXME: Add proper termiantion for SUBSCRIBE/REFER ???

					if (dialogCreatingMethods.contains(((CSeqHeader) response.getHeader(CSeqHeader.NAME)).getMethod()))
						doTerminateOnLate2xx(respEvent);
				}

				firedByDialogWrapper = true;

			}

			// else we leave it to be fired by normal means ?
			break;

		}

		return firedByDialogWrapper;
	}

	/**
	 * Generare 200 and sends BYE if method == 200, possibly this shoudl also terminate subscriptions?
	 * @param respEvent
	 */
	public void doTerminateOnLate2xx(ResponseEvent respEvent) {

		try {
			Response response = respEvent.getResponse();
			CSeqHeader cseq = (CSeqHeader) response.getHeader(CSeqHeader.NAME);
			List<Header> routeSet = getRouteList(response);
			SipURI requestURI = getReqeustUri(response);

			long cseqNumber = cseq.getSeqNumber();
			long statusCode = response.getStatusCode();

			// logger.info("DOING FORGE FOR: \n"+response);
			if (cseq.getMethod().equals(Request.INVITE) && (statusCode < 300 && statusCode >= 200)) {
				if (requestURI == null) {
					logger.error("Cannot ack on reqeust that has empty contact!!!!");
					return;
				}

				MaxForwardsHeader mf = this.provider.getHeaderFactory().createMaxForwardsHeader(70);

				Request forgedRequest = this.provider.getMessageFactory().createRequest(null);
				forgedRequest.setRequestURI(requestURI);
				forgedRequest.addHeader(mf);
				forgedRequest.addHeader(response.getHeader(CallIdHeader.NAME));
				forgedRequest.addHeader(this.provider.getHeaderFactory().createCSeqHeader(cseqNumber, Request.ACK));
				forgedRequest.addHeader(response.getHeader(FromHeader.NAME));
				forgedRequest.addHeader(response.getHeader(ToHeader.NAME));
				for (Header h : routeSet) {
					forgedRequest.addLast(h);
				}

				forgedRequest.addHeader(this.provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
				// ITS BUG....
				((SIPRequest) forgedRequest).setMethod(Request.ACK);
				this.provider.sendRequest(forgedRequest);

				forgedRequest = this.provider.getMessageFactory().createRequest(null);
				forgedRequest.setRequestURI(requestURI);
				forgedRequest.addHeader(mf);
				forgedRequest.addHeader(response.getHeader(CallIdHeader.NAME));
				forgedRequest.addHeader(this.provider.getHeaderFactory().createCSeqHeader(cseqNumber + 1, Request.BYE));
				forgedRequest.addHeader(response.getHeader(FromHeader.NAME));
				forgedRequest.addHeader(response.getHeader(ToHeader.NAME));
				for (Header h : routeSet) {
					forgedRequest.addLast(h);
				}

				forgedRequest.addHeader(this.provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
				// ITS BUG....
				((SIPRequest) forgedRequest).setMethod(Request.BYE);

				this.provider.sendRequest(forgedRequest);
			} else {
				// FIXME: add sometihng here?
			}
			// response.get
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Forges reqeust URI using contact and To name par tof address URI, this is
	 * requries since on fork this is how target is determined
	 * 
	 * @param response
	 * @return
	 */
	private SipURI getReqeustUri(Response response) {
		ContactHeader contact = ((ContactHeader) response.getHeader(ContactHeader.NAME));
		if (contact != null) {

			SipURI contactURI = (SipURI) contact.getAddress().getURI();

			SipURI requestURI;
			try {
				requestURI = this.provider.getAddressFactory().createSipURI(contactURI.getUser(), contactURI.getHost());
				requestURI.setPort(contactURI.getPort());
				return requestURI;
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {

		}
		return null;
	}

	/**
	 * Generates route list the same way dialog does.
	 * @param response
	 * @return
	 */
	private List getRouteList(Response response) {
		// we have record route set, as we are client, this is reversed
		ArrayList<RouteHeader> routeList = new ArrayList<RouteHeader>();
		ListIterator rrLit = response.getHeaders(RecordRouteHeader.NAME);

		while (rrLit.hasNext()) {

			RecordRouteHeader rrh = (RecordRouteHeader) rrLit.next();

			RouteHeader rh = this.provider.getHeaderFactory().createRouteHeader(rrh.getAddress());
			Iterator pIt = rrh.getParameterNames();
			while (pIt.hasNext()) {
				String pName = (String) pIt.next();
				try {
					rh.setParameter(pName, rrh.getParameter(pName));
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
			routeList.add(0, rh);
		}

		return routeList;
	}

	private void fetchData(Response response) {
		// fetch routeSet, requestURI and ToTag, callId
		// this is done only once?

		if (localToTag == null) {
			// all of those will become solid after tag is set , but will be
			// present without it.
			localToTag = ((ToHeader) response.getHeader(ToHeader.NAME)).getTag();
			reqeustURI = null;
			forkRouteSet.clear();
		}
		ContactHeader contact = ((ContactHeader) response.getHeader(ContactHeader.NAME));

		if (reqeustURI == null || (contact != null && !reqeustURI.equals(contact.getAddress().getURI()))) {
			reqeustURI = (SipURI) contact.getAddress().getURI();
		}

		if (forkRouteSet.size() == 0) {
			forkRouteSet.addAll(getRouteList(response));
		}

		this.setCallIdToReUse((CallIdHeader) response.getHeader(CallIdHeader.NAME));

	}

	private void terminateFork(SipActivityHandle masterToRetain) {

		// it ConcurrentMod shouldnt happen but...
		HashSet<String> tagSet = new HashSet<String>(toTag2DialogHandle.keySet());
		Iterator<String> tagIterator = tagSet.iterator();

		while (tagIterator.hasNext()) {
			String tag = tagIterator.next();
			if (masterToRetain != null && toTag2DialogHandle.get(tag) == masterToRetain) {
				// tagSet.remove(tag);
				tagIterator.remove();
				continue;
			}
			DialogWrapper dw = (DialogWrapper) this.ra.getActivity(toTag2DialogHandle.get(tag));
			if (dw == null) {
				toTag2DialogHandle.remove(tag);
				tagIterator.remove();
			} else {

				dw.delete();
			}

		}
		// toTag2DialogHandle.keySet().removeAll(tagSet);
	}

	private void makeMaster() {
		this.forkState = DialogForkState.END;
		this.forkInitialActivityHandle = null;
		this.wrappedDialog.setApplicationData(this);
		this.ra.addClientDialogMaping(this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId(), getActivityHandle());
	}

	
	
}
