package org.mobicents.slee.resource.sip11.wrappers;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.slee.SLEEException;

import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;

public class ClientTransactionWrapper extends SuperTransactionWrapper implements
		ClientTransaction, WrapperSuperInterface {

	protected static final Logger logger=Logger.getLogger(ClientTransactionWrapper.class);
	// associated stx
	protected ClientTransactionAssociation association = null;
	
	public ClientTransactionWrapper(ClientTransaction wrappedTransaction) {
		if (wrappedTransaction.getApplicationData() != null) {
			if (wrappedTransaction.getApplicationData() instanceof ClientTransactionWrapper) {
				throw new IllegalArgumentException(
						"ClientTransaction to wrap has alredy a wrapper!!!");
			}
		}
		this.wrappedTransaction = wrappedTransaction;
		this.wrappedTransaction.setApplicationData(this);
		super.sipActivityHandle = generateHandle(this.wrappedTransaction);

	}

	public Dialog getDialog() {
		if(wrappedTransaction==null)
			return null;
		if (this.wrappedTransaction.getDialog() != null && this.wrappedTransaction.getDialog().getApplicationData() != null) {
			return (DialogWrapper) this.wrappedTransaction.getDialog().getApplicationData();
		}
		return null;
	}
	
	public Request createAck() throws SipException {
		if(wrappedTransaction==null)
			throw new SLEEException("Activity is not valid");
		return ((ClientTransaction) wrappedTransaction).createAck();
	}

	public Request createCancel() throws SipException {
		if(wrappedTransaction==null)
			throw new SLEEException("Activity is not valid");
		return ((ClientTransaction) wrappedTransaction).createCancel();
	}

	public String getBranchId() {
		if(wrappedTransaction==null)
			return null;
		return wrappedTransaction.getBranchId();
	}

	public Request getRequest() {
		if(wrappedTransaction==null)
			throw new SLEEException("Activity is not valid");
		return wrappedTransaction.getRequest();
	}

	public int getRetransmitTimer() throws UnsupportedOperationException {
		if(wrappedTransaction==null)
			return -1;
		return wrappedTransaction.getRetransmitTimer();
	}

	public TransactionState getState() {
		if(wrappedTransaction==null)
			return null;
		return wrappedTransaction.getState();
	}

	public void sendRequest() throws SipException {
		//hack to add this tx as cancelable, in case someone use x send, instead of dialog.send(ctx);
		if(wrappedTransaction==null)
			throw new SLEEException("Activity is not valid");
	
			String method =this.wrappedTransaction.getRequest().getMethod();
			if((method.equals(Request.INVITE) || method.equals(Request.SUBSCRIBE)) && getDialog()!=null)
			{
				DialogWrapper dw = (DialogWrapper) getDialog();
				dw.lastCancelableTransactionId = this.getBranchId();
			}
	
		((ClientTransaction) wrappedTransaction).sendRequest();
	}

	public void setRetransmitTimer(int arg0)
			throws UnsupportedOperationException {
		if(wrappedTransaction==null)
			return;
		wrappedTransaction.setRetransmitTimer(arg0);
	}

	public void terminate() throws ObjectInUseException {
		if(wrappedTransaction==null)
			return;
		wrappedTransaction.terminate();
	}

	public String toString() {

		String returnValue = "ClientTransaction Id[" + (this.wrappedTransaction == null ? null : this.getBranchId()) + "]["+this.hashCode()+"] METHOD["
				+ (this.wrappedTransaction == null ? null : this.getRequest().getMethod()) + "] STATE["
				+ (this.wrappedTransaction == null ? null : this.wrappedTransaction.getState()) + "] handle[" + sipActivityHandle + "]";
	

		return returnValue;

	}

	public void associateServerTransaction(String branch,
			SipActivityHandle dialogHandle) {

		if (this.association != null) {
			throw new IllegalStateException(
					"Transaction already associated to ["
							+ this.association.getAssociatedTransactionBranchId() + "] ["
							+ this.association.getAssociationHandle() + "]");

		}
		this.association = new ClientTransactionAssociation(dialogHandle,branch);
	}

	public SipActivityHandle getAssociationHandle() {
		if(this.association==null)
		{
			return null;
		}
		return this.association.getAssociationHandle();
	}

	public String getAssociatedTransactionBranchId() {
		if(this.association==null)
		{
			return null;
		}
		return this.association.getAssociatedTransactionBranchId();
	}

	public void cleanup() {

		if(this.wrappedTransaction != null)
		{
			this.wrappedTransaction.setApplicationData(null);
			this.wrappedTransaction = null;
		}
		this.association = null;
	}

}
