/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import java.util.ArrayList;
import java.util.List;
import javax.sip.ResponseEvent;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.Utils;

public class LateResponseHandler {
    private static Tracer tracer;

    public static void processLateInDialogResponse(ResponseEvent resp, SipResourceAdaptor ra) {
        if (tracer == null) {
            tracer = ra.getTracer(LateResponseHandler.class.getSimpleName());
        }
        String method = ((CSeq)resp.getResponse().getHeader("CSeq")).getMethod();
        if (tracer.isInfoEnabled()) {
            tracer.info("ClientTransaction is null, possibly a late 2xx. ToTag[" + ((ToHeader)resp.getResponse().getHeader("To")).getTag() + "] Dialog[" + resp.getDialog() + "] CALLID[" + ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId() + "] BRANCH[" + ((Via)resp.getResponse().getHeaders("Via").next()).getBranch() + "] METHOD[" + method + "] CODE[" + resp.getResponse().getStatusCode() + "]");
        }
        if (Utils.getDialogCreatingMethods().contains(method)) {
            if (tracer.isFineEnabled()) {
                tracer.fine("No Handle for dialog with such from and callId, using default. CALLID[" + ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId() + "] BRANCH[" + ((Via)resp.getResponse().getHeaders("Via").next()).getBranch() + "] METHOD[" + method + "] CODE[" + resp.getResponse().getStatusCode() + "]");
            }
            LateResponseHandler.doTerminateOnLate2xx(resp, ra);
        }
    }

    public static void doTerminateOnLate2xx(ResponseEvent respEvent, SipResourceAdaptor ra) {
        if (tracer == null) {
            tracer = ra.getTracer(LateResponseHandler.class.getSimpleName());
        }
        SleeSipProviderImpl provider = ra.getProviderWrapper();
        try {
            Response response = respEvent.getResponse();
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            List<RouteHeader> routeSet = Utils.getRouteList(response, provider.getHeaderFactory());
            SipURI requestURI = Utils.getRequestUri(response, provider.getAddressFactory());
            String branch = ((ViaHeader)response.getHeaders("Via").next()).getBranch();
            long cseqNumber = cseq.getSeqNumber();
            long statusCode = response.getStatusCode();
            if (cseq.getMethod().equals("INVITE") && statusCode < 300L && statusCode >= 200L) {
                if (requestURI == null) {
                    tracer.severe("Cannot ack on request that has empty contact!!!!");
                    return;
                }
                MaxForwardsHeader mf = provider.getHeaderFactory().createMaxForwardsHeader(70);
                ArrayList<ViaHeader> lst = new ArrayList<ViaHeader>(1);
                ViaHeader localViaHeader = provider.getLocalVia();
                localViaHeader.setBranch(branch);
                lst.add(localViaHeader);
                Request forgedRequest = provider.getMessageFactory().createRequest((URI)requestURI, "ACK", (CallIdHeader)response.getHeader("Call-ID"), provider.getHeaderFactory().createCSeqHeader(cseqNumber, "ACK"), (FromHeader)response.getHeader("From"), (ToHeader)response.getHeader("To"), lst, mf);
                for (RouteHeader h : routeSet) {
                    forgedRequest.addLast((Header)h);
                }
                if (tracer.isInfoEnabled()) {
                    tracer.info("Sending request:\n" + forgedRequest);
                }
                provider.sendRequest(forgedRequest);
                lst = new ArrayList();
                lst.add(provider.getLocalVia());
                requestURI = Utils.getRequestUri(response, provider.getAddressFactory());
                forgedRequest = provider.getMessageFactory().createRequest((URI)requestURI, "BYE", (CallIdHeader)response.getHeader("Call-ID"), provider.getHeaderFactory().createCSeqHeader(cseqNumber + 1L, "BYE"), (FromHeader)response.getHeader("From"), (ToHeader)response.getHeader("To"), lst, mf);
                for (RouteHeader h : routeSet) {
                    forgedRequest.addLast((Header)h);
                }
                ((SIPRequest)forgedRequest).setMethod("BYE");
                if (tracer.isInfoEnabled()) {
                    tracer.info("Sending request:\n" + forgedRequest);
                }
                provider.sendRequest(forgedRequest);
            }
        }
        catch (Exception e) {
            tracer.severe(e.getMessage(), (Throwable)e);
        }
    }
}

