/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.FireableEventType;
import net.java.slee.resource.sip.DialogForkedEvent;
import org.mobicents.slee.resource.sip11.ClusteredSipActivityManagement;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogForkHandler;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapperData;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;

public class ClientDialogWrapper
extends DialogWrapper {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    protected ClientDialogWrapperData data;

    private ClientDialogWrapper(SipActivityHandle activityHandle, String localTag, SipResourceAdaptor ra, ClientDialogForkHandler forkData) {
        super(activityHandle, localTag, ra);
        this.data = new ClientDialogWrapperData(forkData);
        this.setResourceAdaptor(ra);
    }

    public void setResourceAdaptor(SipResourceAdaptor ra) {
        super.setResourceAdaptor(ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientDialogWrapper.class.getSimpleName());
        }
    }

    public ClientDialogWrapper(Address from, String localTag, Address to, CallIdHeader callIdHeader, SipResourceAdaptor ra, ClientDialogForkHandler forkData) {
        this(new DialogWithoutIdActivityHandle(callIdHeader.getCallId(), localTag, null), localTag, ra, forkData);
        this.data.setToAddress(to);
        this.data.setFromAddress(from);
        this.data.setCustomCallId(callIdHeader);
    }

    private ClientDialogWrapper(DialogWithoutIdActivityHandle forkHandle, ClientDialogWrapper master) {
        this(forkHandle, master.getLocalTag(), master.ra, new ClientDialogForkHandler((DialogWithoutIdActivityHandle)master.activityHandle));
        this.wrappedDialog = master.wrappedDialog;
    }

    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = this.wrappedDialog != null ? super.getEventFiringAddress() : ClientTransactionWrapper.getEventFiringAddress(this.data.getFromAddress());
        }
        return this.eventFiringAddress;
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createAck(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        this.verifyDialogExistency();
        return super.createPrack(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createReliableProvisionalResponse(arg0);
    }

    public void delete() {
        if (this.wrappedDialog == null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Deleting " + this.getActivityHandle() + " dialog activity, there is no wrapped dialog.");
            }
            this.ra.processDialogTerminated(this);
        } else {
            ClientDialogForkHandler forkHandler = this.data.getForkHandler();
            if (forkHandler.getMaster() == null) {
                forkHandler.terminate(this.ra);
                if (forkHandler.getForkWinner() == null) {
                    if (tracer.isFineEnabled()) {
                        tracer.fine("Fully deleting " + this.getActivityHandle() + " dialog, there is no confirmed fork.");
                    }
                    super.delete();
                } else {
                    if (tracer.isFineEnabled()) {
                        tracer.fine("Deleting " + this.getActivityHandle() + " dialog activity, the wrapped dialog is still used by a confirmed fork.");
                    }
                    this.ra.processDialogTerminated(this);
                }
            } else {
                DialogWithoutIdActivityHandle forkWinner = forkHandler.getForkWinner();
                if (forkHandler.isForking() || forkWinner == null || !forkWinner.equals(this.getActivityHandle())) {
                    if (tracer.isFineEnabled()) {
                        tracer.fine("Deleting " + this.getActivityHandle() + " dialog activity, a fork which was not confirmed.");
                    }
                    this.ra.processDialogTerminated(this);
                } else {
                    if (tracer.isFineEnabled()) {
                        tracer.fine("Fully deleting " + this.getActivityHandle() + " dialog, a fork which was confirmed.");
                    }
                    super.delete();
                }
            }
        }
    }

    public CallIdHeader getCallId() {
        if (this.wrappedDialog == null) {
            return this.data.getCustomCallId();
        }
        return super.getCallId();
    }

    public String getDialogId() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getDialogId();
    }

    public Transaction getFirstTransaction() {
        this.verifyDialogExistency();
        return super.getFirstTransaction();
    }

    public Address getLocalParty() {
        if (this.wrappedDialog != null && !this.data.getForkHandler().isForking()) {
            return super.getLocalParty();
        }
        return this.data.getFromAddress();
    }

    public Address getRemoteParty() {
        if (this.wrappedDialog != null && !this.data.getForkHandler().isForking()) {
            return super.getRemoteParty();
        }
        return this.data.getToAddress();
    }

    public Address getRemoteTarget() {
        if (this.wrappedDialog != null && !this.data.getForkHandler().isForking()) {
            return super.getRemoteTarget();
        }
        return this.data.getToAddress();
    }

    public long getLocalSeqNumber() {
        if (this.data.getForkHandler().isForking() || this.wrappedDialog == null) {
            return this.data.getLocalSequenceNumber().get();
        }
        return super.getLocalSeqNumber();
    }

    public int getLocalSequenceNumber() {
        return (int)this.getLocalSeqNumber();
    }

    public long getRemoteSeqNumber() {
        if (this.wrappedDialog != null) {
            return super.getRemoteSeqNumber();
        }
        return 1L;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.getRemoteSeqNumber();
    }

    public String getRemoteTag() {
        if (this.wrappedDialog != null && !this.data.getForkHandler().isForking()) {
            return super.getRemoteTag();
        }
        return this.data.getLocalRemoteTag();
    }

    public DialogState getState() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getState();
    }

    public void incrementLocalSequenceNumber() {
        if (this.data.getForkHandler().isForking() || this.wrappedDialog == null) {
            this.data.getLocalSequenceNumber().incrementAndGet();
        } else {
            super.incrementLocalSequenceNumber();
        }
    }

    public boolean isSecure() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return super.isSecure();
    }

    public boolean isServer() {
        return false;
    }

    public void sendAck(Request arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendReliableProvisionalResponse(arg0);
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.verifyDialogExistency();
        super.terminateOnBye(arg0);
    }

    public boolean addOngoingTransaction(ServerTransactionWrapper stw) {
        AtomicLong cSeq;
        long cSeqNewValue;
        if (this.data.getForkHandler().isForking() && (cSeqNewValue = ((CSeqHeader)stw.getRequest().getHeader("CSeq")).getSeqNumber()) > (cSeq = this.data.getLocalSequenceNumber()).get()) {
            cSeq.set(cSeqNewValue);
        }
        return super.addOngoingTransaction(stw);
    }

    public String toString() {
        return "ClientDialogWrapper Id[" + this.getDialogId() + "] Handle[" + this.getActivityHandle() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.keySet() + "] OngoingSTX[" + this.ongoingServerTransactions.keySet() + "]";
    }

    public ClientTransaction sendCancel() throws SipException {
        this.verifyDialogExistency();
        return super.sendCancel();
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        this.verifyDialogExistency();
        super.associateServerTransaction(ct, st);
    }

    public Request createRequest(Request origRequest) throws SipException {
        Request request = super.createRequest(origRequest);
        if (this.wrappedDialog != null && this.data.getForkHandler().isForking()) {
            this.updateRequestWithForkData(request);
        }
        return request;
    }

    /*
     * Unable to fully structure code
     */
    public Request createRequest(String methodName) throws SipException {
        if (methodName.equals("ACK") || methodName.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + methodName);
        }
        provider = this.ra.getProviderWrapper();
        headerFactory = provider.getHeaderFactory();
        request = null;
        if (this.wrappedDialog == null) {
            try {
                requestURI = null;
                if (this.getRemoteTarget() != null) {
                    requestURI = (URI)this.getRemoteTarget().getURI().clone();
                } else {
                    requestURI = (URI)this.data.getToAddress().getURI().clone();
                    if (requestURI.isSipURI()) {
                        ((SipUri)requestURI).clearUriParms();
                    }
                }
                fromHeader = headerFactory.createFromHeader(this.data.getFromAddress(), this.getLocalTag());
                toHeader = headerFactory.createToHeader(this.data.getToAddress(), null);
                viaHeadersList = new ArrayList<ViaHeader>(1);
                viaHeadersList.add(provider.getLocalVia());
                maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
                cSeqHeader = headerFactory.createCSeqHeader(this.data.getLocalSequenceNumber().get() + 1L, methodName);
                request = provider.getMessageFactory().createRequest(requestURI, methodName, this.data.getCustomCallId(), cSeqHeader, fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
                routeList = this.data.getLocalRouteList();
                if (routeList == null) ** GOTO lbl34
                request.setHeader((Header)routeList);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        } else if (this.data.getForkHandler().isForking()) {
            request = this.wrappedDialog.createRequest(methodName);
            this.updateRequestWithForkData(request);
        } else {
            request = super.createRequest(methodName);
        }
lbl34:
        // 4 sources

        if (this.getState() == null) {
            this.ra.getProviderWrapper().addLoadBalancerToRoute(request);
        }
        return request;
    }

    private void updateRequestWithForkData(Request request) throws SipException {
        URI requestURI = (URI)this.data.getRequestURI().clone();
        request.setRequestURI(requestURI);
        RouteList routeList = this.data.getLocalRouteList();
        if (routeList != null) {
            request.setHeader((Header)routeList);
        }
        CSeqHeader cseq = (CSeqHeader)request.getHeader("CSeq");
        try {
            if (!request.getMethod().equals("CANCEL") && !request.getMethod().equals("ACK")) {
                cseq.setSeqNumber(this.data.getLocalSequenceNumber().get() + 1L);
            }
            request.setMethod(cseq.getMethod());
            if (this.data.getLocalRemoteTag() != null) {
                ((ToHeader)request.getHeader("To")).setTag(this.data.getLocalRemoteTag());
            }
        }
        catch (ParseException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        boolean createDialog;
        if (this.wrappedDialog == null && !Utils.getDialogCreatingMethods().contains(request.getMethod())) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
        }
        this.ensureCorrectDialogLocalTag(request);
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        ClientTransactionWrapper ctw = provider.getNewDialogActivityClientTransaction(this, request);
        String method = request.getMethod();
        if (method.equals("INVITE")) {
            this.lastCancelableTransactionId = ctw.activityHandle;
        }
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            this.wrappedDialog = provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
            if (this.ra.isValidateDialogCSeq()) {
                ((DialogExt)this.wrappedDialog).disableSequenceNumberValidation();
            }
            this.wrappedDialog.setApplicationData((Object)this);
        } else {
            this.ensureCorrectDialogRemoteTag(request);
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
        }
        if (this.data.getForkHandler().isForking()) {
            if (!method.equals("ACK") && !method.equals("CANCEL")) {
                this.data.getLocalSequenceNumber().incrementAndGet();
            }
            ctw.getWrappedClientTransaction().sendRequest();
        } else if (createDialog) {
            ctw.getWrappedClientTransaction().sendRequest();
        } else {
            this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        }
        return ctw;
    }

    private void ensureCorrectDialogRemoteTag(Request request) throws SipException {
        String remoteTag;
        String string = remoteTag = this.data.getForkHandler().isForking() && this.data.getLocalRemoteTag() != null ? this.data.getLocalRemoteTag() : this.wrappedDialog.getRemoteTag();
        if (remoteTag != null) {
            try {
                ((ToHeader)request.getHeader("To")).setTag(remoteTag);
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sendRequest(ClientTransaction ct) throws TransactionDoesNotExistException, SipException {
        boolean createDialog;
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        Request request = ct.getRequest();
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        this.ensureCorrectDialogLocalTag(request);
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            if (!Utils.getDialogCreatingMethods().contains(request.getMethod())) {
                throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
            }
            if (request.getMethod().equals("INVITE")) {
                this.lastCancelableTransactionId = ctw.getActivityHandle();
            }
            this.wrappedDialog = provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
            this.wrappedDialog.setApplicationData((Object)this);
            this.addOngoingTransaction(ctw);
            if (tracer.isInfoEnabled()) {
                tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
            }
            ctw.getWrappedClientTransaction().sendRequest();
        } else {
            this.ensureCorrectDialogRemoteTag(request);
            if (tracer.isInfoEnabled()) {
                tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
            }
            if (this.data.getForkHandler().isForking()) {
                if (!request.getMethod().equals("ACK") && !request.getMethod().equals("CANCEL")) {
                    this.data.getLocalSequenceNumber().incrementAndGet();
                }
                ctw.getWrappedClientTransaction().sendRequest();
            } else {
                this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
            }
        }
    }

    private void verifyDialogExistency() {
        if (this.wrappedDialog == null) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating request has been sent yet!");
        }
    }

    public boolean processIncomingResponse(ResponseEvent respEvent) {
        ClientDialogForkHandler forkHandler = this.data.getForkHandler();
        if (!forkHandler.isForking() || respEvent.getClientTransaction().getRequest().getMethod().equals("CANCEL")) {
            return false;
        }
        Response response = respEvent.getResponse();
        boolean eventFired = false;
        int statusCode = response.getStatusCode();
        String toTag = ((ToHeader)response.getHeader("To")).getTag();
        boolean fineTrace = tracer.isFineEnabled();
        if (statusCode < 200) {
            if (toTag != null) {
                if (this.data.getLocalRemoteTag() == null) {
                    if (fineTrace) {
                        tracer.fine("Client dialog " + this.getActivityHandle() + " received " + statusCode + " response with first remote tag " + toTag);
                    }
                    this.data.setLocalRemoteTag(toTag);
                    this.fetchData(response);
                } else if (this.data.getLocalRemoteTag().equals(toTag)) {
                    if (fineTrace) {
                        tracer.fine("Client dialog " + this.getActivityHandle() + " received " + statusCode + " response with first remote tag " + toTag + " again");
                    }
                    this.fetchData(response);
                } else {
                    DialogWithoutIdActivityHandle forkHandle = forkHandler.getFork(toTag);
                    if (forkHandle == null) {
                        if (fineTrace) {
                            tracer.fine("Client dialog " + this.getActivityHandle() + " received " + statusCode + " response with new fork remote tag " + toTag);
                        }
                        ClientDialogWrapper forkDialog = this.getNewDialogFork(toTag, fineTrace);
                        forkDialog.fetchData(response);
                        forkHandler.addFork(this.ra, (DialogWithoutIdActivityHandle)forkDialog.getActivityHandle());
                        this.fireDialogForkEvent(respEvent, forkDialog, fineTrace);
                        eventFired = true;
                    } else {
                        ClientDialogWrapper forkDialog;
                        if (fineTrace) {
                            tracer.fine("Client dialog " + this.getActivityHandle() + " received " + statusCode + " response with existent fork remote tag " + toTag);
                        }
                        if ((forkDialog = (ClientDialogWrapper)this.ra.getActivity(forkHandle)) == null) {
                            if (tracer.isSevereEnabled()) {
                                tracer.severe("Can't find dialog " + this.activityHandle + " fork with remote tag " + toTag + " in RA's activity management");
                            }
                            return true;
                        }
                        forkDialog.fetchData(response);
                        this.fireReceivedEvent(respEvent, forkDialog, fineTrace);
                        eventFired = true;
                    }
                }
            }
        } else if (statusCode < 300) {
            if (toTag != null) {
                if (this.data.getLocalRemoteTag() == null) {
                    if (fineTrace) {
                        tracer.fine("Client dialog " + this.getActivityHandle() + " confirmed with remote tag " + toTag);
                    }
                    this.data.setLocalRemoteTag(toTag);
                    if (!this.ra.inLocalMode()) {
                        ((ClusteredSipActivityManagement)this.ra.getActivityManagement()).replicateRemoteTag((DialogWithoutIdActivityHandle)this.getActivityHandle(), toTag);
                    }
                    this.fetchData(response);
                    forkHandler.terminate(this.ra);
                } else if (this.data.getLocalRemoteTag().equals(toTag)) {
                    if (fineTrace) {
                        tracer.fine("Client dialog " + this.getActivityHandle() + " confirmed with remote tag " + toTag);
                    }
                    if (!this.ra.inLocalMode()) {
                        ((ClusteredSipActivityManagement)this.ra.getActivityManagement()).replicateRemoteTag((DialogWithoutIdActivityHandle)this.getActivityHandle(), toTag);
                    }
                    this.fetchData(response);
                    forkHandler.terminate(this.ra);
                } else {
                    DialogWithoutIdActivityHandle forkHandle = forkHandler.getFork(toTag);
                    if (forkHandle == null) {
                        if (fineTrace) {
                            tracer.fine("Client dialog " + this.getActivityHandle() + " confirmed with new fork remote tag " + toTag);
                        }
                        ClientDialogWrapper forkDialog = this.getNewDialogFork(toTag, fineTrace);
                        forkDialog.fetchData(response);
                        forkHandler.forkConfirmed(this.ra, this, forkDialog);
                        this.fireDialogForkEvent(respEvent, forkDialog, fineTrace);
                        eventFired = true;
                    } else {
                        ClientDialogWrapper forkDialog;
                        if (fineTrace) {
                            tracer.fine("Client dialog " + this.getActivityHandle() + " confirmed with existent fork remote tag " + toTag);
                        }
                        if ((forkDialog = (ClientDialogWrapper)this.ra.getActivityManagement().get(forkHandle)) == null) {
                            if (tracer.isSevereEnabled()) {
                                tracer.severe("Can't find dialog " + this.activityHandle + " fork with remote tag " + toTag + " in RA's activity management");
                            }
                            return true;
                        }
                        forkHandler.forkConfirmed(this.ra, this, forkDialog);
                        forkDialog.fetchData(response);
                        this.fireReceivedEvent(respEvent, forkDialog, fineTrace);
                        eventFired = true;
                    }
                }
                this.wrappedDialog.setApplicationData((Object)this);
            }
        } else {
            if (fineTrace) {
                tracer.fine("Client dialog " + this.getActivityHandle() + " received " + statusCode + " error response, terminating fork");
            }
            this.fireReceivedEvent(respEvent, this, fineTrace);
            eventFired = true;
            this.data.getForkHandler().terminate(this.ra);
        }
        return eventFired;
    }

    private void fireReceivedEvent(ResponseEvent respEvent, ClientDialogWrapper dw, boolean fineTrace) {
        FireableEventType eventType = this.ra.getEventIdCache().getEventId(this.ra.getEventLookupFacility(), respEvent.getResponse());
        ResponseEventWrapper eventObject = new ResponseEventWrapper(this.ra.getProviderWrapper(), (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, respEvent.getResponse());
        this.fireEvent(fineTrace, (Object)eventObject, dw.activityHandle, dw.getEventFiringAddress(), eventType);
    }

    private void fireDialogForkEvent(ResponseEvent respEvent, ClientDialogWrapper fork, boolean fineTrace) {
        FireableEventType eventID = this.ra.getEventIdCache().getDialogForkEventId(this.ra.getEventLookupFacility());
        DialogForkedEvent eventObject = new DialogForkedEvent((Object)this.ra.getProviderWrapper(), respEvent.getClientTransaction(), (Dialog)this, (Dialog)fork, respEvent.getResponse());
        this.fireEvent(fineTrace, eventObject, this.activityHandle, this.getEventFiringAddress(), eventID);
    }

    private void fireEvent(boolean fineTrace, Object event, SipActivityHandle activityHandle, javax.slee.Address eventFiringAddress, FireableEventType eventType) {
        if (this.ra.getEventIDFilter().filterEvent(eventType)) {
            if (fineTrace) {
                tracer.fine("Event " + (eventType == null ? "null" : eventType.getEventType()) + " filtered.");
            }
            return;
        }
        try {
            this.ra.getSleeEndpoint().fireEvent((ActivityHandle)activityHandle, eventType, event, eventFiringAddress, null, 64);
        }
        catch (Throwable e) {
            tracer.severe("Failed to fire event", e);
        }
    }

    private ClientDialogWrapper getNewDialogFork(String forkRemoteTag, boolean fineTrace) {
        DialogWithoutIdActivityHandle originalHandle = (DialogWithoutIdActivityHandle)this.activityHandle;
        DialogWithoutIdActivityHandle forkHandle = new DialogWithoutIdActivityHandle(originalHandle.getCallId(), originalHandle.getLocalTag(), forkRemoteTag);
        ClientDialogWrapper dw = new ClientDialogWrapper(forkHandle, this);
        dw.data.setLocalRemoteTag(forkRemoteTag);
        this.data.getForkHandler().addFork(this.ra, forkHandle);
        this.ra.addActivity(dw, false, fineTrace);
        return dw;
    }

    private void fetchData(Response response) {
        RouteHeader topRoute;
        URI topRouteURI;
        SIPResponse sipResponse;
        RouteList routeList;
        this.data.setLocalRemoteTag(((ToHeader)response.getHeader("To")).getTag());
        ContactHeader contact = (ContactHeader)response.getHeader("Contact");
        if (contact != null && this.data.getRequestURI() == null) {
            this.data.setRequestURI(contact.getAddress().getURI());
        }
        if ((routeList = (sipResponse = (SIPResponse)response).getRouteHeaders()) != null && (topRouteURI = (topRoute = (RouteHeader)routeList.get(0)).getAddress().getURI()).isSipURI()) {
            SipURI topRouteSipURI = (SipURI)topRouteURI;
            String transport = ((ViaHeader)sipResponse.getHeader("Via")).getTransport();
            ListeningPointImpl lp = (ListeningPointImpl)this.ra.getProviderWrapper().getListeningPoint(transport);
            if (topRouteSipURI.getHost().equals(lp.getIPAddress()) && topRouteSipURI.getPort() == lp.getPort()) {
                if (routeList.size() > 1) {
                    routeList = (RouteList)routeList.clone();
                    routeList.remove(0);
                    this.data.setLocalRouteList(routeList);
                }
            } else {
                this.data.setLocalRouteList((RouteList)routeList.clone());
            }
        }
        this.data.setCustomCallId((CallIdHeader)response.getHeader("Call-ID"));
    }

    public void clear() {
        ClientDialogForkHandler forkHandler = this.data.getForkHandler();
        if (forkHandler.getMaster() != null) {
            if (this.wrappedDialog != null) {
                if (tracer.isFineEnabled()) {
                    tracer.fine("Confirmed fork dialog " + this.getActivityHandle() + " ended, removing its master dialog");
                }
                this.ra.getActivityManagement().remove(forkHandler.getMaster());
            }
        } else if (forkHandler.getForkWinner() != null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Restoring dialog " + this.getActivityHandle() + " to the RA's activity management o handle possible late 2xx responses, a fork was confirmed.");
            }
            this.ra.getActivityManagement().put(this.getActivityHandle(), this);
        }
        super.clear();
        this.data = null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.activityHandle.setActivity(this);
    }
}

