/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.SLEEException;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import org.mobicents.protocols.smpp.BadCommandIDException;
import org.mobicents.protocols.smpp.NotBoundException;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.event.ReceiverExceptionEvent;
import org.mobicents.protocols.smpp.event.ReceiverExitEvent;
import org.mobicents.protocols.smpp.event.SMPPEvent;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.message.AlertNotification;
import org.mobicents.protocols.smpp.message.Bind;
import org.mobicents.protocols.smpp.message.BindReceiver;
import org.mobicents.protocols.smpp.message.BindTransceiver;
import org.mobicents.protocols.smpp.message.BindTransmitter;
import org.mobicents.protocols.smpp.message.BroadcastSM;
import org.mobicents.protocols.smpp.message.BroadcastSMResp;
import org.mobicents.protocols.smpp.message.CancelBroadcastSM;
import org.mobicents.protocols.smpp.message.CancelBroadcastSMResp;
import org.mobicents.protocols.smpp.message.CancelSM;
import org.mobicents.protocols.smpp.message.CancelSMResp;
import org.mobicents.protocols.smpp.message.DataSM;
import org.mobicents.protocols.smpp.message.DataSMResp;
import org.mobicents.protocols.smpp.message.DeliverSM;
import org.mobicents.protocols.smpp.message.DeliverSMResp;
import org.mobicents.protocols.smpp.message.EnquireLink;
import org.mobicents.protocols.smpp.message.GenericNack;
import org.mobicents.protocols.smpp.message.QueryBroadcastSM;
import org.mobicents.protocols.smpp.message.QueryBroadcastSMResp;
import org.mobicents.protocols.smpp.message.QuerySM;
import org.mobicents.protocols.smpp.message.QuerySMResp;
import org.mobicents.protocols.smpp.message.ReplaceSM;
import org.mobicents.protocols.smpp.message.ReplaceSMResp;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.SubmitMulti;
import org.mobicents.protocols.smpp.message.SubmitMultiResp;
import org.mobicents.protocols.smpp.message.SubmitSM;
import org.mobicents.protocols.smpp.message.SubmitSMResp;
import org.mobicents.protocols.smpp.util.SequenceNumberScheme;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionException;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.MemberAddress;
import org.mobicents.slee.resources.smpp.BindType;
import org.mobicents.slee.resources.smpp.ExtSmppRequest;
import org.mobicents.slee.resources.smpp.ExtSmppResponse;
import org.mobicents.slee.resources.smpp.FireableEventTypeCache;
import org.mobicents.slee.resources.smpp.FireableEventTypeFilter;
import org.mobicents.slee.resources.smpp.SmppSessionImpl;
import org.mobicents.slee.resources.smpp.SmppTransactionHandle;
import org.mobicents.slee.resources.smpp.SmppTransactionImpl;
import org.mobicents.slee.resources.smpp.SmppTransactionType;
import org.mobicents.slee.resources.smpp.Utils;
import org.mobicents.slee.resources.smpp.pdu.AlertNotificationImpl;
import org.mobicents.slee.resources.smpp.pdu.BroadcastSMImpl;
import org.mobicents.slee.resources.smpp.pdu.BroadcastSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelBroadcastSMImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelBroadcastSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelSMImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.DataSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DataSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.DeliverSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DeliverSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.GenericNackImpl;
import org.mobicents.slee.resources.smpp.pdu.QueryBroadcastSMImpl;
import org.mobicents.slee.resources.smpp.pdu.QueryBroadcastSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.QuerySMImpl;
import org.mobicents.slee.resources.smpp.pdu.QuerySMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.ReplaceSMImpl;
import org.mobicents.slee.resources.smpp.pdu.ReplaceSMRespImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitMultiImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitMultiRespImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitSMImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitSMRespImpl;

public class SmppResourceAdaptor
implements FaultTolerantResourceAdaptor,
SessionObserver {
    private transient Tracer tracer;
    private transient ResourceAdaptorContext raContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient SmppSessionImpl smppSession = null;
    private transient FireableEventTypeCache eventTypeCache;
    private transient FireableEventTypeFilter eventTypeFilter;
    private transient FaultTolerantResourceAdaptorContext ftRAContext;
    private Utils utils;
    private Thread linkMonitorThread;
    public String smscAlarm;
    private String host = "localhost";
    private int port = 2727;
    private String systemID = "1";
    private String systemType = "ESME";
    private String password = "1";
    private int addressTON = 0;
    private int addressNPI = 1;
    private String addressRange = "50";
    private int enquireLinkTimeout = 30000;
    private String bindType = BindType.TRANSMITTER.toString();
    private int smppResponseReceivedTimeout = 5000;
    private int smppResponseSentTimeout = 5000;
    protected Session protoSmppSession = null;
    protected SequenceNumberScheme seq = null;
    private Semaphore semaphore = new Semaphore(0);
    private int bindStatus;
    private volatile boolean isBound = false;
    private volatile boolean isClosed = false;
    private Bind bind = null;
    private ConcurrentHashMap<SmppTransactionHandle, SmppTransactionImpl> handleVsActivityMap = new ConcurrentHashMap();

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public String getSystemId() {
        return this.systemID;
    }

    public void setSystemId(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getAddressTon() {
        return this.addressTON;
    }

    public void setAddressTon(Integer addressTON) {
        this.addressTON = addressTON;
    }

    public Integer getAddressNpi() {
        return new Integer(this.addressNPI);
    }

    public void setAddressNpi(Integer addressNPI) {
        this.addressNPI = addressNPI;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public Integer getEnquireLinkTimeout() {
        return this.enquireLinkTimeout;
    }

    public void setEnquireLinkTimeout(Integer enquireLinkTimeout) {
        this.enquireLinkTimeout = enquireLinkTimeout * 1000;
    }

    public String getBindType() {
        return this.bindType;
    }

    public void setBindType(String bindTypeArg) {
        this.bindType = bindTypeArg;
    }

    public int getSmppResponseReceivedTimeout() {
        return this.smppResponseReceivedTimeout;
    }

    public void setSmppResponseReceivedTimeout(int smppResponseReceivedTimeout) {
        if (smppResponseReceivedTimeout < 100) {
            smppResponseReceivedTimeout = 5000;
        }
        this.smppResponseReceivedTimeout = smppResponseReceivedTimeout;
    }

    public int getSmppResponseSentTimeout() {
        return this.smppResponseSentTimeout;
    }

    public void setSmppResponseSentTimeout(int smppResponseSentTimeout) {
        if (smppResponseSentTimeout < 100) {
            smppResponseSentTimeout = 5000;
        }
        this.smppResponseSentTimeout = smppResponseSentTimeout;
    }

    public void dataRemoved(Serializable arg0) {
    }

    public void failOver(Serializable arg0) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Failed over the SMPP. Available memebers now ");
            for (MemberAddress memAdd : this.ftRAContext.getMembers()) {
                this.tracer.info(memAdd.toString());
            }
        }
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext arg0) {
        this.tracer.info("setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext arg0)");
        this.ftRAContext = arg0;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.tracer.info("unsetFaultTolerantResourceAdaptorContext()");
        this.ftRAContext = null;
    }

    public void activityEnded(ActivityHandle activityHandle) {
        this.handleVsActivityMap.remove(activityHandle);
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.handleVsActivityMap.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object obj) {
        Enumeration<SmppTransactionHandle> e = this.handleVsActivityMap.keys();
        while (e.hasMoreElements()) {
            SmppTransactionHandle txHandle = e.nextElement();
            SmppTransactionImpl txImpl = this.handleVsActivityMap.get(txHandle);
            if (!txImpl.equals(obj)) continue;
            return txHandle;
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.smppSession;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        SmppTransactionImpl txImpl = (SmppTransactionImpl)this.smppSession.transactions.get(((SmppTransactionHandle)activityHandle).getSeqNumber());
        if (txImpl == null) {
            this.tracer.warning("The queryLiveness failed for activity " + activityHandle + " Ending this activity");
            this.sleeEndpoint.endActivity(activityHandle);
        }
    }

    public void raActive() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Activation RA " + this.raContext.getEntityName());
        }
        try {
            this.bindSMSC();
        }
        catch (IOException e) {
            this.tracer.severe("Binding to SMSC Failed ", (Throwable)e);
        }
        this.linkMonitorThread = new Thread(new LinkMonitor());
        this.linkMonitorThread.start();
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        this.raConfigure(properties);
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA Entity " + this.raContext.getEntityName());
        }
        this.setAddressNpi((Integer)properties.getProperty("addressNpi").getValue());
        this.setAddressRange((String)properties.getProperty("addressRange").getValue());
        this.setAddressTon((Integer)properties.getProperty("addressTon").getValue());
        this.setEnquireLinkTimeout((Integer)properties.getProperty("enquireLinkTimeout").getValue());
        this.setHost((String)properties.getProperty("host").getValue());
        this.setPassword((String)properties.getProperty("password").getValue());
        this.setPort((Integer)properties.getProperty("port").getValue());
        this.setSystemId((String)properties.getProperty("systemId").getValue());
        this.setSystemType((String)properties.getProperty("systemType").getValue());
        this.setBindType((String)properties.getProperty("bindType").getValue());
        this.setSmppResponseReceivedTimeout((Integer)properties.getProperty("smppResponseReceivedTimeout").getValue());
        this.setSmppResponseSentTimeout((Integer)properties.getProperty("smppResponseSentTimeout").getValue());
        if (this.tracer.isFineEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("addressNpi = ").append(this.getAddressNpi()).append("\n").append("addressTon = ").append(this.getAddressTon()).append("\n").append("addressRange = ").append(this.getAddressRange()).append("\n").append("host = ").append(this.getHost()).append("\n").append("port = ").append(this.getPort()).append("\n").append("systemId = ").append(this.getSystemId()).append("\n").append("systemType = ").append(this.getSystemType()).append("\n").append("password = ").append(this.getPassword()).append("\n").append("bindType = ").append(this.getBindType()).append("\n");
            this.tracer.fine(sb.toString());
        }
    }

    public void raInactive() {
        this.unbindSMSC();
    }

    public void raStopping() {
        this.isBound = false;
        this.isClosed = true;
        this.smppSession.setIsAlive(false);
        if (this.linkMonitorThread != null) {
            this.linkMonitorThread.interrupt();
        }
    }

    public void raUnconfigure() {
        this.setAddressNpi(-1);
        this.setAddressRange(null);
        this.setAddressTon(-1);
        this.setEnquireLinkTimeout(-1);
        this.setHost(null);
        this.setPassword(null);
        this.setPort(-1);
        this.setSystemId(null);
        this.setSystemType(null);
        this.setBindType(null);
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        String addressRange = null;
        String host = null;
        String password = null;
        String systemId = null;
        String systemType = null;
        BindType binidType = null;
        try {
            Integer npi = (Integer)properties.getProperty("addressNpi").getValue();
            Integer ton = (Integer)properties.getProperty("addressTon").getValue();
            Integer enquireTimeOut = (Integer)properties.getProperty("enquireLinkTimeout").getValue();
            Integer port = (Integer)properties.getProperty("port").getValue();
            addressRange = (String)properties.getProperty("addressRange").getValue();
            host = (String)properties.getProperty("host").getValue();
            password = (String)properties.getProperty("password").getValue();
            systemId = (String)properties.getProperty("systemId").getValue();
            systemType = (String)properties.getProperty("systemType").getValue();
            binidType = BindType.getBindType((String)properties.getProperty("bindType").getValue());
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        if (addressRange == null) {
            throw new InvalidConfigurationException("Address Range cannot be null");
        }
        if (host == null) {
            throw new InvalidConfigurationException("Host (of SMSC) cannot be null");
        }
        if (password == null) {
            throw new InvalidConfigurationException("Password cannot be null");
        }
        if (systemId == null) {
            throw new InvalidConfigurationException("System ID cannot be null");
        }
        if (systemType == null) {
            throw new InvalidConfigurationException("System Type cannot be null");
        }
        if (binidType == null) {
            throw new InvalidConfigurationException("Bind Type cannot be null");
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventTypeFilter.serviceActive(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventTypeFilter.serviceInactive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventTypeFilter.serviceStopping(receivableService);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(this.getClass().getSimpleName());
        this.tracer.info("setResourceAdaptorContext(ResourceAdaptorContext raContext)");
        this.raContext = raContext;
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventLookup = raContext.getEventLookupFacility();
        this.smppSession = new SmppSessionImpl(this);
        this.eventTypeCache = new FireableEventTypeCache(this.tracer);
        this.eventTypeFilter = new FireableEventTypeFilter();
        this.utils = new Utils(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventTypeCache = null;
        this.eventTypeFilter = null;
    }

    public void packetReceived(Session source, SMPPPacket packet) {
        String entityName = this.raContext.getEntityName();
        switch (packet.getCommandId()) {
            case -2147483639: {
                this.bindStatus = packet.getCommandStatus();
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine(entityName + " receive bind_transaceiver_resp. Statu = " + this.bindStatus + " Message = " + this.utils.statusMessage(this.bindStatus));
                }
                this.semaphore.release();
                break;
            }
            case -2147483647: {
                this.bindStatus = packet.getCommandStatus();
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine(entityName + " receive bind_receiver_resp. Statu = " + this.bindStatus + " Message = " + this.utils.statusMessage(this.bindStatus));
                }
                this.semaphore.release();
                break;
            }
            case -2147483646: {
                this.bindStatus = packet.getCommandStatus();
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine(entityName + " receive bind_transmitter_resp. Statu = " + this.bindStatus + " Message = " + this.utils.statusMessage(this.bindStatus));
                }
                this.semaphore.release();
                break;
            }
            case -2147483642: {
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine(this.raContext.getEntityName() + " unbound successfuly");
                }
                this.semaphore.release();
                break;
            }
            case 21: {
                if (!this.tracer.isFineEnabled()) break;
                this.tracer.fine("Enquire link packet received");
                break;
            }
            case -2147483627: {
                if (!this.tracer.isFineEnabled()) break;
                this.tracer.fine("Enquire link response packet received");
                break;
            }
            case 5: {
                DeliverSMImpl deliverSMImpl = new DeliverSMImpl((DeliverSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(deliverSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                if (SmppResourceAdaptor.isEsmClassUserMessage(deliverSMImpl.getEsmClass())) {
                    this.fireEvent("net.java.slee.resources.smpp.DELIVER_SM", txImpl, deliverSMImpl);
                    break;
                }
                this.fireEvent("net.java.slee.resources.smpp.DELIVERY_REPORT", txImpl, deliverSMImpl);
                break;
            }
            case -2147483643: {
                DeliverSMRespImpl deliverSMRespImpl = new DeliverSMRespImpl((DeliverSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(deliverSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.DELIVER_SM_RESP", txImpl, deliverSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 259: {
                DataSMImpl dataSMImpl = new DataSMImpl((DataSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(dataSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.DATA_SM", txImpl, dataSMImpl);
                break;
            }
            case -2147483389: {
                DataSMRespImpl dataSMRespImpl = new DataSMRespImpl((DataSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(dataSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.DATA_SM_RESP", txImpl, dataSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 4: {
                SubmitSMImpl submitSMImpl = new SubmitSMImpl((SubmitSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(submitSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.SUBMIT_SM", txImpl, submitSMImpl);
                break;
            }
            case -2147483644: {
                SubmitSMRespImpl submitSMRespImpl = new SubmitSMRespImpl((SubmitSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(submitSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.SUBMIT_SM_RESP", txImpl, submitSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 33: {
                SubmitMultiImpl submitMultiImpl = new SubmitMultiImpl((SubmitMulti)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(submitMultiImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.SUBMIT_MULTI", txImpl, submitMultiImpl);
                break;
            }
            case -2147483615: {
                SubmitMultiRespImpl submitMultiRespImpl = new SubmitMultiRespImpl((SubmitMultiResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(submitMultiRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.SUBMIT_MULTI_RESP", txImpl, submitMultiRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 3: {
                QuerySMImpl querySMImpl = new QuerySMImpl((QuerySM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(querySMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.QUERY_SM", txImpl, querySMImpl);
                break;
            }
            case -2147483645: {
                QuerySMRespImpl querySMRespImpl = new QuerySMRespImpl((QuerySMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(querySMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.QUERY_SM_RESP", txImpl, querySMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 7: {
                ReplaceSMImpl replaceSMImpl = new ReplaceSMImpl((ReplaceSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(replaceSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.REPLACE_SM", txImpl, replaceSMImpl);
                break;
            }
            case -2147483641: {
                ReplaceSMRespImpl replaceSMRespImpl = new ReplaceSMRespImpl((ReplaceSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(replaceSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.REPLACE_SM_RESP", txImpl, replaceSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 8: {
                CancelSMImpl cancelSMImpl = new CancelSMImpl((CancelSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(cancelSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.CANCEL_SM", txImpl, cancelSMImpl);
                break;
            }
            case -2147483640: {
                CancelSMRespImpl cancelSMRespImpl = new CancelSMRespImpl((CancelSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(cancelSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.CANCEL_SM_RESP", txImpl, cancelSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 273: {
                BroadcastSMImpl broadcastSMImpl = new BroadcastSMImpl((BroadcastSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(broadcastSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.BROADCAST_SM", txImpl, broadcastSMImpl);
                break;
            }
            case -2147483375: {
                BroadcastSMRespImpl broadcastSMRespImpl = new BroadcastSMRespImpl((BroadcastSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(broadcastSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.BROADCAST_SM_RESP", txImpl, broadcastSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 275: {
                CancelBroadcastSMImpl cancelBroadcastSMImpl = new CancelBroadcastSMImpl((CancelBroadcastSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(cancelBroadcastSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.CANCEL_BROADCAST_SM", txImpl, cancelBroadcastSMImpl);
                break;
            }
            case -2147483373: {
                CancelBroadcastSMRespImpl cancelBroadcastSMRespImpl = new CancelBroadcastSMRespImpl((CancelBroadcastSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(cancelBroadcastSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.CANCEL_BROADCAST_SM_RESP", txImpl, cancelBroadcastSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 274: {
                QueryBroadcastSMImpl queryBroadcastSMImpl = new QueryBroadcastSMImpl((QueryBroadcastSM)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(queryBroadcastSMImpl, true, SmppTransactionType.INCOMING);
                if (txImpl == null) break;
                this.fireEvent("net.java.slee.resources.smpp.QUERY_BROADCAST_SM", txImpl, queryBroadcastSMImpl);
                break;
            }
            case -2147483374: {
                QueryBroadcastSMRespImpl queryBroadcastSMRespImpl = new QueryBroadcastSMRespImpl((QueryBroadcastSMResp)packet);
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(queryBroadcastSMRespImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.QUERY_BROADCAST_SM_RESP", txImpl, queryBroadcastSMRespImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case -2147483648: {
                GenericNackImpl genericNackImpl = new GenericNackImpl((GenericNack)packet);
                if (genericNackImpl.getCommandStatus() == 0) {
                    if (!this.tracer.isFineEnabled()) break;
                    this.tracer.fine("Receievd GENERIC_NACK acknowledgemet " + genericNackImpl);
                    break;
                }
                try {
                    SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(genericNackImpl, false, null);
                    txImpl.cancelResponseNotReceivedTimeout();
                    this.fireEvent("net.java.slee.resources.smpp.GENERIC_NACK", txImpl, genericNackImpl);
                    this.endActivity(txImpl);
                }
                catch (Exception e) {
                    this.tracer.warning("Activity not found for received SMPP Response " + packet, (Throwable)e);
                }
                break;
            }
            case 258: {
                AlertNotificationImpl alertNotiImpl = new AlertNotificationImpl((AlertNotification)packet);
                SmppTransactionImpl txImpl = this.smppSession.getSmppTransactionImpl(alertNotiImpl, true, SmppTransactionType.INCOMING);
                if (txImpl != null) {
                    this.fireEvent("net.java.slee.resources.smpp.ALERT_NOTIFICATION", txImpl, alertNotiImpl);
                }
                this.endActivity(txImpl);
                break;
            }
            default: {
                this.tracer.warning("Unexpected packet received! Id = 0x" + Integer.toHexString(packet.getCommandId()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Session source, SMPPEvent smppEvent) {
        block13: {
            block0 : switch (smppEvent.getType()) {
                case 2: {
                    if (!this.tracer.isFineEnabled()) return;
                    this.tracer.fine("Receiver Thread started for SMPP RA " + this.raContext.getEntityName());
                    return;
                }
                case 4: {
                    if (this.tracer.isFineEnabled()) {
                        ReceiverExceptionEvent recExcepEvent = (ReceiverExceptionEvent)smppEvent;
                        this.tracer.fine("The Receiver Thread for SMPP RA " + this.raContext.getEntityName() + " throws recovrable Exception ", recExcepEvent.getException());
                    }
                    this.reconnect();
                    return;
                }
                case 3: {
                    ReceiverExitEvent recExitEvent = (ReceiverExitEvent)smppEvent;
                    switch (recExitEvent.getReason()) {
                        case 2: {
                            this.tracer.severe("The Receiver Thread for SMPP RA " + this.raContext.getEntityName() + " exited with error ", recExitEvent.getException());
                            this.reconnect();
                            break block0;
                        }
                        case 1: {
                            if (!this.tracer.isFineEnabled()) return;
                            this.tracer.fine("The Receiver Thread for SMPP RA " + this.raContext.getEntityName() + " exited with BIND_TIMEOUT");
                            break block13;
                        }
                        case 0: {
                            if (!this.tracer.isFineEnabled()) return;
                            this.tracer.fine("The Receiver Thread for SMPP RA " + this.raContext.getEntityName() + " exited normally");
                        }
                    }
                }
            }
        }
    }

    private void bindSMSC() throws UnknownHostException, IOException {
        AlarmFacility alarmFacility;
        this.protoSmppSession = new Session(this.host, this.port);
        this.seq = this.protoSmppSession.getSequenceNumberScheme();
        this.protoSmppSession.addObserver((SessionObserver)this);
        this.protoSmppSession.setVersion(SMPPVersion.VERSION_5_0);
        IOException ioException = null;
        try {
            this.createBind();
            this.protoSmppSession.bind(this.bind);
            this.semaphore.drainPermits();
            this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.tracer.severe("Binding to SMS failed", (Throwable)e);
            this.bindStatus = -1;
        }
        catch (IOException e) {
            this.bindStatus = -1;
            ioException = e;
        }
        if (this.bindStatus != 0) {
            alarmFacility = this.raContext.getAlarmFacility();
            this.smscAlarm = alarmFacility.raiseAlarm(this.raContext.getEntityName(), "SMSCALARM", AlarmLevel.CRITICAL, "SMSCALARM: bind status " + this.utils.statusMessage(this.bindStatus));
            if (ioException != null) {
                throw ioException;
            }
            throw new IOException("Could not bind to SMSC. The reason is " + this.utils.statusMessage(this.bindStatus));
        }
        this.tracer.info("Successfully bound to SMSC. ");
        this.isBound = true;
        this.smppSession.setIsAlive(true);
        if (this.smscAlarm != null) {
            alarmFacility = this.raContext.getAlarmFacility();
            alarmFacility.clearAlarm(this.smscAlarm);
        }
    }

    private Bind createBind() {
        BindType bindType = BindType.getBindType(this.getBindType());
        switch (bindType) {
            case TRANSMITTER: {
                this.bind = new BindTransmitter();
                break;
            }
            case RECEIVER: {
                this.bind = new BindReceiver();
                break;
            }
            case TRANSCEIVER: {
                this.bind = new BindTransceiver();
            }
        }
        this.bind.setAddressTon(this.getAddressTon());
        this.bind.setAddressNpi(this.getAddressNpi().intValue());
        this.bind.setAddressRange(this.getAddressRange());
        this.bind.setSystemType(this.getSystemType());
        this.bind.setSystemId(this.getSystemId());
        this.bind.setPassword(this.getPassword());
        return this.bind;
    }

    private void reconnect() {
        block2: {
            try {
                this.unbindSMSC();
                this.protoSmppSession.closeLink();
                this.bindSMSC();
            }
            catch (Exception e) {
                if (!this.tracer.isSevereEnabled()) break block2;
                this.tracer.severe("Reconnect error: " + e.getMessage());
            }
        }
    }

    private void unbindSMSC() {
        block3: {
            this.isBound = false;
            this.smppSession.setIsAlive(false);
            try {
                this.protoSmppSession.unbind();
                this.semaphore.drainPermits();
                this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info(this.raContext.getEntityName() + ": unbinding from SMSC");
                }
            }
            catch (Exception e) {
                if (!this.tracer.isSevereEnabled()) break block3;
                this.tracer.severe("There was an error unbinding. ", (Throwable)e);
            }
        }
    }

    private static boolean isEsmClassUserMessage(int esmClassArg) {
        return (esmClassArg & 0x3C) == 0;
    }

    protected void startNewSmppTransactionActivity(SmppTransactionImpl txImpl) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        SmppTransactionHandle handle = new SmppTransactionHandle(txImpl.getId(), txImpl.hashCode());
        this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)txImpl, 2);
        this.handleVsActivityMap.put(handle, txImpl);
    }

    protected void startNewSmppTransactionSuspendedActivity(SmppTransactionImpl txImpl) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        SmppTransactionHandle handle = new SmppTransactionHandle(txImpl.getId(), txImpl.hashCode());
        this.sleeEndpoint.startActivitySuspended((ActivityHandle)handle, (Object)txImpl, 2);
        this.handleVsActivityMap.put(handle, txImpl);
    }

    protected void sendResponse(ExtSmppResponse response) throws IOException {
        this.protoSmppSession.sendPacket(response.getSMPPPacket());
    }

    protected void sendRequest(ExtSmppRequest request) throws IOException {
        this.protoSmppSession.sendPacket(request.getSMPPPacket());
    }

    protected void fireEvent(String eventName, SmppTransactionImpl activity, Object event) {
        ActivityHandle handle = this.getActivityHandle(activity);
        if (handle == null) {
            this.tracer.warning("Firing event " + eventName + " for null ActivityHandle Activity=" + activity);
            return;
        }
        FireableEventType eventType = this.eventTypeCache.getEventType(this.eventLookup, eventName);
        if (this.eventTypeFilter.filterEvent(eventType)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("event " + eventName + " filtered");
            }
            return;
        }
        String addressStr = this.utils.getAddressForEventFire(activity.getSmppRequest());
        Address address = new Address(AddressPlan.E164_MOBILE, addressStr);
        try {
            this.sleeEndpoint.fireEvent(handle, eventType, event, address, null);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Fired event: " + eventName);
            }
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to fire event", e);
        }
    }

    protected void endActivity(SmppTransactionImpl activity) {
        try {
            ActivityHandle actHandle = this.getActivityHandle(activity);
            if (actHandle != null) {
                this.sleeEndpoint.endActivity(actHandle);
            } else {
                this.tracer.warning("No ActivityHanlde forund for Activity " + activity);
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error while Ending Activity " + activity, (Throwable)e);
        }
    }

    protected ResourceAdaptorContext getRAContext() {
        return this.raContext;
    }

    private class LinkMonitor
    implements Runnable {
        private LinkMonitor() {
        }

        public void run() {
            if (SmppResourceAdaptor.this.tracer.isFineEnabled()) {
                SmppResourceAdaptor.this.tracer.fine("In LinkMonitor, isBound = " + SmppResourceAdaptor.this.isBound);
            }
            while (!SmppResourceAdaptor.this.isClosed) {
                block11: {
                    try {
                        Thread.currentThread();
                        Thread.sleep(SmppResourceAdaptor.this.enquireLinkTimeout);
                    }
                    catch (InterruptedException e) {
                        if (!SmppResourceAdaptor.this.tracer.isInfoEnabled()) break block11;
                        SmppResourceAdaptor.this.tracer.info("Terminate link monitor: " + SmppResourceAdaptor.this.raContext.getEntityName());
                    }
                }
                try {
                    EnquireLink sm = new EnquireLink();
                    SmppResourceAdaptor.this.protoSmppSession.sendPacket((SMPPPacket)sm);
                    if (!SmppResourceAdaptor.this.tracer.isFineEnabled()) continue;
                    SmppResourceAdaptor.this.tracer.fine("Sent enquire link for " + SmppResourceAdaptor.this.raContext.getEntityName());
                }
                catch (NotBoundException nbe) {
                    if (SmppResourceAdaptor.this.tracer.isWarningEnabled()) {
                        SmppResourceAdaptor.this.tracer.warning("Connection lost! for RA " + SmppResourceAdaptor.this.raContext.getEntityName() + "Reconnecting...");
                    }
                    SmppResourceAdaptor.this.reconnect();
                }
                catch (IOException ie) {
                    if (SmppResourceAdaptor.this.tracer.isSevereEnabled()) {
                        SmppResourceAdaptor.this.tracer.severe("Connection lost! for RA " + SmppResourceAdaptor.this.raContext.getEntityName() + "Communication failed", (Throwable)ie);
                    }
                    SmppResourceAdaptor.this.reconnect();
                }
                catch (BadCommandIDException ex) {
                    SmppResourceAdaptor.this.tracer.severe("BadCommandIDException. Failed to enquire link ", (Throwable)ex);
                }
                catch (VersionException ex) {
                    if (!SmppResourceAdaptor.this.tracer.isSevereEnabled()) continue;
                    SmppResourceAdaptor.this.tracer.severe("Failed to enquire link due to wrong Version ", (Throwable)ex);
                }
            }
        }
    }
}

