/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.slee.facilities.Tracer;
import net.java.slee.resources.smpp.SmppSession;
import net.java.slee.resources.smpp.SmppTransaction;
import net.java.slee.resources.smpp.pdu.Address;
import net.java.slee.resources.smpp.pdu.PDU;
import net.java.slee.resources.smpp.pdu.SmppRequest;
import net.java.slee.resources.smpp.pdu.SmppResponse;
import net.java.slee.resources.smpp.util.AbsoluteSMPPDate;
import net.java.slee.resources.smpp.util.RelativeSMPPDate;
import org.mobicents.slee.resources.smpp.ExtSmppRequest;
import org.mobicents.slee.resources.smpp.ExtSmppResponse;
import org.mobicents.slee.resources.smpp.SmppResourceAdaptor;
import org.mobicents.slee.resources.smpp.SmppTransactionImpl;
import org.mobicents.slee.resources.smpp.SmppTransactionType;
import org.mobicents.slee.resources.smpp.pdu.AddressImpl;
import org.mobicents.slee.resources.smpp.pdu.AlertNotificationImpl;
import org.mobicents.slee.resources.smpp.pdu.CancelSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DataSMImpl;
import org.mobicents.slee.resources.smpp.pdu.DeliverSMImpl;
import org.mobicents.slee.resources.smpp.pdu.PDUImpl;
import org.mobicents.slee.resources.smpp.pdu.QuerySMImpl;
import org.mobicents.slee.resources.smpp.pdu.ReplaceSMImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitMultiImpl;
import org.mobicents.slee.resources.smpp.pdu.SubmitSMImpl;
import org.mobicents.slee.resources.smpp.util.AbsoluteSMPPDateImpl;
import org.mobicents.slee.resources.smpp.util.RelativeSMPPDateImpl;

public class SmppSessionImpl
implements SmppSession {
    private Tracer tracer;
    protected ConcurrentMap<Long, SmppTransactionImpl> transactions = new ConcurrentHashMap<Long, SmppTransactionImpl>();
    private String sessionId;
    private SmppResourceAdaptor smppResourceAdaptor = null;
    private boolean isAlive = false;
    protected Timer timer = new Timer();

    public SmppSessionImpl(SmppResourceAdaptor smppResourceAdaptor) {
        this.smppResourceAdaptor = smppResourceAdaptor;
        this.tracer = this.smppResourceAdaptor.getRAContext().getTracer(SmppSessionImpl.class.getSimpleName());
        StringBuffer sb = new StringBuffer();
        sb.append("SmppSession[SMSHost=").append(this.smppResourceAdaptor.getHost()).append(", SMSCPort=").append(this.smppResourceAdaptor.getPort()).append(", SystemId").append(this.smppResourceAdaptor.getSystemId());
        this.sessionId = sb.toString();
    }

    public Address createAddress(int addTon, int addNpi, String address) {
        return new AddressImpl(addTon, addNpi, address);
    }

    public SmppRequest createSmppRequest(int commandId) {
        PDUImpl request = null;
        if (commandId == 258) {
            request = new AlertNotificationImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 8) {
            request = new CancelSMImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 259) {
            request = new DataSMImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 5) {
            request = new DeliverSMImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 3) {
            request = new QuerySMImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 7) {
            request = new ReplaceSMImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 33) {
            request = new SubmitMultiImpl(this.smppResourceAdaptor.seq.nextNumber());
        } else if (commandId == 4) {
            request = new SubmitSMImpl(this.smppResourceAdaptor.seq.nextNumber());
        }
        return request;
    }

    public AbsoluteSMPPDate createAbsoluteSMPPDate(Calendar calendar, boolean hasTz) {
        return new AbsoluteSMPPDateImpl(calendar, hasTz);
    }

    public RelativeSMPPDate createRelativeSMPPDate(int years, int months, int days, int hours, int minutes, int seconds) {
        return new RelativeSMPPDateImpl(years, months, days, hours, minutes, seconds);
    }

    public String getSMSCHost() {
        return this.smppResourceAdaptor.getHost();
    }

    public int getSMSPort() {
        return this.smppResourceAdaptor.getPort();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public SmppTransaction sendRequest(SmppRequest request) throws IllegalStateException, NullPointerException, IOException {
        if (!this.isAlive()) {
            throw new IllegalStateException("The ESME is not connected to SMSC");
        }
        if (request == null) {
            throw new NullPointerException("SMPP Request cannot be null");
        }
        SmppTransactionImpl smppTxImpl = this.getSmppTransactionImpl((PDU)request, true, SmppTransactionType.OUTGOING);
        if (smppTxImpl != null) {
            this.smppResourceAdaptor.sendRequest((ExtSmppRequest)request);
        }
        return smppTxImpl;
    }

    public void sendResponse(SmppTransaction txn, SmppResponse response) throws IllegalStateException, NullPointerException, IOException {
        if (!this.isAlive()) {
            throw new IllegalStateException("The ESME is not connected to SMSC");
        }
        if (response == null) {
            throw new NullPointerException("SMPP Response cannot be null");
        }
        SmppTransactionImpl smppTxImpl = this.getSmppTransactionImpl((PDU)response, false, null);
        smppTxImpl.cancelResponseNotSentTimeout();
        this.smppResourceAdaptor.sendResponse((ExtSmppResponse)response);
    }

    protected void setIsAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SmppTransactionImpl getSmppTransactionImpl(PDU pdu, boolean createActivity, SmppTransactionType txType) {
        SmppTransactionImpl txImpl = (SmppTransactionImpl)this.transactions.remove(pdu.getSequenceNum());
        if (txImpl != null) {
            if (!this.tracer.isFineEnabled()) return txImpl;
            this.tracer.fine("Got the SmppTransaction " + txImpl);
            return txImpl;
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Didnt get the SmppTransaction and createActivity = " + createActivity + " and SmppTransactionType = " + (Object)((Object)txType) + " For PDU " + pdu + " Seq No = " + pdu.getSequenceNum());
        }
        if (createActivity) {
            txImpl = new SmppTransactionImpl((SmppRequest)pdu, this.smppResourceAdaptor, this);
            try {
                this.transactions.put(txImpl.getId(), txImpl);
                switch (txType) {
                    case INCOMING: {
                        this.smppResourceAdaptor.startNewSmppTransactionActivity(txImpl);
                        txImpl.setResponseNotSentTimeout();
                        return txImpl;
                    }
                    case OUTGOING: {
                        this.smppResourceAdaptor.startNewSmppTransactionSuspendedActivity(txImpl);
                        txImpl.setResponseNotReceivedTimeout();
                        return txImpl;
                    }
                }
                return txImpl;
            }
            catch (Exception e) {
                this.tracer.severe("Failed to start the Activity. SmppTransaction " + txImpl, (Throwable)e);
                try {
                    this.transactions.remove(txImpl.getId());
                    switch (txType) {
                        case INCOMING: {
                            txImpl.cancelResponseNotSentTimeout();
                            txImpl.sendGenericNack();
                            SmppTransactionImpl smppTransactionImpl = null;
                            return smppTransactionImpl;
                        }
                        case OUTGOING: {
                            txImpl.cancelResponseNotReceivedTimeout();
                            throw new IllegalStateException("Error while trying to create Activity");
                        }
                    }
                }
                finally {
                    this.smppResourceAdaptor.endActivity(txImpl);
                }
            }
        }
        if (!this.tracer.isFineEnabled()) throw new IllegalStateException("No Activity found for PDU " + pdu);
        this.tracer.fine("Now we will throw exception. But before that lets just iterate");
        Iterator i$ = this.transactions.keySet().iterator();
        while (i$.hasNext()) {
            Long e = (Long)i$.next();
            this.tracer.fine("Seq = " + e);
        }
        throw new IllegalStateException("No Activity found for PDU " + pdu);
    }

    public int hashCode() {
        int prime = 19;
        int result = 1;
        result = 19 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmppSessionImpl other = (SmppSessionImpl)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }
}

