/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.slee.facilities.Tracer;
import net.java.slee.resources.smpp.SmppSession;
import net.java.slee.resources.smpp.SmppTransaction;
import net.java.slee.resources.smpp.pdu.PDU;
import net.java.slee.resources.smpp.pdu.SmppRequest;
import org.mobicents.slee.resources.smpp.SmppResourceAdaptor;
import org.mobicents.slee.resources.smpp.SmppSessionImpl;
import org.mobicents.slee.resources.smpp.SmppTransactionHandle;
import org.mobicents.slee.resources.smpp.pdu.GenericNackImpl;
import org.mobicents.slee.resources.smpp.pdu.SmppErrorImpl;

public class SmppTransactionImpl
implements SmppTransaction {
    private static Tracer tracer;
    private SmppResourceAdaptor smppRA;
    private SmppSessionImpl smppSess;
    private long sequenceNumber;
    private SmppRequest requestPDU;
    private ResponseNotSent responseNotSent;
    private ResponseNotReceived responseNotReceived;
    private final SmppTransactionHandle handle;

    protected SmppTransactionImpl(SmppTransactionHandle handle, SmppRequest requestPDU, SmppResourceAdaptor smppRA, SmppSessionImpl smppSess) {
        this.requestPDU = requestPDU;
        this.smppRA = smppRA;
        if (tracer == null) {
            tracer = this.smppRA.getRAContext().getTracer(SmppTransactionImpl.class.getSimpleName());
        }
        this.smppSess = smppSess;
        this.sequenceNumber = this.requestPDU.getSequenceNum();
        this.handle = handle;
    }

    public SmppTransactionHandle getHandle() {
        return this.handle;
    }

    public long getId() {
        return this.sequenceNumber;
    }

    public SmppSession getSmppSession() {
        return this.smppSess;
    }

    protected SmppRequest getSmppRequest() {
        return this.requestPDU;
    }

    protected void setResponseNotSentTimeout() {
        this.responseNotSent = new ResponseNotSent(this);
        this.smppSess.timer.schedule(this.responseNotSent, (long)this.smppRA.getSmppResponseSentTimeout(), TimeUnit.MILLISECONDS);
    }

    protected void setResponseNotReceivedTimeout() {
        this.responseNotReceived = new ResponseNotReceived(this);
        this.smppSess.timer.schedule(this.responseNotReceived, (long)this.smppRA.getSmppResponseReceivedTimeout(), TimeUnit.MILLISECONDS);
    }

    protected void cancelResponseNotSentTimeout() {
        if (this.responseNotSent != null) {
            this.responseNotSent.cancel();
        }
    }

    protected void cancelResponseNotReceivedTimeout() {
        if (this.responseNotReceived != null) {
            this.responseNotReceived.cancel();
        }
    }

    protected void sendGenericNack() {
        GenericNackImpl genericNak = new GenericNackImpl(255);
        genericNak.setSequenceNum(this.requestPDU.getSequenceNum());
        try {
            this.smppRA.sendResponse(genericNak);
        }
        catch (IOException e) {
            tracer.severe("IOException while sending GenericNack SMPP Response", (Throwable)e);
        }
    }

    private void responseNotSent() {
        this.sendGenericNack();
        SmppErrorImpl error = new SmppErrorImpl(2, (PDU)this.requestPDU);
        this.smppRA.fireEvent("net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_SENT", this, error);
        this.smppRA.endActivity(this);
    }

    private void responseNotReceived() {
        SmppErrorImpl error = new SmppErrorImpl(1, (PDU)this.requestPDU);
        this.smppRA.fireEvent("net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_RECEIVED", this, error);
        this.smppRA.endActivity(this);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmppTransactionImpl other = (SmppTransactionImpl)obj;
        return this.handle.equals(other.handle);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransactionImpl[SequenceNumber = ").append(this.sequenceNumber).append(", Hash = ").append(this.hashCode()).append("]");
        return sb.toString();
    }

    private static class ResponseNotReceived
    implements Runnable {
        private final SmppTransactionImpl tx;
        private boolean cancelled = false;

        public ResponseNotReceived(SmppTransactionImpl tx) {
            this.tx = tx;
        }

        public void run() {
            if (this.cancelled) {
                return;
            }
            this.tx.responseNotReceived();
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    private static class ResponseNotSent
    implements Runnable {
        private final SmppTransactionImpl tx;
        private boolean cancelled = false;

        public ResponseNotSent(SmppTransactionImpl tx) {
            this.tx = tx;
        }

        public void run() {
            if (this.cancelled) {
                return;
            }
            this.tx.responseNotSent();
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

