/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.tts.ra;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.RawFileAudioPlayer;
import com.sun.speech.freetts.audio.SingleFileAudioPlayer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.server.UID;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import org.jboss.logging.Logger;
import org.mobicents.slee.resource.tts.ratype.TTSSession;

public class TTSSessionImpl
implements TTSSession {
    private Logger log = Logger.getLogger(this.getClass());
    private String sessionID = null;
    private String voiceName = null;
    private Voice voice;
    private String fileName = null;
    private AudioPlayer audioPlayer = null;

    public TTSSessionImpl(String fileName, String voiceName) {
        this.log.debug((Object)("TTSSessionImpl() called. voiceName = " + voiceName + " File Name = " + fileName));
        this.sessionID = new UID().toString();
        this.fileName = fileName;
        this.voiceName = voiceName;
        this.init();
    }

    private void init() {
        VoiceManager voiceManager = VoiceManager.getInstance();
        this.voice = voiceManager.getVoice(this.getVoiceName());
        this.voice.allocate();
        AudioFileFormat.Type type = TTSSessionImpl.getAudioType(this.fileName);
        if (type != null) {
            this.audioPlayer = new SingleFileAudioPlayer(TTSSessionImpl.getBasename(this.fileName), type);
        } else {
            try {
                this.audioPlayer = new RawFileAudioPlayer(this.fileName);
            }
            catch (IOException ioe) {
                this.log.error((Object)("Can't open " + this.fileName + " " + ioe), (Throwable)ioe);
            }
        }
        if (this.audioPlayer == null) {
            this.log.warn((Object)"AudioPlayer is null. Trying to instantiate default AudioPlayer");
            try {
                this.audioPlayer = this.voice.getDefaultAudioPlayer();
            }
            catch (InstantiationException e) {
                this.log.error((Object)"Error in creating instance of DefualtAudioPlayer", (Throwable)e);
            }
        }
        this.voice.setAudioPlayer(this.audioPlayer);
    }

    public String getSessionId() {
        return this.sessionID;
    }

    public boolean textToAudioFile(String text) {
        boolean ok = this.batchTextToSpeech(text);
        this.dispose();
        return ok;
    }

    public boolean streamToAudioFile(InputStream is) {
        return this.streamToSpeech(is);
    }

    public boolean urltoAudioFile(String urlPath) {
        boolean ok = false;
        try {
            URL url = new URL(urlPath);
            InputStream is = url.openStream();
            ok = this.streamToSpeech(is);
        }
        catch (IOException ioe) {
            this.log.error((Object)("Can't read data from " + urlPath), (Throwable)ioe);
        }
        return ok;
    }

    public boolean filetoAudioFile(String filePath) {
        boolean ok = false;
        try {
            FileInputStream is = new FileInputStream(filePath);
            ok = this.streamToSpeech(is);
        }
        catch (IOException ioe) {
            this.log.error((Object)("Can't read data from " + filePath));
        }
        return ok;
    }

    private String getVoiceName() {
        if (this.voiceName == null) {
            return "kevin16";
        }
        return this.voiceName;
    }

    private static AudioFileFormat.Type getAudioType(String file) {
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
        String extension = TTSSessionImpl.getExtension(file);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getExtension().equals(extension)) continue;
            return types[i];
        }
        return null;
    }

    private static String getExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return path.substring(index + 1);
    }

    private static String getBasename(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public boolean textToSpeech(String text) {
        return this.voice.speak(text);
    }

    private boolean batchTextToSpeech(String text) {
        this.voice.startBatch();
        boolean ok = this.textToSpeech(text);
        this.voice.endBatch();
        return ok;
    }

    public boolean streamToSpeech(InputStream is) {
        this.voice.startBatch();
        boolean ok = this.voice.speak(is);
        this.voice.endBatch();
        return ok;
    }

    public void dispose() {
        if (this.audioPlayer != null) {
            this.audioPlayer.close();
        }
        if (this.voice != null) {
            this.voice.deallocate();
        }
    }
}

