/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.xmpp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.jivesoftware.smack.ComponentXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.xmpp.XmppActivityContextInterfaceFactory;
import org.mobicents.slee.resource.xmpp.XmppActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.xmpp.XmppActivityHandle;
import org.mobicents.slee.resource.xmpp.XmppConnection;
import org.mobicents.slee.resource.xmpp.XmppResourceAdaptorSbbInterface;

public class XmppResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static transient Logger log = Logger.getLogger(XmppResourceAdaptor.class);
    private transient SleeContainer container;
    private ResourceAdaptorState state;
    private transient Map activities = Collections.synchronizedMap(new HashMap(100));
    private int maxEventsPoolSize;
    private transient SleeEndpoint sleeEndpoint;
    private transient EventLookupFacility eventLookup;
    private transient BootstrapContext bootstrapContext;
    private transient XmppRASbbInterfaceImpl sbbInterface;
    private transient XmppActivityContextInterfaceFactory acif;
    private transient Map XmppToSleeEvent = Collections.synchronizedMap(new HashMap(100));
    private Map eventIDsOfServicesInstalled = Collections.synchronizedMap(new HashMap(31));
    private Map myComponentKeys = Collections.synchronizedMap(new HashMap(31));

    public void entityCreated(BootstrapContext ctx) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entityCreated");
        }
        this.init(ctx);
    }

    public void entityRemoved() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entityRemoved");
        }
    }

    public void entityActivated() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entityActivated");
        }
        try {
            try {
                this.configure();
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entityDeactivating");
        }
        this.stopping();
    }

    public void entityDeactivated() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"entityDeactivated");
        }
        this.stop();
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"eventProcessingSuccessful");
        }
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"eventProcessingFailed");
        }
    }

    public void endActivity(ActivityHandle ah) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"endActivity");
        }
        try {
            this.sleeEndpoint.activityEnding(ah);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public void activityEnded(ActivityHandle ah) {
        XmppConnection activity;
        if (log.isDebugEnabled()) {
            log.info((Object)("Activity Ended of connection " + ah.toString()));
        }
        if ((activity = (XmppConnection)this.activities.remove(ah)) != null && log.isDebugEnabled()) {
            log.debug((Object)("Removed terminated activity [activity =  " + activity + "]"));
            log.debug((Object)("active activity list = " + this.activities.size()));
        }
    }

    public void activityUnreferenced(ActivityHandle ah) {
        XmppActivityHandle ac;
        if (log.isDebugEnabled()) {
            log.debug((Object)"activityUnreferenced");
        }
        if ((ac = (XmppActivityHandle)this.activities.remove(ah)) != null && log.isDebugEnabled()) {
            log.debug((Object)("Removed terminated activity [activity =  " + ac + "]"));
            log.debug((Object)("active activity list = " + this.activities.size()));
        }
    }

    public void queryLiveness(ActivityHandle arg0) {
        XmppConnection connection;
        if (log.isDebugEnabled()) {
            log.debug((Object)"queryLiveness");
        }
        if ((connection = (XmppConnection)this.activities.get(arg0)) == null) {
            this.endActivity(arg0);
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get Activity with ActivityHandle " + handle.toString()));
        }
        return this.activities.get(handle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getActivityHandle");
        }
        XmppActivityHandle activityHandle = null;
        try {
            activityHandle = new XmppActivityHandle(((XmppConnection)arg0).getConnectionId());
        }
        catch (Exception e) {
            log.error((Object)"Failed to get the ActivityHandle.", (Throwable)e);
        }
        return activityHandle;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getSBBResourceAdaptorInterface");
        }
        return this.sbbInterface;
    }

    public Marshaler getMarshaler() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getMarshaler");
        }
        return null;
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
        this.eventIDsOfServicesInstalled.put(arg0, arg1);
    }

    public void serviceActivated(String arg0) {
        int[] eventIDs = (int[])this.eventIDsOfServicesInstalled.get(arg0);
        if (eventIDs != null) {
            for (int i = 0; i < eventIDs.length; ++i) {
                EventTypeIDImpl eventTypeID = this.container.getEventTypeID(eventIDs[i]);
                ComponentKey eventKey = this.container.getEventKey((EventTypeID)eventTypeID);
                Set servicesActivatedList = (Set)this.myComponentKeys.get(eventKey);
                if (servicesActivatedList == null) continue;
                servicesActivatedList.add(arg0);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Service " + arg0 + " is activated and registred to event with key " + eventKey));
            }
        }
    }

    public void serviceDeactivated(String arg0) {
        int[] eventIDs = (int[])this.eventIDsOfServicesInstalled.get(arg0);
        if (eventIDs != null) {
            for (int i = 0; i < eventIDs.length; ++i) {
                EventTypeIDImpl eventTypeID = this.container.getEventTypeID(eventIDs[i]);
                ComponentKey eventKey = this.container.getEventKey((EventTypeID)eventTypeID);
                Set servicesActivatedList = (Set)this.myComponentKeys.get(eventKey);
                if (servicesActivatedList == null) continue;
                servicesActivatedList.remove(arg0);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Service " + arg0 + " was deactivated and unregistred to event with key " + eventKey));
            }
        }
    }

    public void serviceUninstalled(String arg0) {
        this.eventIDsOfServicesInstalled.remove(arg0);
    }

    public void init(BootstrapContext bootstrapContext) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    public void configure() throws InvalidStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"configure");
        }
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new InvalidStateException("Cannot configure RA wrong state: " + this.state);
        }
        try {
            this.state = ResourceAdaptorState.CONFIGURED;
        }
        catch (Exception ex) {
            log.error((Object)"Couldn't create the Xmpp Connection Factory", (Throwable)ex);
        }
    }

    public void start() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start");
        }
        try {
            this.container = SleeContainer.lookupFromJndi();
            ResourceAdaptorEntity resourceAdaptorEntity = this.container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
            ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
            EventTypeID[] eventTypeIDs = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getRaTypeDescr().getEventTypes();
            for (int i = 0; i < eventTypeIDs.length; ++i) {
                ComponentKey eventKey = this.container.getEventKey(eventTypeIDs[i]);
                this.myComponentKeys.put(eventKey, Collections.synchronizedSet(new HashSet()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keys for this RA: " + this.myComponentKeys.keySet().toString()));
            }
            this.acif = new XmppActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), this.bootstrapContext.getEntityName());
            resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ResourceException(ex.getMessage());
        }
        this.sbbInterface = new XmppRASbbInterfaceImpl();
        this.state = ResourceAdaptorState.ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"stop");
        }
        Map map = this.activities;
        synchronized (map) {
            for (XmppConnection activity : this.activities.values()) {
                XmppActivityHandle handle = new XmppActivityHandle(activity.getConnectionId());
                ((XMPPConnection)activity.getConnection()).close();
                this.endActivity(handle);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"All activities ended.");
        }
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't unbind naming context", (Throwable)e);
        }
        this.sbbInterface = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Xmpp Resource Adaptor stopped.");
        }
    }

    public void stopping() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"stopping");
        }
        this.state = ResourceAdaptorState.STOPPING;
    }

    public Object getFactoryInterface() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFactoryInterface");
        }
        return null;
    }

    public Object getActivityContextInterfaceFactory() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getActivityContextInterfaceFactory");
        }
        return this.acif;
    }

    public void setResourceAdaptorEntity(ResourceAdaptorEntity resourceAdaptorEntity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setResourceAdaptorEntity");
        }
    }

    public void processEvent(Object event, XmppActivityHandle handle) {
        int eventID;
        Set servicesActivatedList;
        ComponentKey key;
        if (log.isDebugEnabled()) {
            log.debug((Object)("NEW XMPP-RA EVENT: " + event.getClass().getName()));
        }
        if ((key = (ComponentKey)this.XmppToSleeEvent.get(event.getClass().getName())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("key = null - " + event.getClass().getName()));
            }
            key = new ComponentKey(event.getClass().getName(), "org.jivesoftware.smack", "1.0");
            this.XmppToSleeEvent.put(event.getClass().getName(), key);
        }
        if ((servicesActivatedList = (Set)this.myComponentKeys.get(key)) == null || servicesActivatedList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No services activated have interest in event type with key " + key.toString()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("event lookup for type " + key.toString()));
        }
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
        }
        catch (FacilityException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup event!", e2);
        }
        catch (UnrecognizedEventException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup event!", e2);
        }
        if (eventID == -1) {
            log.error((Object)"Event lookup -- could not find event mapping -- check xml/slee-events.xml");
            return;
        }
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)handle, event, eventID, null);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (ActivityIsEndingException e) {
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public Map getActivities() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getActivities");
        }
        return this.activities;
    }

    public SleeEndpoint getSleeEndpoint() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getSleeEndpoint");
        }
        return this.sleeEndpoint;
    }

    public void setSleeEndpoint(SleeEndpoint sleeEndpoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setSleeEndpoint");
        }
        this.sleeEndpoint = sleeEndpoint;
    }

    public void setMaxEventsPoolSize(int max) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMaxEventsPoolSize, max=" + max));
        }
        this.maxEventsPoolSize = max;
    }

    public int getMaxPoolEventSize() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getMaxPoolEventSize");
        }
        return this.maxEventsPoolSize;
    }

    private void addListener(String connectionID, XMPPConnection connection, XmppActivityHandle handle, Collection packetFilters) {
        XmppConnectionListener listener = new XmppConnectionListener(connectionID, handle);
        if (packetFilters == null) {
            connection.addPacketListener((PacketListener)listener, null);
        } else {
            Iterator i = packetFilters.iterator();
            while (i.hasNext()) {
                connection.addPacketListener((PacketListener)listener, (PacketFilter)new PacketTypeFilter((Class)i.next()));
            }
        }
        connection.addConnectionListener((ConnectionListener)listener);
    }

    private void createActivity(String connectionID, XMPPConnection connection, XmppActivityHandle handle) {
        if (connection != null) {
            XmppConnection activity = new XmppConnection(connectionID, (Object)connection);
            this.activities.put(handle, activity);
            try {
                this.sleeEndpoint.activityStarted((ActivityHandle)handle);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (ActivityAlreadyExistsException e) {
                e.printStackTrace();
            }
            catch (CouldNotStartActivityException e) {
                e.printStackTrace();
            }
        }
    }

    public class XmppConnectionListener
    implements PacketListener,
    ConnectionListener {
        private String connectionID = null;
        private XmppActivityHandle handle = null;

        public XmppConnectionListener(String connectionID, XmppActivityHandle handle) {
            this.connectionID = connectionID;
            this.handle = handle;
        }

        public void processPacket(Packet packet) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.connectionID + " received packet: " + packet.toXML()));
            }
            XmppResourceAdaptor.this.processEvent(packet, this.handle);
        }

        public void connectionClosed() {
            XmppActivityHandle handle = new XmppActivityHandle(this.connectionID);
            XmppConnection connection = (XmppConnection)XmppResourceAdaptor.this.activities.get(handle);
            if (connection != null) {
                log.info((Object)("Got notification that connection with id=" + this.connectionID + " closed. Requesting ActivityEndEvent."));
                XmppResourceAdaptor.this.endActivity(handle);
            }
        }

        public void connectionClosedOnError(Exception arg0) {
            XmppActivityHandle handle = new XmppActivityHandle(this.connectionID);
            XmppConnection connection = (XmppConnection)XmppResourceAdaptor.this.activities.get(handle);
            if (connection != null) {
                log.info((Object)("Got notification that connection with id=" + this.connectionID + " closed on error. Requesting ActivityEndEvent."), (Throwable)arg0);
                XmppResourceAdaptor.this.endActivity(handle);
            }
        }
    }

    public class XmppRASbbInterfaceImpl
    implements XmppResourceAdaptorSbbInterface {
        public void sendPacket(String connectionID, Packet packet) {
            try {
                XmppActivityHandle handle = new XmppActivityHandle(connectionID);
                XmppConnection connection = (XmppConnection)XmppResourceAdaptor.this.activities.get(handle);
                if (connection != null) {
                    ((XMPPConnection)connection.getConnection()).sendPacket(packet);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(connectionID + " sent packet: " + packet.toXML()));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                e.printStackTrace();
            }
        }

        public void connectClient(String connectionID, String serverHost, int serverPort, String serviceName, String username, String password, String resource, Collection packetFilters) throws XMPPException {
            XMPPConnection connection;
            XmppActivityHandle handle = new XmppActivityHandle(connectionID);
            if (XmppResourceAdaptor.this.activities.get(handle) == null) {
                log.info((Object)("Connecting to service " + serviceName + " at " + serverHost + ":" + serverPort));
                connection = null;
                try {
                    connection = new XMPPConnection(serverHost, serverPort, serviceName);
                    XmppResourceAdaptor.this.addListener(connectionID, connection, handle, packetFilters);
                    connection.login(username, password, resource);
                }
                catch (Exception e) {
                    log.info((Object)"Can't connect to service.");
                    throw new XMPPException((Throwable)e);
                }
            } else {
                String e = "Connection already exists!";
                log.info((Object)e);
                throw new XMPPException(e);
            }
            XmppResourceAdaptor.this.createActivity(connectionID, connection, handle);
        }

        public void connectComponent(String connectionID, String serverHost, int serverPort, String serviceName, String componentName, String componentSecret, Collection packetFilters) throws XMPPException {
            ComponentXMPPConnection connection;
            XmppActivityHandle handle = new XmppActivityHandle(connectionID);
            if (XmppResourceAdaptor.this.activities.get(handle) == null) {
                log.info((Object)("Opening Component XMPP connection to " + serverHost + " on port " + serverPort));
                connection = null;
                try {
                    connection = new ComponentXMPPConnection(componentName, componentSecret, serverHost, serverPort, serviceName);
                    ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
                    ServiceDiscoveryManager.setIdentityName((String)"mobicents component");
                    ServiceDiscoveryManager.setIdentityType((String)"mobicents");
                    ServiceDiscoveryManager.setIdentityCategory((String)"component");
                    XmppResourceAdaptor.this.addListener(connectionID, (XMPPConnection)connection, handle, packetFilters);
                    log.info((Object)"XMPP Component connected.");
                }
                catch (Exception e) {
                    log.info((Object)"XMPP Component NOT connected.");
                    throw new XMPPException((Throwable)e);
                }
            } else {
                String e = "Connection already exists!";
                log.info((Object)e);
                throw new XMPPException(e);
            }
            XmppResourceAdaptor.this.createActivity(connectionID, (XMPPConnection)connection, handle);
        }

        public void disconnect(String connectionID) {
            try {
                XmppActivityHandle handle = new XmppActivityHandle(connectionID);
                XmppConnection connection = (XmppConnection)XmppResourceAdaptor.this.activities.get(handle);
                if (connection != null) {
                    ((XMPPConnection)connection.getConnection()).close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                e.printStackTrace();
            }
        }
    }
}

