/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityContextInterfaceFactory;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.publication.PublicationClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.publication.PublicationClientControlSbbLocalObject;

public abstract class InternalPublisherExampleSbb
implements Sbb,
PublicationClientControlParentSbbLocalObject {
    String presenceDomain = System.getProperty("bind.address", "127.0.0.1");
    String entity = "sip:internal-publisher@" + this.presenceDomain;
    String eventPackage = "presence";
    String contentType = "application";
    String contentSubType = "pidf+xml";
    String document = "<?xml version='1.0' encoding='UTF-8'?><presence xmlns='urn:ietf:params:xml:ns:pidf' xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model' xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid' xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='sip:internal-publisher@" + this.presenceDomain + "'>" + "<tuple id='t54bb0569'><status><basic>open</basic></status></tuple>" + "<dm:person id='p65f3307a'>" + "<rpid:activities><rpid:busy/></rpid:activities>" + "<dm:note>Busy</dm:note>" + "</dm:person>" + "</presence>";
    int expires = 300;
    private SbbContext sbbContext = null;
    private TimerFacility timerFacility = null;
    private ServiceActivityFactory serviceActivityFactory = null;
    private ServiceActivityContextInterfaceFactory serviceActivityContextInterfaceFactory = null;
    private static Logger log4j = Logger.getLogger(InternalPublisherExampleSbb.class);

    public abstract ChildRelation getPublicationControlChildRelation();

    public abstract PublicationClientControlSbbLocalObject getPublicationControlChildSbbCMP();

    public abstract void setPublicationControlChildSbbCMP(PublicationClientControlSbbLocalObject var1);

    private PublicationClientControlSbbLocalObject getPublicationControlChildSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationControlChildSbbCMP();
        if (childSbb == null) {
            childSbb = (PublicationClientControlSbbLocalObject)this.getPublicationControlChildRelation().create();
            this.setPublicationControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((PublicationClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public abstract void setETag(String var1);

    public abstract String getETag();

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        if (this.serviceActivityFactory.getActivity().equals(aci.getActivity())) {
            log4j.info((Object)"Service activated, publishing state...");
            try {
                this.getPublicationControlChildSbb().newPublication((Object)(this.entity + this.eventPackage), this.entity, this.eventPackage, this.document, this.contentType, this.contentSubType, this.expires);
            }
            catch (Exception e) {
                log4j.error((Object)e);
            }
        } else {
            aci.detach(this.sbbContext.getSbbLocalObject());
        }
    }

    public void newPublicationOk(Object requestId, String tag, int expires) throws Exception {
        log4j.info((Object)("publication ok: eTag=" + tag));
        this.setETag(tag);
        TimerOptions timerOptions = new TimerOptions();
        timerOptions.setPersistent(true);
        timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        ServiceActivity serviceActivity = this.serviceActivityFactory.getActivity();
        ActivityContextInterface aci = null;
        try {
            aci = this.serviceActivityContextInterfaceFactory.getActivityContextInterface(serviceActivity);
        }
        catch (Exception e) {
            log4j.error((Object)"Failed to retreive service activity aci", (Throwable)e);
            try {
                this.getPublicationControlChildSbb().refreshPublication(requestId, this.entity, this.eventPackage, tag, expires);
            }
            catch (Exception f) {
                log4j.error((Object)"Dude, now I can't get the child sbb!!", (Throwable)f);
            }
            return;
        }
        this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + (long)(expires * 1000), (long)(expires * 1000), 0, timerOptions);
    }

    public void newPublicationError(Object requestId, int error) {
        log4j.info((Object)("error on mew publication: requestId=" + requestId + ",error=" + error));
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            this.getPublicationControlChildSbb().refreshPublication((Object)(this.entity + this.eventPackage), this.entity, this.eventPackage, this.getETag(), this.expires);
        }
        catch (Exception e) {
            log4j.error((Object)e);
        }
    }

    public void refreshPublicationOk(Object requestId, String tag, int expires) throws Exception {
        log4j.info((Object)("refreshed publication ok: requestId=" + requestId + ",eTag=" + tag + ",expires=" + expires));
        this.setETag(tag);
    }

    public void refreshPublicationError(Object requestId, int error) {
        log4j.info((Object)("erro when refreshing publication: requestId=" + requestId + ",error=" + error));
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        if (this.getETag() != null) {
            log4j.info((Object)"Service deactivated, removing publication...");
            try {
                this.getPublicationControlChildSbb().removePublication((Object)(this.entity + this.eventPackage), this.entity, this.eventPackage, this.getETag());
            }
            catch (Exception e) {
                log4j.error((Object)e);
            }
        } else {
            log4j.info((Object)"Service deactivated, no published state to remove.");
        }
    }

    public void removePublicationOk(Object requestId) throws Exception {
        log4j.info((Object)"publication removed!");
    }

    public void removePublicationError(Object requestId, int error) {
        log4j.info((Object)("error wehn removing publication: requestId=" + requestId + ",error=" + error));
    }

    public void modifyPublicationOk(Object requestId, String tag, int expires) throws Exception {
        log4j.info((Object)"publication modification ok");
    }

    public void modifyPublicationError(Object requestId, int error) {
        log4j.info((Object)("error when modifying publication: requestId=" + requestId + ",error=" + error));
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.serviceActivityFactory = (ServiceActivityFactory)context.lookup("slee/serviceactivity/factory");
            this.serviceActivityContextInterfaceFactory = (ServiceActivityContextInterfaceFactory)context.lookup("slee/serviceactivity/activitycontextinterfacefactory");
        }
        catch (Exception e) {
            log4j.error((Object)"Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        log4j.info((Object)"unsetSbbContext()");
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

