/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.sipevent.server.publication.PublicationClientControlParent;
import org.mobicents.slee.sipevent.server.publication.PublicationClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.publication.Result;

public abstract class InternalPublisherExampleSbb
implements Sbb,
PublicationClientControlParent {
    String presenceDomain = System.getProperty("bind.address", "127.0.0.1");
    String entity = "sip:internal-publisher@" + this.presenceDomain;
    String eventPackage = "presence";
    String contentType = "application";
    String contentSubType = "pidf+xml";
    String document = "<?xml version='1.0' encoding='UTF-8'?><presence xmlns='urn:ietf:params:xml:ns:pidf' xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model' xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid' xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='sip:internal-publisher@" + this.presenceDomain + "'>" + "<tuple id='t54bb0569'><status><basic>open</basic></status></tuple>" + "<dm:person id='p65f3307a'>" + "<rpid:activities><rpid:busy/></rpid:activities>" + "<dm:note>Busy</dm:note>" + "</dm:person>" + "</presence>";
    int expires = 300;
    private TimerFacility timerFacility = null;
    private Tracer tracer;

    public abstract ChildRelationExt getPublicationControlChildRelation();

    private PublicationClientControlSbbLocalObject getPublicationControlChildSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        ChildRelationExt childRelation = this.getPublicationControlChildRelation();
        PublicationClientControlSbbLocalObject child = (PublicationClientControlSbbLocalObject)childRelation.get("0");
        if (child == null) {
            child = (PublicationClientControlSbbLocalObject)childRelation.create("0");
        }
        return child;
    }

    public abstract void setETag(String var1);

    public abstract String getETag();

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        this.tracer.info("Service activated, publishing state...");
        try {
            Result result = this.getPublicationControlChildSbb().newPublication(this.entity, this.eventPackage, this.document, this.contentType, this.contentSubType, this.expires);
            if (result.getStatusCode() == 200) {
                this.tracer.info("publication ok: eTag=" + result.getETag());
                this.setETag(result.getETag());
                this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + (long)(this.expires * 1000), (long)(this.expires * 1000), 0, new TimerOptions());
            } else {
                this.tracer.info("error on mew publication: error=" + result.getStatusCode());
            }
        }
        catch (Exception e) {
            this.tracer.severe("failed to create publication", (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            Result result = this.getPublicationControlChildSbb().refreshPublication(this.entity, this.eventPackage, this.getETag(), this.expires);
            if (result.getStatusCode() == 200) {
                this.tracer.info("refreshed publication ok: eTag=" + result.getETag() + ",expires=" + result.getExpires());
                this.setETag(result.getETag());
            } else {
                this.tracer.info("error when refreshing publication: error=" + result.getStatusCode());
            }
        }
        catch (Exception e) {
            this.tracer.severe("failed to refresh publication", (Throwable)e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        if (this.getETag() != null) {
            this.tracer.info("Service deactivated, removing publication...");
            try {
                this.getPublicationControlChildSbb().removePublication(this.entity, this.eventPackage, this.getETag());
            }
            catch (Exception e) {
                this.tracer.severe("failed to remove publication", (Throwable)e);
            }
        } else {
            this.tracer.info("Service deactivated, no published state to remove.");
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.tracer = sbbContext.getTracer(this.getClass().getSimpleName());
        try {
            this.timerFacility = (TimerFacility)new InitialContext().lookup("java:comp/env/slee/facilities/timer");
        }
        catch (Exception e) {
            this.tracer.severe("Unable to timer facility", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

