/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import org.mobicents.slee.sipevent.examples.RLSExamplePublisher;
import org.mobicents.slee.sipevent.examples.RLSExamplePublisherParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sippresence.client.PresenceClientControlParentSbbLocalObject;
import org.mobicents.slee.sippresence.client.PresenceClientControlSbbLocalObject;

public abstract class RLSExamplePublisherSbb
implements Sbb,
RLSExamplePublisher {
    String eventPackage = "presence";
    String contentType = "application";
    String contentSubType = "pidf+xml";
    int expires = 300;
    private SbbContext sbbContext = null;
    private TimerFacility timerFacility = null;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private Tracer tracer;

    private String getDocument(String publisher) {
        return "<?xml version='1.0' encoding='UTF-8'?><presence xmlns='urn:ietf:params:xml:ns:pidf' xmlns:dm='urn:ietf:params:xml:ns:pidf:data-model' xmlns:rpid='urn:ietf:params:xml:ns:pidf:rpid' xmlns:c='urn:ietf:params:xml:ns:pidf:cipid' entity='" + publisher + "'>" + "<tuple id='t54bb0569'><status><basic>open</basic></status></tuple>" + "<dm:person id='p65f3307a'>" + "<rpid:activities><rpid:busy/></rpid:activities>" + "<dm:note>Busy</dm:note>" + "</dm:person>" + "</presence>";
    }

    public abstract ChildRelation getPresenceClientControlSbbChildRelation();

    public abstract PresenceClientControlSbbLocalObject getPresenceClientControlSbbCMP();

    public abstract void setPresenceClientControlSbbCMP(PresenceClientControlSbbLocalObject var1);

    private PresenceClientControlSbbLocalObject getPresenceClientControlSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        PresenceClientControlSbbLocalObject childSbb = this.getPresenceClientControlSbbCMP();
        if (childSbb == null) {
            childSbb = (PresenceClientControlSbbLocalObject)this.getPresenceClientControlSbbChildRelation().create();
            this.setPresenceClientControlSbbCMP(childSbb);
            childSbb.setParentSbb((PresenceClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public abstract void setParentSbbCMP(RLSExamplePublisherParentSbbLocalObject var1);

    public abstract RLSExamplePublisherParentSbbLocalObject getParentSbbCMP();

    public abstract void setPublisher(String var1);

    public abstract String getPublisher();

    public abstract void setETag(String var1);

    public abstract String getETag();

    public void setParentSbb(RLSExamplePublisherParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    public void start(String publisher) {
        try {
            this.setPublisher(publisher);
            this.getPresenceClientControlSbb().newPublication((Object)"requestId", publisher, this.getDocument(publisher), this.contentType, this.contentSubType, this.expires);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
            this.getParentSbbCMP().publisherNotStarted(publisher);
        }
    }

    public void newPublicationError(Object requestId, int error) {
        this.tracer.info("error on mew publication: requestId=" + requestId + ",error=" + error);
        this.getParentSbbCMP().publisherNotStarted(this.getPublisher());
    }

    public void newPublicationOk(Object requestId, String tag, int expires) {
        this.tracer.info("publication ok: eTag=" + tag);
        this.setETag(tag);
        TimerOptions timerOptions = new TimerOptions();
        timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        NullActivity nullActivity = this.nullActivityFactory.createNullActivity();
        ActivityContextInterface aci = this.nullACIFactory.getActivityContextInterface(nullActivity);
        aci.attach(this.sbbContext.getSbbLocalObject());
        this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + (long)((expires - 1) * 1000), (long)((expires - 1) * 1000), 0, timerOptions);
        this.getParentSbbCMP().publisherStarted(this.getPublisher());
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        String publisher = this.getPublisher();
        try {
            this.getPresenceClientControlSbb().refreshPublication((Object)"requestId", publisher, this.getETag(), this.expires);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void refreshPublicationOk(Object requestId, String tag, int expires) {
        this.tracer.info("refreshed publication ok: requestId=" + requestId + ",eTag=" + tag + ",expires=" + expires);
        this.setETag(tag);
    }

    public void refreshPublicationError(Object requestId, int error) {
        this.tracer.info("erro when refreshing publication: requestId=" + requestId + ",error=" + error);
    }

    public void stop() {
        try {
            this.getPresenceClientControlSbb().removePublication((Object)"requestId", this.getPublisher(), this.getETag());
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void removePublicationError(Object requestId, int error) {
        this.tracer.info("error wehn removing publication: requestId=" + requestId + ",error=" + error);
    }

    public void removePublicationOk(Object requestId) {
        this.tracer.info("publication removed!");
    }

    public void modifyPublicationError(Object requestId, int error) {
    }

    public void modifyPublicationOk(Object requestId, String eTag, int expires) {
    }

    public void newSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
    }

    public void newSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
    }

    public void refreshSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
    }

    public void refreshSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
    }

    public void removeSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
    }

    public void removeSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.tracer = sbbContext.getTracer("RLSExamplePublisherSbb");
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)context.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)context.lookup("slee/nullactivity/factory");
        }
        catch (Exception e) {
            this.tracer.severe("Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

