/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import java.util.Iterator;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.sipevent.examples.RLSExamplePublisherParentSbbLocalObject;
import org.mobicents.slee.sipevent.examples.RLSExamplePublisherSbbLocalObject;
import org.mobicents.slee.sipevent.examples.RLSExampleRoot;
import org.mobicents.slee.sipevent.examples.RLSExampleSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.examples.RLSExampleSubscriberSbbLocalObject;

public abstract class RLSExampleRootSbb
implements Sbb,
RLSExampleRoot {
    String presenceDomain = System.getProperty("bind.address", "127.0.0.1");
    String[] publishers = new String[]{"sip:alice@" + this.presenceDomain, "sip:bob@" + this.presenceDomain};
    private SbbContext sbbContext = null;
    private Tracer tracer;

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        this.tracer.info("Service activated...");
        try {
            RLSExamplePublisherSbbLocalObject child = (RLSExamplePublisherSbbLocalObject)this.getPublisherChildRelation().create();
            child.setParentSbb((RLSExamplePublisherParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
            child.start(this.publishers[0]);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void publisherNotStarted(String publisher) {
        this.tracer.info("publisher didn't started " + publisher);
    }

    public void publisherStarted(String publisher) {
        this.tracer.info("publisher started " + publisher);
        if (publisher.equals(this.publishers[0])) {
            try {
                RLSExamplePublisherSbbLocalObject child = (RLSExamplePublisherSbbLocalObject)this.getPublisherChildRelation().create();
                child.setParentSbb((RLSExamplePublisherParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
                child.start(this.publishers[1]);
            }
            catch (Exception e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                RLSExampleSubscriberSbbLocalObject child = (RLSExampleSubscriberSbbLocalObject)this.getSubscriberChildRelation().create();
                child.setParentSbb((RLSExampleSubscriberParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
                child.start(this.publishers);
            }
            catch (Exception e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void subscriberNotStarted() {
        this.tracer.info("subscriber didn't started ");
    }

    public void subscriberStarted() {
        this.tracer.info("subscriber started");
    }

    public void subscriberStopped() {
        this.tracer.info("subscriber stopped");
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        this.tracer.info("Service deactivated...");
        try {
            try {
                Iterator it = this.getPublisherChildRelation().iterator();
                while (it.hasNext()) {
                    ((RLSExamplePublisherSbbLocalObject)it.next()).stop();
                }
                it = this.getSubscriberChildRelation().iterator();
                while (it.hasNext()) {
                    ((RLSExampleSubscriberSbbLocalObject)it.next()).stop();
                }
            }
            catch (Exception e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.tracer.severe("", (Throwable)e);
        }
    }

    public abstract ChildRelation getPublisherChildRelation();

    public abstract ChildRelation getSubscriberChildRelation();

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.tracer = sbbContext.getTracer("RLSExampleRootSbb");
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

