/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.xml.bind.JAXBContext;
import org.mobicents.slee.enabler.userprofile.jpa.jmx.UserProfileControlManagement;
import org.mobicents.slee.enabler.xdmc.XDMClientChildSbbLocalObject;
import org.mobicents.slee.enabler.xdmc.XDMClientParentSbbLocalObject;
import org.mobicents.slee.sipevent.examples.RLSExampleSubscriber;
import org.mobicents.slee.sipevent.examples.RLSExampleSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sippresence.client.PresenceClientControlParentSbbLocalObject;
import org.mobicents.slee.sippresence.client.PresenceClientControlSbbLocalObject;
import org.mobicents.slee.xdm.server.ServerConfiguration;
import org.mobicents.xcap.client.uri.DocumentSelectorBuilder;
import org.mobicents.xcap.client.uri.UriBuilder;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ObjectFactory;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.PackagesType;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.RlsServices;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ServiceType;

public abstract class RLSExampleSubscriberSbb
implements Sbb,
RLSExampleSubscriber {
    private String presenceDomain = System.getProperty("bind.address", "127.0.0.1");
    private String subscriber = "sip:carol@" + this.presenceDomain;
    private String notifier = "sip:carol@" + this.presenceDomain + ";pres-list=Default";
    private String notifierPassword = "password";
    private String eventPackage = "presence";
    private int expires = 300;
    private URI uri = this.buildRLSServicesURI();
    private SbbContext sbbContext = null;
    private TimerFacility timerFacility = null;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private Tracer tracer;

    public abstract ChildRelation getPresenceClientControlSbbChildRelation();

    private URI buildRLSServicesURI() {
        String documentSelector = DocumentSelectorBuilder.getUserDocumentSelectorBuilder((String)"rls-services", (String)this.notifier, (String)"index").toPercentEncodedString();
        UriBuilder uriBuilder = new UriBuilder().setSchemeAndAuthority(ServerConfiguration.getInstance().getSchemeAndAuthority()).setXcapRoot(ServerConfiguration.getInstance().getXcapRoot()).setDocumentSelector(documentSelector);
        try {
            return uriBuilder.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private PresenceClientControlSbbLocalObject getPresenceClientControlSbb() {
        ChildRelation childRelation = this.getPresenceClientControlSbbChildRelation();
        if (childRelation.isEmpty()) {
            try {
                PresenceClientControlSbbLocalObject sbb = (PresenceClientControlSbbLocalObject)childRelation.create();
                sbb.setParentSbb((PresenceClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
                return sbb;
            }
            catch (Exception e) {
                this.tracer.severe("Failed to create child sbb", (Throwable)e);
                return null;
            }
        }
        return (PresenceClientControlSbbLocalObject)childRelation.iterator().next();
    }

    public abstract ChildRelation getXDMClientChildRelation();

    public XDMClientChildSbbLocalObject getXDMClientChildSbb() {
        ChildRelation childRelation = this.getXDMClientChildRelation();
        if (childRelation.isEmpty()) {
            try {
                XDMClientChildSbbLocalObject sbb = (XDMClientChildSbbLocalObject)childRelation.create();
                sbb.setParentSbb((XDMClientParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
                return sbb;
            }
            catch (Exception e) {
                this.tracer.severe("Failed to create child sbb", (Throwable)e);
                return null;
            }
        }
        return (XDMClientChildSbbLocalObject)childRelation.iterator().next();
    }

    public abstract void setParentSbbCMP(RLSExampleSubscriberParentSbbLocalObject var1);

    public abstract RLSExampleSubscriberParentSbbLocalObject getParentSbbCMP();

    public void setParentSbb(RLSExampleSubscriberParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    private EntryType createEntryType(String uri) {
        EntryType entryType = new EntryType();
        entryType.setUri(uri);
        EntryType.DisplayName displayName = new EntryType.DisplayName();
        displayName.setValue(uri);
        entryType.setDisplayName(displayName);
        return entryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRlsServices(String[] entryURIs) {
        StringWriter stringWriter = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.rlsservices.jaxb");
            ListType listType = new ListType();
            for (String entryURI : entryURIs) {
                listType.getListOrExternalOrEntry().add(this.createEntryType(entryURI));
            }
            ServiceType serviceType = new ServiceType();
            serviceType.setList(listType);
            PackagesType packagesType = new PackagesType();
            packagesType.getPackageAndAny().add(new ObjectFactory().createPackagesTypePackage(this.eventPackage));
            serviceType.setPackages(packagesType);
            serviceType.setUri(this.notifier);
            RlsServices rlsServices = new RlsServices();
            rlsServices.getService().add(serviceType);
            context.createMarshaller().marshal((Object)rlsServices, (Writer)stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            this.tracer.severe("failed to read rls-services.xml", (Throwable)e);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void start(String[] entryURIs) {
        try {
            UserProfileControlManagement.getInstance().addUser(this.notifier, this.notifierPassword);
            XDMClientChildSbbLocalObject xdm = this.getXDMClientChildSbb();
            xdm.put(this.uri, "application/rls-services+xml", this.getRlsServices(entryURIs).getBytes("UTF-8"), this.notifier);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
            this.getParentSbbCMP().subscriberNotStarted();
        }
    }

    private String getSubscriptionId() {
        return "rls-example~" + this.subscriber + "~" + this.notifier + "~" + this.eventPackage;
    }

    public void putResponse(URI uri, int responseCode, String responseContent, String eTag) {
        this.tracer.info("Response to the insertion of the rls services document: status=" + responseCode + ",content=" + responseContent);
        if (responseCode != 200 && responseCode != 201) {
            this.getParentSbbCMP().subscriberNotStarted();
        } else {
            this.getPresenceClientControlSbb().newSubscription(this.subscriber, "...", this.notifier, this.eventPackage, this.getSubscriptionId(), this.expires);
        }
    }

    public void newSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        this.tracer.info("subscribe ok: responseCode=" + responseCode + ",expires=" + expires);
        try {
            TimerOptions timerOptions = new TimerOptions();
            timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
            NullActivity nullActivity = this.nullActivityFactory.createNullActivity();
            ActivityContextInterface aci = this.nullACIFactory.getActivityContextInterface(nullActivity);
            aci.attach(this.sbbContext.getSbbLocalObject());
            this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + (long)((expires - 1) * 1000), (long)((expires - 1) * 1000), 0, timerOptions);
            this.getParentSbbCMP().subscriberStarted();
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteRlsServices() {
        try {
            XDMClientChildSbbLocalObject xdm = this.getXDMClientChildSbb();
            xdm.delete(this.uri, this.notifier);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
        UserProfileControlManagement.getInstance().removeUser(this.notifier);
    }

    public void newSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.tracer.info("error on subscribe: error=" + error);
        this.deleteRlsServices();
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        String notification = "\nNOTIFY EVENT:\n+-- Subscriber: " + subscriber + "\n+-- Notifier: " + notifier + "\n+-- EventPackage: " + eventPackage + "\n+-- SubscriptionId: " + subscriptionId + "\n+-- Subscription status: " + status + "\n+-- Subscription terminationReason: " + terminationReason + "\n+-- Content Type: " + contentType + '/' + contentSubtype + "\n+-- Content:\n\n" + content;
        this.tracer.info(notification);
        if (status == Subscription.Status.terminated && terminationReason != null && terminationReason == Subscription.Event.deactivated) {
            this.tracer.info("The subscription was deactivated, re-subscribing");
            this.getPresenceClientControlSbb().newSubscription(subscriber, "...", notifier, eventPackage, this.getSubscriptionId(), this.expires);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        this.getPresenceClientControlSbb().refreshSubscription(this.subscriber, this.notifier, this.eventPackage, this.getSubscriptionId(), this.expires);
    }

    public void refreshSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        this.tracer.info("resubscribe Ok : expires=" + expires);
    }

    public void refreshSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.tracer.info("error on resubscribe: error=" + error);
        this.deleteRlsServices();
    }

    public void stop() {
        this.getPresenceClientControlSbb().removeSubscription(this.subscriber, this.notifier, this.eventPackage, this.getSubscriptionId());
        this.deleteRlsServices();
    }

    public void removeSubscriptionError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.tracer.info("error on unsubscribe: error=" + error);
    }

    public void removeSubscriptionOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        this.tracer.info("unsubscribe Ok");
    }

    public void deleteResponse(URI uri, int responseCode, String responseContent, String eTag) {
        this.getParentSbbCMP().subscriberStopped();
    }

    public void getResponse(URI uri, int responseCode, String mimetype, String content, String eTag) {
    }

    public void modifyPublicationError(Object requestId, int error) {
    }

    public void modifyPublicationOk(Object requestId, String eTag, int expires) {
    }

    public void newPublicationError(Object requestId, int error) {
    }

    public void newPublicationOk(Object requestId, String eTag, int expires) {
    }

    public void refreshPublicationError(Object requestId, int error) {
    }

    public void refreshPublicationOk(Object requestId, String eTag, int expires) {
    }

    public void removePublicationError(Object requestId, int error) {
    }

    public void removePublicationOk(Object requestId) {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.tracer = sbbContext.getTracer("RLSExampleSubscriberSbb");
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)context.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)context.lookup("slee/nullactivity/factory");
        }
        catch (Exception e) {
            this.tracer.severe("Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

