/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.examples;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityContextInterfaceFactory;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;

public abstract class InternalSubscriberExampleSbb
implements Sbb,
SubscriptionClientControlParentSbbLocalObject {
    String presenceDomain = System.getProperty("bind.address", "127.0.0.1");
    String subscriber = "sip:internal-subscriber@" + this.presenceDomain;
    String notifier = "sip:user@" + this.presenceDomain;
    String eventPackage = "presence";
    int expires = 300;
    private SbbContext sbbContext = null;
    private TimerFacility timerFacility = null;
    private ServiceActivityFactory serviceActivityFactory = null;
    private ServiceActivityContextInterfaceFactory serviceActivityContextInterfaceFactory = null;
    private static Logger log4j = Logger.getLogger(InternalSubscriberExampleSbb.class);

    public abstract ChildRelation getSubscriptionControlChildRelation();

    public abstract SubscriptionClientControlSbbLocalObject getSubscriptionControlChildSbbCMP();

    public abstract void setSubscriptionControlChildSbbCMP(SubscriptionClientControlSbbLocalObject var1);

    private SubscriptionClientControlSbbLocalObject getSubscriptionControlChildSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionControlChildSbbCMP();
        if (childSbb == null) {
            childSbb = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionControlChildRelation().create();
            this.setSubscriptionControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((SubscriptionClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public abstract void setSubscriptionId(String var1);

    public abstract String getSubscriptionId();

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        if (this.serviceActivityFactory.getActivity().equals(aci.getActivity())) {
            log4j.info((Object)"Service activated, subscribing state...");
            try {
                String subscriptionId = this.subscriber + ":" + this.notifier + ":" + this.eventPackage;
                this.setSubscriptionId(subscriptionId);
                this.getSubscriptionControlChildSbb().subscribe(this.subscriber, "voyer", this.notifier, this.eventPackage, subscriptionId, this.expires, null, null, null);
            }
            catch (Exception e) {
                log4j.error((Object)e);
            }
        } else {
            aci.detach(this.sbbContext.getSbbLocalObject());
        }
    }

    public void subscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        log4j.info((Object)("subscribe ok: responseCode=" + responseCode + ",expires=" + expires));
        TimerOptions timerOptions = new TimerOptions();
        timerOptions.setPersistent(true);
        timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        ServiceActivity serviceActivity = this.serviceActivityFactory.getActivity();
        ActivityContextInterface aci = null;
        try {
            aci = this.serviceActivityContextInterfaceFactory.getActivityContextInterface(serviceActivity);
        }
        catch (Exception e) {
            log4j.error((Object)"Failed to retreive service activity aci", (Throwable)e);
            try {
                this.getSubscriptionControlChildSbb().unsubscribe(subscriber, notifier, eventPackage, subscriptionId);
            }
            catch (Exception f) {
                log4j.error((Object)"Dude, now I can't get the child sbb!!", (Throwable)f);
            }
            return;
        }
        this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + (long)(expires * 1000), (long)(expires * 1000), 0, timerOptions);
    }

    public void subscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        log4j.info((Object)("error on subscribe: error=" + error));
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        String notification = "\nNOTIFY EVENT:\n+-- Subscriber: " + subscriber + "\n+-- Notifier: " + notifier + "\n+-- EventPackage: " + eventPackage + "\n+-- SubscriptionId: " + subscriptionId + "\n+-- Subscription status: " + status + "\n+-- Subscription terminationReason: " + terminationReason + "\n+-- Content Type: " + contentType + '/' + contentSubtype + "\n+-- Content:\n\n" + content;
        log4j.info((Object)notification);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            this.getSubscriptionControlChildSbb().resubscribe(this.subscriber, this.notifier, this.eventPackage, this.getSubscriptionId(), this.expires);
        }
        catch (Exception e) {
            log4j.error((Object)e);
        }
    }

    public void resubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        log4j.info((Object)("resubscribe Ok : expires=" + expires));
    }

    public void resubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        log4j.info((Object)("error on resubscribe: error=" + error));
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        if (this.getSubscriptionId() != null) {
            log4j.info((Object)"Service deactivated, removing subscription...");
            try {
                this.getSubscriptionControlChildSbb().unsubscribe(this.subscriber, this.notifier, this.eventPackage, this.getSubscriptionId());
            }
            catch (Exception e) {
                log4j.error((Object)e);
            }
        } else {
            log4j.info((Object)"Service deactivated, no subscription to remove.");
        }
    }

    public void unsubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        log4j.info((Object)"unsubscribe Ok");
    }

    public void unsubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        log4j.info((Object)("error on unsubscribe: error=" + error));
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.serviceActivityFactory = (ServiceActivityFactory)context.lookup("slee/serviceactivity/factory");
            this.serviceActivityContextInterfaceFactory = (ServiceActivityContextInterfaceFactory)context.lookup("slee/serviceactivity/activitycontextinterfacefactory");
        }
        catch (Exception e) {
            log4j.error((Object)"Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        log4j.info((Object)"unsetSbbContext()");
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBack) {
    }
}

