/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.client;

import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sipevent.server.publication.PublicationClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.publication.Result;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sippresence.client.InternalPresenceClientControl;
import org.mobicents.slee.sippresence.client.PresenceClientControlParentSbbLocalObject;

public abstract class InternalPresenceClientControlSbb
implements Sbb,
InternalPresenceClientControl {
    private static Tracer logger;
    private SbbContext sbbContext = null;

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        logger = sbbContext.getTracer(this.getClass().getSimpleName());
    }

    public void setParentSbb(PresenceClientControlParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    public void newPublication(Object requestId, String entity, String document, String contentType, String contentSubType, int expires) {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationClientControlSbbLocalObject();
        if (childSbb != null) {
            Result result = childSbb.newPublication(entity, "presence", document, contentType, contentSubType, expires);
            if (result.getStatusCode() < 300) {
                this.getParentSbbCMP().newPublicationOk(requestId, result.getETag(), result.getExpires());
            } else {
                this.getParentSbbCMP().newPublicationError(requestId, result.getStatusCode());
            }
        } else {
            this.getParentSbbCMP().newPublicationError(requestId, 500);
        }
    }

    public void refreshPublication(Object requestId, String entity, String eTag, int expires) {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationClientControlSbbLocalObject();
        if (childSbb != null) {
            Result result = childSbb.refreshPublication(entity, "presence", eTag, expires);
            if (result.getStatusCode() < 300) {
                this.getParentSbbCMP().refreshPublicationOk(requestId, result.getETag(), result.getExpires());
            } else {
                this.getParentSbbCMP().refreshPublicationError(requestId, result.getStatusCode());
            }
        } else {
            this.getParentSbbCMP().refreshPublicationError(requestId, 500);
        }
    }

    public void modifyPublication(Object requestId, String entity, String eTag, String document, String contentType, String contentSubType, int expires) {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationClientControlSbbLocalObject();
        if (childSbb != null) {
            Result result = childSbb.modifyPublication(entity, "presence", eTag, document, contentType, contentSubType, expires);
            if (result.getStatusCode() < 300) {
                this.getParentSbbCMP().modifyPublicationOk(requestId, result.getETag(), result.getExpires());
            } else {
                this.getParentSbbCMP().modifyPublicationError(requestId, result.getStatusCode());
            }
        } else {
            this.getParentSbbCMP().modifyPublicationError(requestId, 500);
        }
    }

    public void removePublication(Object requestId, String entity, String eTag) {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationClientControlSbbLocalObject();
        if (childSbb != null) {
            int result = childSbb.removePublication(entity, "presence", eTag);
            if (result < 300) {
                this.getParentSbbCMP().removePublicationOk(requestId);
            } else {
                this.getParentSbbCMP().removePublicationError(requestId, result);
            }
        } else {
            this.getParentSbbCMP().removePublicationError(requestId, 500);
        }
    }

    public void newSubscription(String subscriber, String subscriberdisplayName, String notifier, String eventPackage, String subscriptionId, int expires) {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlSbbLocalObject();
        if (childSbb != null) {
            childSbb.subscribe(subscriber, subscriberdisplayName, notifier, eventPackage, subscriptionId, expires, null, null, null);
        } else {
            this.getParentSbbCMP().newSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, 500);
        }
    }

    public void refreshSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlSbbLocalObject();
        if (childSbb != null) {
            childSbb.resubscribe(subscriber, notifier, eventPackage, subscriptionId, expires);
        } else {
            this.getParentSbbCMP().refreshSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, 500);
        }
    }

    public void removeSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlSbbLocalObject();
        if (childSbb != null) {
            childSbb.unsubscribe(subscriber, notifier, eventPackage, subscriptionId);
        } else {
            this.getParentSbbCMP().refreshSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, 500);
        }
    }

    public void subscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        this.getParentSbbCMP().newSubscriptionOk(subscriber, notifier, eventPackage, subscriptionId, expires, responseCode);
    }

    public void subscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.getParentSbbCMP().newSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, error);
    }

    public void resubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        this.getParentSbbCMP().refreshSubscriptionOk(subscriber, notifier, eventPackage, subscriptionId, expires);
    }

    public void resubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.getParentSbbCMP().refreshSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, error);
    }

    public void unsubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        this.getParentSbbCMP().removeSubscriptionOk(subscriber, notifier, eventPackage, subscriptionId);
    }

    public void unsubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        this.getParentSbbCMP().removeSubscriptionError(subscriber, notifier, eventPackage, subscriptionId, error);
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        this.getParentSbbCMP().notifyEvent(subscriber, notifier, eventPackage, subscriptionId, terminationReason, status, content, contentType, contentSubtype);
    }

    public abstract void setParentSbbCMP(PresenceClientControlParentSbbLocalObject var1);

    public abstract PresenceClientControlParentSbbLocalObject getParentSbbCMP();

    public abstract PublicationClientControlSbbLocalObject getPublicationClientControlChildSbbCMP();

    public abstract void setPublicationClientControlChildSbbCMP(PublicationClientControlSbbLocalObject var1);

    public abstract ChildRelation getPublicationClientControlChildRelation();

    private PublicationClientControlSbbLocalObject getPublicationClientControlSbbLocalObject() {
        PublicationClientControlSbbLocalObject childSbb = this.getPublicationClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (PublicationClientControlSbbLocalObject)this.getPublicationClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.severe("Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setPublicationClientControlChildSbbCMP(childSbb);
        }
        return childSbb;
    }

    public abstract SubscriptionClientControlSbbLocalObject getSubscriptionClientControlChildSbbCMP();

    public abstract void setSubscriptionClientControlChildSbbCMP(SubscriptionClientControlSbbLocalObject var1);

    public abstract ChildRelation getSubscriptionClientControlChildRelation();

    private SubscriptionClientControlSbbLocalObject getSubscriptionClientControlSbbLocalObject() {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.severe("Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setSubscriptionClientControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((SubscriptionClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

