/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.presrulescache;

import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.slee.Address;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.mobicents.slee.sippresence.server.presrulescache.GetAndSubscribePresRulesAppUsageEvent;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesActivity;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesActivityHandle;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesActivityImpl;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesCacheDataSource;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesSbbInterface;
import org.mobicents.slee.sippresence.server.presrulescache.RulesetUpdatedEvent;
import org.mobicents.slee.sippresence.server.presrulescache.UnsubscribePresRulesAppUsageEvent;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.Ruleset;
import org.openxdm.xcap.common.uri.DocumentSelector;

public class PresRulesCacheResourceAdaptor
implements ResourceAdaptor,
PresRulesSbbInterface {
    private PresRulesCacheDataSource dataSource;
    private Tracer tracer;
    private boolean serviceActive = false;
    private boolean raActive = false;
    private FireableEventType rulesetUpdatedEventType;
    private FireableEventType getAndSubscribePresRulesAppUsageEventType;
    private FireableEventType unsubscribePresRulesAppUsageEventType;
    private final ServiceID serviceID = new ServiceID("PresRulesCacheService", "org.mobicents", "1.0");
    private SleeEndpoint sleeEndpoint;
    private static final int ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);
    private final PresRulesActivityImpl presRulesAppUsageActivity = new PresRulesActivityImpl(new DocumentSelector("null", "null"), this);
    private final PresRulesActivityHandle presRulesAppUsageActivityHandle = new PresRulesActivityHandle(this.presRulesAppUsageActivity.getDocumentSelector());
    public static JAXBContext jaxbContext = PresRulesCacheResourceAdaptor.initJAxbContext();
    private ExecutorService executorService;

    public PresRulesCacheDataSource getDataSource() {
        return this.dataSource;
    }

    private static JAXBContext initJAxbContext() {
        try {
            return JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy:org.openxdm.xcap.client.appusage.presrules.jaxb:org.openxdm.xcap.client.appusage.omapresrules.jaxb");
        }
        catch (JAXBException e) {
            throw new RuntimeException("unable to create jaxb context for pres rules docs", e);
        }
    }

    public void activityEnded(ActivityHandle handle) {
        this.dataSource.removeActivity((PresRulesActivityHandle)handle);
    }

    public void activityUnreferenced(ActivityHandle handle) {
        try {
            this.sleeEndpoint.endActivity(handle);
        }
        catch (Throwable e) {
            this.tracer.warning("failed to end activity after becoming unreferenced: " + handle, e);
            this.activityEnded(handle);
        }
    }

    public void administrativeRemove(ActivityHandle handle) {
        this.activityEnded(handle);
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
    }

    public Object getActivity(ActivityHandle handle) {
        PresRulesActivityHandle presRulesActivityHandle = (PresRulesActivityHandle)handle;
        return this.dataSource.getActivity(presRulesActivityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        PresRulesActivityImpl presRulesActivity = (PresRulesActivityImpl)activity;
        PresRulesActivityHandle handle = new PresRulesActivityHandle(presRulesActivity.getDocumentSelector());
        return this.dataSource.getActivity(handle) != null ? handle : null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String className) {
        return this;
    }

    public void queryLiveness(ActivityHandle handle) {
        if (this.dataSource.getActivity((PresRulesActivityHandle)handle) == null) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("failed to end idle activity " + handle, (Throwable)e);
            }
        }
    }

    public void raActive() {
        this.dataSource = new PresRulesCacheDataSource();
        this.executorService = Executors.newSingleThreadExecutor();
        this.raActive = true;
        if (this.serviceActive) {
            this.initService();
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public void raConfigure(ConfigProperties properties) {
    }

    public void raInactive() {
        this.dataSource = null;
        this.executorService.shutdownNow();
    }

    public void raStopping() {
        this.raActive = false;
        if (this.serviceActive) {
            this.stopService();
        }
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void serviceActive(ReceivableService serviceInfo) {
        if (serviceInfo.getService().equals((Object)this.serviceID)) {
            this.serviceActive = true;
            if (this.raActive) {
                this.initService();
            }
        }
    }

    private void initService() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    PresRulesCacheResourceAdaptor.this.sleeEndpoint.startActivity((ActivityHandle)PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivityHandle, (Object)PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivity);
                    PresRulesCacheResourceAdaptor.this.dataSource.putActivity(PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivityHandle, PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivity);
                    PresRulesCacheResourceAdaptor.this.sleeEndpoint.fireEvent((ActivityHandle)PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivityHandle, PresRulesCacheResourceAdaptor.this.getAndSubscribePresRulesAppUsageEventType, (Object)new GetAndSubscribePresRulesAppUsageEvent(), null, null);
                }
                catch (Throwable e) {
                    PresRulesCacheResourceAdaptor.this.tracer.severe("failed to signal service to watch pres rules app usage in the xdm", e);
                    throw new RuntimeException(e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public void serviceInactive(ReceivableService serviceInfo) {
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        if (serviceInfo.getService().equals((Object)this.serviceID)) {
            this.serviceActive = false;
            if (this.raActive) {
                this.stopService();
            }
        }
    }

    private void stopService() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    PresRulesCacheResourceAdaptor.this.sleeEndpoint.fireEvent((ActivityHandle)PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivityHandle, PresRulesCacheResourceAdaptor.this.unsubscribePresRulesAppUsageEventType, (Object)new UnsubscribePresRulesAppUsageEvent(), null, null);
                    PresRulesCacheResourceAdaptor.this.sleeEndpoint.endActivity((ActivityHandle)PresRulesCacheResourceAdaptor.this.presRulesAppUsageActivityHandle);
                }
                catch (Throwable e) {
                    PresRulesCacheResourceAdaptor.this.tracer.severe("failed to signal service to stop watching pres rules app usage in the xdm", e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        this.sleeEndpoint = context.getSleeEndpoint();
        try {
            this.rulesetUpdatedEventType = context.getEventLookupFacility().getFireableEventType(RulesetUpdatedEvent.EVENT_TYPE_ID);
            this.getAndSubscribePresRulesAppUsageEventType = context.getEventLookupFacility().getFireableEventType(GetAndSubscribePresRulesAppUsageEvent.EVENT_TYPE_ID);
            this.unsubscribePresRulesAppUsageEventType = context.getEventLookupFacility().getFireableEventType(UnsubscribePresRulesAppUsageEvent.EVENT_TYPE_ID);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retreive the event type for the event fired by this RA, unable to proceed", e);
        }
    }

    public void unsetResourceAdaptorContext() {
        this.tracer = null;
        this.sleeEndpoint = null;
        this.rulesetUpdatedEventType = null;
        this.getAndSubscribePresRulesAppUsageEventType = null;
        this.unsubscribePresRulesAppUsageEventType = null;
    }

    public void rulesetUpdated(final DocumentSelector documentSelector, final String oldETag, final String newETag, final String rulesetString) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Ruleset for " + documentSelector + " updated ");
        }
        Runnable r = new Runnable(){

            public void run() {
                Ruleset ruleset = null;
                try {
                    ruleset = (Ruleset)jaxbContext.createUnmarshaller().unmarshal((Reader)new StringReader(rulesetString));
                }
                catch (JAXBException e) {
                    PresRulesCacheResourceAdaptor.this.tracer.severe("unmarshalling of ruleset failed", (Throwable)e);
                    return;
                }
                if (ruleset != null) {
                    PresRulesCacheResourceAdaptor.this.dataSource.putRuleset(documentSelector, ruleset);
                } else {
                    PresRulesCacheResourceAdaptor.this.dataSource.removeRuleset(documentSelector);
                }
                PresRulesActivityHandle handle = new PresRulesActivityHandle(documentSelector);
                PresRulesActivityImpl activity = PresRulesCacheResourceAdaptor.this.dataSource.getActivity(handle);
                if (activity != null) {
                    try {
                        PresRulesCacheResourceAdaptor.this.sleeEndpoint.fireEvent((ActivityHandle)handle, PresRulesCacheResourceAdaptor.this.rulesetUpdatedEventType, (Object)new RulesetUpdatedEvent(documentSelector, oldETag, newETag, ruleset), null, null);
                    }
                    catch (Exception e) {
                        PresRulesCacheResourceAdaptor.this.tracer.severe("unable to fire event for handle " + handle, (Throwable)e);
                    }
                }
            }
        };
        this.executorService.submit(r);
    }

    public PresRulesActivity getActivity(DocumentSelector documentSelector) throws StartActivityException {
        PresRulesActivityHandle handle = new PresRulesActivityHandle(documentSelector);
        PresRulesActivityImpl activity = new PresRulesActivityImpl(documentSelector, this);
        PresRulesActivityImpl existentActivity = this.dataSource.putActivity(handle, activity);
        if (existentActivity == null) {
            this.sleeEndpoint.startActivitySuspended((ActivityHandle)handle, (Object)activity, ACTIVITY_FLAGS);
        } else {
            activity = existentActivity;
        }
        return activity;
    }
}

