/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.publication;

import gov.nist.javax.sip.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.mobicents.slee.sipevent.server.publication.StateComposer;
import org.mobicents.slee.sippresence.pojo.commonschema.NoteT;
import org.mobicents.slee.sippresence.pojo.datamodel.Device;
import org.mobicents.slee.sippresence.pojo.datamodel.Person;
import org.mobicents.slee.sippresence.pojo.pidf.Contact;
import org.mobicents.slee.sippresence.pojo.pidf.Note;
import org.mobicents.slee.sippresence.pojo.pidf.Presence;
import org.mobicents.slee.sippresence.pojo.pidf.Status;
import org.mobicents.slee.sippresence.pojo.pidf.Tuple;
import org.mobicents.slee.sippresence.pojo.pidf.oma.ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceCompositionPolicy
implements StateComposer {
    public Object compose(Object state1, Object state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        return this.compose((Presence)state1, (Presence)state2);
    }

    public Presence compose(Presence presence, Presence otherPresence) {
        Presence result = new Presence();
        result.setEntity(presence.getEntity());
        result.getTuple().addAll(this.composeTuples(presence.getTuple(), otherPresence.getTuple()));
        List presenceAny = presence.getAny();
        ArrayList<Device> presenceDevices = new ArrayList<Device>();
        ArrayList<Person> presencePersons = new ArrayList<Person>();
        Iterator it = presenceAny.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Device) {
                presenceDevices.add((Device)obj);
                it.remove();
                continue;
            }
            if (!(obj instanceof Person)) continue;
            presencePersons.add((Person)obj);
            it.remove();
        }
        List otherPresenceAny = otherPresence.getAny();
        ArrayList<Device> otherPresenceDevices = new ArrayList<Device>();
        ArrayList<Person> otherPresencePersons = new ArrayList<Person>();
        Iterator it2 = otherPresenceAny.iterator();
        while (it2.hasNext()) {
            Object obj = it2.next();
            if (obj instanceof Device) {
                otherPresenceDevices.add((Device)obj);
                it2.remove();
                continue;
            }
            if (!(obj instanceof Person)) continue;
            otherPresencePersons.add((Person)obj);
            it2.remove();
        }
        result.getAny().addAll(this.composeDevices(presenceDevices, otherPresenceDevices));
        result.getAny().addAll(this.composePersons(presencePersons, otherPresencePersons));
        result.getAny().addAll(this.compose(presenceAny, otherPresenceAny, true, false, false));
        result.getNote().addAll(this.composeNotes(presence.getNote(), presence.getNote()));
        return result;
    }

    private List<Tuple> composeTuples(List<Tuple> tuples, List<Tuple> otherTuples) {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        Iterator<Tuple> tuplesIt = tuples.iterator();
        block0: while (tuplesIt.hasNext()) {
            Tuple tuple = tuplesIt.next();
            Iterator<Tuple> otherTuplesIt = otherTuples.iterator();
            while (otherTuplesIt.hasNext()) {
                Tuple otherTuple = otherTuplesIt.next();
                Tuple compositionTuple = this.compose(tuple, otherTuple);
                if (compositionTuple == null) continue;
                result.add(compositionTuple);
                tuplesIt.remove();
                otherTuplesIt.remove();
                continue block0;
            }
        }
        for (Tuple tuple : tuples) {
            tuple.setId(Utils.getInstance().generateTag());
            result.add(tuple);
        }
        for (Tuple tuple : otherTuples) {
            tuple.setId(Utils.getInstance().generateTag());
            result.add(tuple);
        }
        return result;
    }

    private Tuple compose(Tuple tuple, Tuple otherTuple) {
        List<Object> anys;
        Tuple result = new Tuple();
        result.setId(Utils.getInstance().generateTag());
        if (tuple.getContact() == null) {
            if (otherTuple.getContact() != null) {
                return null;
            }
        } else {
            if (otherTuple.getContact() == null) {
                return null;
            }
            Contact composedContact = this.compose(tuple.getContact(), otherTuple.getContact());
            if (composedContact != null) {
                result.setContact(composedContact);
            } else {
                return null;
            }
        }
        if (tuple.getStatus() == null) {
            if (otherTuple.getStatus() != null) {
                return null;
            }
        } else {
            if (otherTuple.getStatus() == null) {
                return null;
            }
            Status status = this.compose(tuple.getStatus(), otherTuple.getStatus());
            if (status != null) {
                result.setStatus(status);
            } else {
                return null;
            }
        }
        if ((anys = this.compose(tuple.getAny(), otherTuple.getAny(), false, false, false)) == null) {
            return null;
        }
        result.getAny().addAll(anys);
        result.getNote().addAll(this.composeNotes(tuple.getNote(), otherTuple.getNote()));
        if (tuple.getTimestamp() == null) {
            result.setTimestamp(otherTuple.getTimestamp());
        } else if (otherTuple.getTimestamp() == null) {
            result.setTimestamp(tuple.getTimestamp());
        } else if (tuple.getTimestamp().compare(otherTuple.getTimestamp()) > 0) {
            result.setTimestamp(tuple.getTimestamp());
        } else {
            result.setTimestamp(otherTuple.getTimestamp());
        }
        return result;
    }

    private Contact compose(Contact contact, Contact otherContact) {
        Contact result = new Contact();
        if (!contact.getValue().equals(otherContact.getValue())) {
            return null;
        }
        result.setValue(contact.getValue());
        if (contact.getPriority() != null && (otherContact.getPriority() == null || otherContact.getPriority().compareTo(contact.getPriority()) < 0)) {
            result.setPriority(contact.getPriority());
        }
        if (result.getPriority() == null) {
            result.setPriority(otherContact.getPriority());
        }
        return result;
    }

    private Status compose(Status status, Status otherStatus) {
        Status result = new Status();
        if (status.getBasic() != null && status.getBasic().equals((Object)otherStatus.getBasic())) {
            result.setBasic(status.getBasic());
        } else if (otherStatus.getBasic() != null) {
            return null;
        }
        List<Object> anys = this.compose(status.getAny(), otherStatus.getAny(), false, false, false);
        if (anys != null) {
            result.getAny().addAll(anys);
            return result;
        }
        return null;
    }

    private List<Object> compose(List<Object> anys, List<Object> otherAnys, boolean allowConflicts, boolean keepRecentInConflict, boolean anysIsOlder) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<Object> anysIt = anys.iterator();
        block0: while (anysIt.hasNext()) {
            Object anysObject = anysIt.next();
            Iterator<Object> otherAnysIt = otherAnys.iterator();
            while (otherAnysIt.hasNext()) {
                Object otherAnysObject = otherAnysIt.next();
                if (anysObject instanceof JAXBElement) {
                    JAXBElement anysElement = (JAXBElement)anysObject;
                    if (!(otherAnysObject instanceof JAXBElement)) continue;
                    JAXBElement otherAnysElement = (JAXBElement)otherAnysObject;
                    if (!anysElement.getName().equals(otherAnysElement.getName()) || !this.isConflict(anysElement.getValue(), otherAnysElement.getValue())) continue;
                    if (allowConflicts) {
                        if (!keepRecentInConflict) continue;
                        if (anysIsOlder) {
                            result.add(otherAnysElement);
                        } else {
                            result.add(anysElement);
                        }
                        anysIt.remove();
                        otherAnysIt.remove();
                        continue block0;
                    }
                    return null;
                }
                if (anysObject.getClass() != otherAnysObject.getClass()) continue;
                if (this.isConflict(anysObject, otherAnysObject)) {
                    if (allowConflicts) {
                        if (!keepRecentInConflict) continue;
                        if (anysIsOlder) {
                            result.add(otherAnysObject);
                        } else {
                            result.add(anysObject);
                        }
                        anysIt.remove();
                        otherAnysIt.remove();
                        continue block0;
                    }
                    return null;
                }
                Object composedObject = this.composeObject(anysObject, otherAnysObject);
                if (composedObject == null) continue;
                result.add(composedObject);
                anysIt.remove();
                otherAnysIt.remove();
                continue block0;
            }
        }
        result.addAll(anys);
        result.addAll(otherAnys);
        return result;
    }

    private Object composeObject(Object anysObject, Object otherAnysObject) {
        if (anysObject instanceof ServiceDescription) {
            ServiceDescription anysServiceDescription = (ServiceDescription)anysObject;
            ServiceDescription otherAnysServiceDescription = (ServiceDescription)otherAnysObject;
            ServiceDescription result = new ServiceDescription();
            result.setServiceId(anysServiceDescription.getServiceId());
            result.setVersion(anysServiceDescription.getVersion());
            result.setDescription(anysServiceDescription.getDescription());
            result.getAny().addAll(this.compose(anysServiceDescription.getAny(), otherAnysServiceDescription.getAny(), true, false, false));
            for (QName attributeName : anysServiceDescription.getOtherAttributes().keySet()) {
                result.getOtherAttributes().put(attributeName, anysServiceDescription.getOtherAttributes().get(attributeName));
            }
            for (QName attributeName : otherAnysServiceDescription.getOtherAttributes().keySet()) {
                String attributeValue = (String)result.getOtherAttributes().get(attributeName);
                if (attributeValue != null) {
                    if (attributeValue.equals(otherAnysServiceDescription.getOtherAttributes().get(attributeName))) continue;
                    result.getOtherAttributes().remove(attributeName);
                    continue;
                }
                result.getOtherAttributes().put(attributeName, otherAnysServiceDescription.getOtherAttributes().get(attributeName));
            }
            return result;
        }
        return null;
    }

    private boolean isConflict(Object object, Object otherObject) {
        if (object.getClass() == ServiceDescription.class) {
            ServiceDescription serviceDescription = (ServiceDescription)object;
            ServiceDescription otherServiceDescription = (ServiceDescription)object;
            if (serviceDescription.getServiceId() == null ? otherServiceDescription.getServiceId() != null : !serviceDescription.getServiceId().equals(otherServiceDescription.getServiceId())) {
                return true;
            }
            return serviceDescription.getVersion() == null ? otherServiceDescription.getVersion() != null : !serviceDescription.getVersion().equals(otherServiceDescription.getVersion());
        }
        return !object.equals(otherObject);
    }

    private List<Note> composeNotes(List<Note> notes, List<Note> otherNotes) {
        ArrayList<Note> result = new ArrayList<Note>();
        Iterator<Note> notesIt = notes.iterator();
        block0: while (notesIt.hasNext()) {
            Note note = notesIt.next();
            Iterator<Note> otherNotesIt = otherNotes.iterator();
            while (otherNotesIt.hasNext()) {
                Note otherNote = otherNotesIt.next();
                if ((note.getLang() != null ? !note.getLang().equals(otherNote.getLang()) : otherNote.getLang() != null) || (note.getValue() == null ? otherNote.getValue() != null : !note.getValue().equals(otherNote.getValue()))) continue;
                result.add(note);
                notesIt.remove();
                otherNotesIt.remove();
                continue block0;
            }
        }
        result.addAll(notes);
        result.addAll(otherNotes);
        return result;
    }

    private List<Device> composeDevices(List<Device> devices, List<Device> otherDevices) {
        ArrayList<Device> result = new ArrayList<Device>();
        Iterator<Device> it = devices.iterator();
        block0: while (it.hasNext()) {
            Device device = it.next();
            Iterator<Device> otherIt = otherDevices.iterator();
            while (otherIt.hasNext()) {
                Device otherDevice = otherIt.next();
                Device compositionDevice = this.composeDevice(device, otherDevice);
                if (compositionDevice == null) continue;
                result.add(compositionDevice);
                it.remove();
                otherIt.remove();
                continue block0;
            }
        }
        for (Device device : devices) {
            device.setId(Utils.getInstance().generateTag());
            result.add(device);
        }
        for (Device device : otherDevices) {
            device.setId(Utils.getInstance().generateTag());
            result.add(device);
        }
        return result;
    }

    private Device composeDevice(Device device, Device otherDevice) {
        if (device.getDeviceID().equals(otherDevice.getDeviceID())) {
            Device result = new Device();
            boolean deviceIsOlder = false;
            if (device.getTimestamp() == null) {
                result.setTimestamp(otherDevice.getTimestamp());
                deviceIsOlder = true;
            } else if (otherDevice.getTimestamp() == null) {
                result.setTimestamp(device.getTimestamp());
            } else if (device.getTimestamp().compare(otherDevice.getTimestamp()) > 0) {
                result.setTimestamp(device.getTimestamp());
            } else {
                result.setTimestamp(otherDevice.getTimestamp());
                deviceIsOlder = true;
            }
            result.getAny().addAll(this.compose(device.getAny(), otherDevice.getAny(), true, true, deviceIsOlder));
            result.getNote().addAll(this.composeNotesT(device.getNote(), otherDevice.getNote()));
            result.setDeviceID(device.getDeviceID());
            result.setId(Utils.getInstance().generateTag());
            return result;
        }
        return null;
    }

    private List<Person> composePersons(List<Person> persons, List<Person> otherPersons) {
        ArrayList<Person> result = new ArrayList<Person>();
        Iterator<Person> it = persons.iterator();
        block0: while (it.hasNext()) {
            Person person = it.next();
            Iterator<Person> otherIt = otherPersons.iterator();
            while (otherIt.hasNext()) {
                Person otherPerson = otherIt.next();
                Person compositionPerson = this.composePerson(person, otherPerson);
                if (compositionPerson == null) continue;
                result.add(compositionPerson);
                it.remove();
                otherIt.remove();
                continue block0;
            }
        }
        for (Person person : persons) {
            person.setId(Utils.getInstance().generateTag());
            result.add(person);
        }
        for (Person person : otherPersons) {
            person.setId(Utils.getInstance().generateTag());
            result.add(person);
        }
        return result;
    }

    private Person composePerson(Person person, Person otherPerson) {
        Person result = new Person();
        List<Object> anys = this.compose(person.getAny(), otherPerson.getAny(), false, false, false);
        if (anys == null) {
            return null;
        }
        result.getAny().addAll(anys);
        if (person.getTimestamp() == null) {
            result.setTimestamp(otherPerson.getTimestamp());
        } else if (otherPerson.getTimestamp() == null) {
            result.setTimestamp(person.getTimestamp());
        } else if (person.getTimestamp().compare(otherPerson.getTimestamp()) > 0) {
            result.setTimestamp(person.getTimestamp());
        } else {
            result.setTimestamp(otherPerson.getTimestamp());
        }
        result.getNote().addAll(this.composeNotesT(person.getNote(), otherPerson.getNote()));
        result.setId(Utils.getInstance().generateTag());
        return result;
    }

    private List<NoteT> composeNotesT(List<NoteT> notes, List<NoteT> otherNotes) {
        ArrayList<NoteT> result = new ArrayList<NoteT>();
        Iterator<NoteT> notesIt = notes.iterator();
        block0: while (notesIt.hasNext()) {
            NoteT note = notesIt.next();
            Iterator<NoteT> otherNotesIt = otherNotes.iterator();
            while (otherNotesIt.hasNext()) {
                NoteT otherNote = otherNotesIt.next();
                if ((note.getLang() != null ? !note.getLang().equals(otherNote.getLang()) : otherNote.getLang() != null) || (note.getValue() == null ? otherNote.getValue() != null : !note.getValue().equals(otherNote.getValue()))) continue;
                result.add(note);
                notesIt.remove();
                otherNotesIt.remove();
                continue block0;
            }
        }
        result.addAll(notes);
        result.addAll(otherNotes);
        return result;
    }
}

