/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.publication;

import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.publication.StateComposer;
import org.mobicents.slee.sipevent.server.publication.data.ComposedPublication;
import org.mobicents.slee.sipevent.server.publication.data.Publication;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlParent;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sippresence.server.jmx.SipPresenceServerManagement;
import org.mobicents.slee.sippresence.server.publication.PresenceCompositionPolicy;
import org.mobicents.slee.sippresence.server.publication.PresencePublicationControlSbbInterface;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresencePublicationControl {
    private static Logger logger = Logger.getLogger(PresencePublicationControl.class);
    private static final String[] eventPackages = new String[]{"presence"};
    private static final PresenceCompositionPolicy presenceCompositionPolicy = new PresenceCompositionPolicy();

    public String[] getEventPackages() {
        return eventPackages;
    }

    public void notifySubscribers(ComposedPublication composedPublication, PresencePublicationControlSbbInterface sbb) {
        try {
            ImplementedSubscriptionControlParent subscriptionControl = sbb.getPresenceSubscriptionControl();
            ContentTypeHeader contentTypeHeader = composedPublication.getContentType() == null || composedPublication.getContentSubType() == null ? null : sbb.getHeaderFactory().createContentTypeHeader(composedPublication.getContentType(), composedPublication.getContentSubType());
            subscriptionControl.notifySubscribers(composedPublication.getComposedPublicationKey().getEntity(), composedPublication.getComposedPublicationKey().getEventPackage(), new NotifyContent((Object)composedPublication.getDocumentAsDOM(), contentTypeHeader, null));
        }
        catch (Exception e) {
            logger.error((Object)("failed to notify subscribers for " + composedPublication.getComposedPublicationKey()), (Throwable)e);
        }
    }

    public boolean authorizePublication(String requestEntity, Document unmarshalledContent) {
        Element pidfElement = unmarshalledContent.getDocumentElement();
        String entity = pidfElement.getAttribute("entity");
        if (entity != null) {
            if (entity.startsWith("pres:") && entity.length() > 5) {
                entity = entity.substring(5);
            }
            return entity.equals(requestEntity);
        }
        return false;
    }

    public boolean acceptsContentType(String eventPackage, ContentTypeHeader contentTypeHeader) {
        return true;
    }

    public Header getAcceptsHeader(String eventPackage, PresencePublicationControlSbbInterface sbb) {
        if (eventPackage.equals("presence")) {
            try {
                return sbb.getHeaderFactory().createAcceptHeader("application", "pidf+xml");
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public Schema getSchema() {
        return SipPresenceServerManagement.getInstance().getCombinedSchema();
    }

    public StateComposer getStateComposer() {
        return presenceCompositionPolicy;
    }

    public Publication getAlternativeValueForExpiredPublication(Publication publication) {
        Document document = publication.getDocumentAsDOM();
        Element presence = document.getDocumentElement();
        NodeList presenceChilds = presence.getChildNodes();
        Node presenceChild = null;
        for (int i = 0; i < presenceChilds.getLength(); ++i) {
            presenceChild = presenceChilds.item(i);
            if (DomUtils.isElementNamed((Node)presenceChild, (String)"tuple")) {
                NodeList tupleChilds = presenceChild.getChildNodes();
                Node tupleChild = null;
                for (int j = 0; j < tupleChilds.getLength(); ++j) {
                    tupleChild = tupleChilds.item(j);
                    if (tupleChild.getNodeType() != 1) continue;
                    presenceChild.removeChild(tupleChild);
                }
                Element status = document.createElement("status");
                tupleChild.appendChild(status);
                Element basic = document.createElement("basic");
                basic.setTextContent("closed");
                status.appendChild(basic);
                continue;
            }
            if (presenceChild.getNodeType() != 1) continue;
            presence.removeChild(presenceChild);
        }
        publication.setDocumentAsString(null);
        return publication;
    }

    public boolean isResponsibleForResource(URI uri) {
        return true;
    }
}

