/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.publication;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.slee.sipevent.server.publication.StateComposer;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceCompositionPolicy
implements StateComposer {
    private static final Random RANDOM = new Random();
    private static final List<Element> EMPTY_LIST = Collections.emptyList();

    private static String generateNCName() {
        return "a" + Integer.toHexString(RANDOM.nextInt());
    }

    public Document compose(Document document, Document otherDocument) {
        if (document == null) {
            return otherDocument;
        }
        if (otherDocument == null) {
            return document;
        }
        PresenceElementData presenceData = new PresenceElementData(document.getDocumentElement());
        PresenceElementData otherPresenceData = new PresenceElementData(otherDocument.getDocumentElement());
        Document newDocument = null;
        try {
            newDocument = DomUtils.DOCUMENT_BUILDER_NS_AWARE_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        Element newPresence = newDocument.createElementNS("urn:ietf:params:xml:ns:pidf", "presence");
        newDocument.appendChild(newPresence);
        newPresence.setAttribute("entity", presenceData.entity);
        for (Element element : this.composeTuples(presenceData.tuples, otherPresenceData.tuples, newDocument)) {
            newPresence.appendChild(element);
        }
        for (Element element : this.composeDevices(presenceData.devices, otherPresenceData.devices, newDocument)) {
            newPresence.appendChild(element);
        }
        for (Element element : this.composePersons(presenceData.persons, otherPresenceData.persons, newDocument)) {
            newPresence.appendChild(element);
        }
        for (Node node : this.composeAny(presenceData.any, otherPresenceData.any, true, false, false, newDocument)) {
            newPresence.appendChild(node);
        }
        for (Node node : this.composeNotes(presenceData.notes, otherPresenceData.notes, newDocument)) {
            newPresence.appendChild(node);
        }
        return newDocument;
    }

    private List<Element> composeTuples(List<Element> tuples, List<Element> otherTuples, Document newDocument) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator<Element> tuplesIt = tuples.iterator();
        block0: while (tuplesIt.hasNext()) {
            Element tuple = tuplesIt.next();
            Iterator<Element> otherTuplesIt = otherTuples.iterator();
            while (otherTuplesIt.hasNext()) {
                Element otherTuple = otherTuplesIt.next();
                Element compositionTuple = this.composeTuple(tuple, otherTuple, newDocument);
                if (compositionTuple == null) continue;
                result.add(compositionTuple);
                tuplesIt.remove();
                otherTuplesIt.remove();
                continue block0;
            }
        }
        Element e = null;
        for (Element tuple : tuples) {
            e = (Element)newDocument.importNode(tuple, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        for (Element tuple : otherTuples) {
            e = (Element)newDocument.importNode(tuple, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        return result;
    }

    private Element composeTuple(Element tuple, Element otherTuple, Document newDocument) {
        List<Node> anys;
        Element result = newDocument.createElement("tuple");
        TupleElementData tupleElementData = new TupleElementData(tuple);
        TupleElementData otherTupleElementData = new TupleElementData(otherTuple);
        if (tupleElementData.contact == null) {
            if (otherTupleElementData.contact != null) {
                return null;
            }
        } else {
            if (otherTupleElementData.contact == null) {
                return null;
            }
            Element composedContact = this.composeContact(tupleElementData.contact, otherTupleElementData.contact, newDocument);
            if (composedContact != null) {
                result.appendChild(composedContact);
            } else {
                return null;
            }
        }
        if (tupleElementData.serviceDescription == null) {
            if (otherTupleElementData.serviceDescription != null) {
                return null;
            }
        } else {
            if (otherTupleElementData.serviceDescription == null) {
                return null;
            }
            Node composedServiceDescription = this.composeServiceDescription(tupleElementData.serviceDescription, otherTupleElementData.serviceDescription, newDocument);
            if (composedServiceDescription != null) {
                result.appendChild(composedServiceDescription);
            } else {
                return null;
            }
        }
        if (tupleElementData.status == null) {
            if (otherTupleElementData.status != null) {
                return null;
            }
        } else {
            if (otherTupleElementData.status == null) {
                return null;
            }
            Element status = this.composeStatus(tupleElementData.status, otherTupleElementData.status, newDocument);
            if (status != null) {
                result.appendChild(status);
            } else {
                return null;
            }
        }
        if ((anys = this.composeAny(tupleElementData.any, otherTupleElementData.any, false, false, false, newDocument)) != null) {
            for (Node any : anys) {
                result.appendChild(any);
            }
        } else {
            return null;
        }
        List<Node> notes = this.composeNotes(tupleElementData.notes, otherTupleElementData.notes, newDocument);
        if (notes != null) {
            for (Node note : notes) {
                result.appendChild(note);
            }
        }
        if (tupleElementData.timestamp == null) {
            if (otherTupleElementData.timestamp != null) {
                result.appendChild(newDocument.importNode(otherTupleElementData.timestamp, true));
            }
        } else if (otherTupleElementData.timestamp == null) {
            result.appendChild(newDocument.importNode(tupleElementData.timestamp, true));
        } else {
            XMLGregorianCalendar timestamp = null;
            XMLGregorianCalendar otherTimestamp = null;
            try {
                timestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(tupleElementData.timestamp.getTextContent());
                otherTimestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(otherTupleElementData.timestamp.getTextContent());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (timestamp.compare(otherTimestamp) > 0) {
                result.appendChild(newDocument.importNode(tupleElementData.timestamp, true));
            } else {
                result.appendChild(newDocument.importNode(otherTupleElementData.timestamp, true));
            }
        }
        result.setAttribute("id", PresenceCompositionPolicy.generateNCName());
        return result;
    }

    private Node composeServiceDescription(Element serviceDescription, Element otherServiceDescription, Document newDocument) {
        String elementServiceId = null;
        String elementVersion = null;
        NodeList nodeList = serviceDescription.getChildNodes();
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (DomUtils.isElementNamed((Node)node, (String)"service-id")) {
                elementServiceId = ((Element)node).getTextContent();
                continue;
            }
            if (!DomUtils.isElementNamed((Node)node, (String)"version")) continue;
            elementVersion = ((Element)node).getTextContent();
        }
        String otherElementServiceId = null;
        String otherElementVersion = null;
        nodeList = otherServiceDescription.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (DomUtils.isElementNamed((Node)node, (String)"service-id")) {
                otherElementServiceId = ((Element)node).getTextContent();
                continue;
            }
            if (!DomUtils.isElementNamed((Node)node, (String)"version")) continue;
            otherElementVersion = ((Element)node).getTextContent();
        }
        if (elementServiceId == null ? otherElementServiceId != null : !elementServiceId.equals(otherElementServiceId)) {
            return null;
        }
        if (elementVersion == null ? otherElementVersion != null : !elementVersion.equals(otherElementVersion)) {
            return null;
        }
        return newDocument.importNode(serviceDescription, true);
    }

    private Element composeContact(Element contact, Element otherContact, Document newDocument) {
        Element result = newDocument.createElement("contact");
        if (!contact.getTextContent().equals(otherContact.getTextContent())) {
            return null;
        }
        result.setTextContent(contact.getTextContent());
        BigDecimal contactPriority = null;
        String s = contact.getAttribute("priority");
        if (s != null && !(s = s.trim()).equals("")) {
            contactPriority = new BigDecimal(s);
        }
        BigDecimal otherContactPriority = null;
        s = otherContact.getAttribute("priority");
        if (s != null && !(s = s.trim()).equals("")) {
            otherContactPriority = new BigDecimal(s);
        }
        if (contactPriority != null) {
            if (otherContactPriority == null || otherContactPriority.compareTo(contactPriority) < 0) {
                result.appendChild(newDocument.importNode(contact, true));
            } else {
                result.appendChild(newDocument.importNode(otherContact, true));
            }
        } else if (otherContactPriority != null) {
            result.appendChild(newDocument.importNode(otherContact, true));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element composeStatus(Element status, Element otherStatus, Document newDocument) {
        Element result = newDocument.createElement("status");
        StatusElementData statusElementData = new StatusElementData(status);
        StatusElementData otherStatusElementData = new StatusElementData(otherStatus);
        if (statusElementData.basic != null) {
            if (otherStatusElementData.basic == null) return null;
            if (!statusElementData.basic.getTextContent().equals(otherStatusElementData.basic.getTextContent())) return null;
            result.appendChild(newDocument.importNode(statusElementData.basic, true));
        } else if (otherStatusElementData.basic != null) {
            return null;
        }
        List<Node> anys = this.composeAny(statusElementData.any, otherStatusElementData.any, false, false, false, newDocument);
        if (anys == null) return null;
        if (result == null) {
            result = newDocument.createElement("status");
        }
        for (Node any : anys) {
            result.appendChild(any);
        }
        return result;
    }

    private List<Node> composeAny(List<Element> anys, List<Element> otherAnys, boolean allowConflicts, boolean keepRecentInConflict, boolean anysIsOlder, Document newDocument) {
        ArrayList<Node> result = new ArrayList<Node>();
        Iterator<Element> anysIt = anys.iterator();
        block0: while (anysIt.hasNext()) {
            Element anysElement = anysIt.next();
            Iterator<Element> otherAnysIt = otherAnys.iterator();
            while (otherAnysIt.hasNext()) {
                Element otherAnysElement = otherAnysIt.next();
                if (!DomUtils.getElementName((Node)anysElement).equals(DomUtils.getElementName((Node)otherAnysElement)) || (anysElement.getNamespaceURI() == null ? otherAnysElement.getNamespaceURI() != null : !anysElement.getNamespaceURI().equals(otherAnysElement.getNamespaceURI()))) continue;
                if (this.isConflict(anysElement, otherAnysElement)) {
                    if (allowConflicts) {
                        if (!keepRecentInConflict) continue;
                        if (anysIsOlder) {
                            result.add(newDocument.importNode(otherAnysElement, true));
                        } else {
                            result.add(newDocument.importNode(anysElement, true));
                        }
                        anysIt.remove();
                        otherAnysIt.remove();
                        continue block0;
                    }
                    return null;
                }
                if (anysIsOlder) {
                    result.add(newDocument.importNode(otherAnysElement, true));
                } else {
                    result.add(newDocument.importNode(anysElement, true));
                }
                anysIt.remove();
                otherAnysIt.remove();
                continue block0;
            }
        }
        for (Element e : anys) {
            result.add(newDocument.importNode(e, true));
        }
        for (Element e : otherAnys) {
            result.add(newDocument.importNode(e, true));
        }
        return result;
    }

    private boolean isConflict(Element element, Element otherElement) {
        return !element.isEqualNode(otherElement);
    }

    private List<Node> composeNotes(List<Element> notes, List<Element> otherNotes, Document newDocument) {
        ArrayList<Node> result = new ArrayList<Node>();
        Iterator<Element> notesIt = notes.iterator();
        block0: while (notesIt.hasNext()) {
            Element note = notesIt.next();
            Iterator<Element> otherNotesIt = otherNotes.iterator();
            while (otherNotesIt.hasNext()) {
                Element otherNote = otherNotesIt.next();
                if (!note.isEqualNode(otherNote)) continue;
                result.add(newDocument.importNode(note, true));
                notesIt.remove();
                otherNotesIt.remove();
                continue block0;
            }
        }
        for (Element note : notes) {
            result.add(newDocument.importNode(note, true));
        }
        for (Element note : otherNotes) {
            result.add(newDocument.importNode(note, true));
        }
        return result;
    }

    private List<Element> composeDevices(List<Element> devices, List<Element> otherDevices, Document newDocument) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator<Element> it = devices.iterator();
        block0: while (it.hasNext()) {
            Element device = it.next();
            Iterator<Element> otherIt = otherDevices.iterator();
            while (otherIt.hasNext()) {
                Element otherDevice = otherIt.next();
                Element compositionDevice = this.composeDevice(device, otherDevice, newDocument);
                if (compositionDevice == null) continue;
                result.add(compositionDevice);
                it.remove();
                otherIt.remove();
                continue block0;
            }
        }
        Element e = null;
        for (Element device : devices) {
            e = (Element)newDocument.importNode(device, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        for (Element device : otherDevices) {
            e = (Element)newDocument.importNode(device, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        return result;
    }

    private Element composeDevice(Element device, Element otherDevice, Document newDocument) {
        DeviceElementData deviceElementData = new DeviceElementData(device);
        DeviceElementData otherDeviceElementData = new DeviceElementData(otherDevice);
        if (deviceElementData.deviceID.getTextContent().equals(otherDeviceElementData.deviceID.getTextContent())) {
            List<Node> notes;
            List<Node> anys;
            Element result = newDocument.createElement("device");
            result.appendChild(newDocument.importNode(deviceElementData.deviceID, true));
            boolean deviceIsOlder = false;
            if (deviceElementData.timestamp == null) {
                if (otherDeviceElementData.timestamp != null) {
                    result.appendChild(newDocument.importNode(otherDeviceElementData.timestamp, true));
                    deviceIsOlder = true;
                }
            } else if (otherDeviceElementData.timestamp == null) {
                result.appendChild(newDocument.importNode(deviceElementData.timestamp, true));
            } else {
                XMLGregorianCalendar timestamp = null;
                XMLGregorianCalendar otherTimestamp = null;
                try {
                    timestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(deviceElementData.timestamp.getTextContent());
                    otherTimestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(otherDeviceElementData.timestamp.getTextContent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (timestamp.compare(otherTimestamp) > 0) {
                    result.appendChild(newDocument.importNode(deviceElementData.timestamp, true));
                } else {
                    result.appendChild(newDocument.importNode(otherDeviceElementData.timestamp, true));
                    deviceIsOlder = true;
                }
            }
            if ((anys = this.composeAny(deviceElementData.any, otherDeviceElementData.any, true, true, deviceIsOlder, newDocument)) != null) {
                for (Node any : anys) {
                    result.appendChild(any);
                }
            }
            if ((notes = this.composeNotes(deviceElementData.notes, otherDeviceElementData.notes, newDocument)) != null) {
                for (Node note : notes) {
                    result.appendChild(note);
                }
            }
            result.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            return result;
        }
        return null;
    }

    private List<Element> composePersons(List<Element> persons, List<Element> otherPersons, Document newDocument) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator<Element> it = persons.iterator();
        block0: while (it.hasNext()) {
            Element person = it.next();
            Iterator<Element> otherIt = otherPersons.iterator();
            while (otherIt.hasNext()) {
                Element otherPerson = otherIt.next();
                Element compositionPerson = this.composePerson(person, otherPerson, newDocument);
                if (compositionPerson == null) continue;
                result.add(compositionPerson);
                it.remove();
                otherIt.remove();
                continue block0;
            }
        }
        Element e = null;
        for (Element person : persons) {
            e = (Element)newDocument.importNode(person, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        for (Element person : otherPersons) {
            e = (Element)newDocument.importNode(person, true);
            e.setAttribute("id", PresenceCompositionPolicy.generateNCName());
            result.add(e);
        }
        return result;
    }

    private Element composePerson(Element person, Element otherPerson, Document newDocument) {
        Element result = newDocument.createElement("person");
        PersonElementData personElementData = new PersonElementData(person);
        PersonElementData otherPersonElementData = new PersonElementData(otherPerson);
        List<Node> anys = this.composeAny(personElementData.any, otherPersonElementData.any, false, false, false, newDocument);
        if (anys != null) {
            for (Node any : anys) {
                result.appendChild(any);
            }
        } else {
            return null;
        }
        List<Node> notes = this.composeNotes(personElementData.notes, otherPersonElementData.notes, newDocument);
        if (notes != null) {
            for (Node note : notes) {
                result.appendChild(note);
            }
        }
        if (personElementData.timestamp == null) {
            if (otherPersonElementData.timestamp != null) {
                result.appendChild(newDocument.importNode(otherPersonElementData.timestamp, true));
            }
        } else if (otherPersonElementData.timestamp == null) {
            result.appendChild(newDocument.importNode(personElementData.timestamp, true));
        } else {
            XMLGregorianCalendar timestamp = null;
            XMLGregorianCalendar otherTimestamp = null;
            try {
                timestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(personElementData.timestamp.getTextContent());
                otherTimestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(otherPersonElementData.timestamp.getTextContent());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (timestamp.compare(otherTimestamp) > 0) {
                result.appendChild(newDocument.importNode(personElementData.timestamp, true));
            } else {
                result.appendChild(newDocument.importNode(otherPersonElementData.timestamp, true));
            }
        }
        result.setAttribute("id", PresenceCompositionPolicy.generateNCName());
        return result;
    }

    private static class PersonElementData {
        Element timestamp;
        List<Element> any;
        List<Element> notes;

        PersonElementData(Element element) {
            NodeList childs = element.getChildNodes();
            Node child = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (DomUtils.isElementNamed((Node)child, (String)"timestamp")) {
                    this.timestamp = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"note")) {
                    if (this.notes == null) {
                        this.notes = new ArrayList<Element>();
                    }
                    this.notes.add((Element)child);
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                if (this.any == null) {
                    this.any = new ArrayList<Element>();
                }
                this.any.add((Element)child);
            }
            if (this.any == null) {
                this.any = EMPTY_LIST;
            }
            if (this.notes == null) {
                this.notes = EMPTY_LIST;
            }
        }
    }

    private static class DeviceElementData {
        Element deviceID;
        Element timestamp;
        List<Element> any;
        List<Element> notes;

        DeviceElementData(Element element) {
            NodeList childs = element.getChildNodes();
            Node child = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (DomUtils.isElementNamed((Node)child, (String)"deviceID")) {
                    this.deviceID = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"timestamp")) {
                    this.timestamp = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"note")) {
                    if (this.notes == null) {
                        this.notes = new ArrayList<Element>();
                    }
                    this.notes.add((Element)child);
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                if (this.any == null) {
                    this.any = new ArrayList<Element>();
                }
                this.any.add((Element)child);
            }
            if (this.any == null) {
                this.any = EMPTY_LIST;
            }
            if (this.notes == null) {
                this.notes = EMPTY_LIST;
            }
        }
    }

    private static class StatusElementData {
        Element basic;
        List<Element> any;

        StatusElementData(Element element) {
            NodeList childs = element.getChildNodes();
            Node child = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (DomUtils.isElementNamed((Node)child, (String)"basic")) {
                    this.basic = (Element)child;
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                if (this.any == null) {
                    this.any = new ArrayList<Element>();
                }
                this.any.add((Element)child);
            }
            if (this.any == null) {
                this.any = EMPTY_LIST;
            }
        }
    }

    private static class TupleElementData {
        Element serviceDescription;
        Element contact;
        Element status;
        Element timestamp;
        List<Element> any;
        List<Element> notes;

        TupleElementData(Element element) {
            NodeList childs = element.getChildNodes();
            Node child = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (DomUtils.isElementNamed((Node)child, (String)"contact")) {
                    this.contact = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"service-description")) {
                    this.serviceDescription = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"status")) {
                    this.status = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"timestamp")) {
                    this.timestamp = (Element)child;
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"note")) {
                    if (this.notes == null) {
                        this.notes = new ArrayList<Element>();
                    }
                    this.notes.add((Element)child);
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                if (this.any == null) {
                    this.any = new ArrayList<Element>();
                }
                this.any.add((Element)child);
            }
            if (this.any == null) {
                this.any = EMPTY_LIST;
            }
            if (this.notes == null) {
                this.notes = EMPTY_LIST;
            }
        }
    }

    private static class PresenceElementData {
        List<Element> tuples;
        List<Element> devices;
        List<Element> persons;
        List<Element> any;
        List<Element> notes;
        String entity;

        PresenceElementData(Element element) {
            this.entity = element.getAttribute("entity");
            NodeList childs = element.getChildNodes();
            Node child = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                child = childs.item(i);
                if (DomUtils.isElementNamed((Node)child, (String)"tuple")) {
                    if (this.tuples == null) {
                        this.tuples = new ArrayList<Element>();
                    }
                    this.tuples.add((Element)child);
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"device")) {
                    if (this.devices == null) {
                        this.devices = new ArrayList<Element>();
                    }
                    this.devices.add((Element)child);
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"person")) {
                    if (this.persons == null) {
                        this.persons = new ArrayList<Element>();
                    }
                    this.persons.add((Element)child);
                    continue;
                }
                if (DomUtils.isElementNamed((Node)child, (String)"note")) {
                    if (this.notes == null) {
                        this.notes = new ArrayList<Element>();
                    }
                    this.notes.add((Element)child);
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                if (this.any == null) {
                    this.any = new ArrayList<Element>();
                }
                this.any.add((Element)child);
            }
            if (this.any == null) {
                this.any = EMPTY_LIST;
            }
            if (this.devices == null) {
                this.devices = EMPTY_LIST;
            }
            if (this.notes == null) {
                this.notes = EMPTY_LIST;
            }
            if (this.persons == null) {
                this.persons = EMPTY_LIST;
            }
            if (this.tuples == null) {
                this.tuples = EMPTY_LIST;
            }
        }
    }
}

