/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.subscription;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.sip.ServerTransaction;
import javax.slee.ActivityContextInterface;
import javax.slee.resource.StartActivityException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.publication.data.ComposedPublication;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sippresence.pojo.datamodel.Person;
import org.mobicents.slee.sippresence.pojo.pidf.Presence;
import org.mobicents.slee.sippresence.pojo.rpid.Sphere;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesActivity;
import org.mobicents.slee.sippresence.server.subscription.PresenceSubscriptionControlSbbInterface;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRule;
import org.mobicents.slee.sippresence.server.subscription.rules.PresRuleCMPKey;
import org.mobicents.slee.sippresence.server.subscription.rules.RulesetProcessor;
import org.mobicents.slee.sippresence.server.subscription.rules.SubHandlingAction;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.Ruleset;
import org.openxdm.xcap.common.uri.DocumentSelector;

public class PresenceSubscriptionControl {
    private static Logger logger = Logger.getLogger(PresenceSubscriptionControl.class);
    private static final String[] eventPackages = new String[]{"presence"};

    public static String[] getEventPackages() {
        return eventPackages;
    }

    public void isSubscriberAuthorized(String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, boolean eventList, String presRulesAUID, String presRulesDocumentName, ServerTransaction serverTransaction, PresenceSubscriptionControlSbbInterface sbb) {
        DocumentSelector documentSelector = this.getDocumentSelector(notifier.getUri(), presRulesAUID, presRulesDocumentName);
        if (documentSelector == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to create document selector for notifier " + notifier.getUri() + ", can't proceed with subscription."));
            }
            sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 403, eventList, serverTransaction);
            return;
        }
        PresRulesActivity activity = null;
        try {
            activity = sbb.getPresRulesSbbInterface().getActivity(documentSelector);
        }
        catch (StartActivityException e) {
            logger.error((Object)"Failed to start activity, can't proceed, refusing subscription", (Throwable)e);
            sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 403, eventList, serverTransaction);
            return;
        }
        sbb.getPresRulesACIF().getActivityContextInterface(activity).attach(sbb.getSbbLocalObject());
        Ruleset ruleset = activity.getRuleset();
        if (ruleset == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Notifier " + notifier.getUri() + " has no ruleset, allowing subscription " + key));
            }
            OMAPresRule combinedRule = new OMAPresRule(documentSelector);
            combinedRule.setProvideAllDevices(true);
            combinedRule.setProvideAllAttributes(true);
            combinedRule.setProvideAllPersons(true);
            combinedRule.setProvideAllServices(true);
            combinedRule.setSubHandling(SubHandlingAction.allow);
            HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = sbb.getCombinedRules();
            if (combinedRules == null) {
                combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
            }
            combinedRules.put(new PresRuleCMPKey(subscriber, notifier, key), combinedRule);
            sbb.setCombinedRules(combinedRules);
            sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 200, eventList, serverTransaction);
            return;
        }
        RulesetProcessor rulesetProcessor = new RulesetProcessor(subscriber, notifier.getUri(), ruleset, documentSelector, sbb);
        OMAPresRule combinedRule = rulesetProcessor.getCombinedRule();
        int responseCode = combinedRule.getSubHandling().getResponseCode();
        if (responseCode < 300) {
            HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = sbb.getCombinedRules();
            if (combinedRules == null) {
                combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
            }
            combinedRules.put(new PresRuleCMPKey(subscriber, notifier, key), combinedRule);
            sbb.setCombinedRules(combinedRules);
        }
        sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, serverTransaction);
    }

    public void removingSubscription(Subscription subscription, String presRulesAUID, String presRulesDocumentName, PresenceSubscriptionControlSbbInterface sbb) {
        HashMap combinedRules;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removingSubscription(" + subscription + ")"));
        }
        if ((combinedRules = sbb.getCombinedRules()) != null) {
            OMAPresRule ruleRemoved;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("combined rules: " + combinedRules.keySet()));
            }
            if ((ruleRemoved = (OMAPresRule)combinedRules.remove(new PresRuleCMPKey(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey()))) != null) {
                boolean detachFromPresRulesActivity = true;
                for (OMAPresRule rule : combinedRules.values()) {
                    if (!rule.getDocumentSelector().equals((Object)ruleRemoved.getDocumentSelector())) continue;
                    detachFromPresRulesActivity = false;
                    break;
                }
                if (detachFromPresRulesActivity) {
                    PresRulesActivity activity = null;
                    try {
                        activity = sbb.getPresRulesSbbInterface().getActivity(ruleRemoved.getDocumentSelector());
                    }
                    catch (StartActivityException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    ActivityContextInterface aci = sbb.getPresRulesACIF().getActivityContextInterface(activity);
                    aci.detach(sbb.getSbbLocalObject());
                }
            }
        }
    }

    public void rulesetUpdated(DocumentSelector documentSelector, Ruleset ruleset, PresenceSubscriptionControlSbbInterface sbb) {
        HashMap combinedRules = sbb.getCombinedRules();
        if (combinedRules == null) {
            combinedRules = new HashMap();
        }
        OMAPresRule oldCombinedRule = null;
        OMAPresRule newCombinedRule = null;
        PresRuleCMPKey presRuleCMPKey = null;
        SubscriptionKey subscriptionKey = null;
        for (Map.Entry entry : combinedRules.entrySet()) {
            oldCombinedRule = (OMAPresRule)entry.getValue();
            if (!documentSelector.equals((Object)oldCombinedRule.getDocumentSelector())) continue;
            presRuleCMPKey = (PresRuleCMPKey)entry.getKey();
            subscriptionKey = presRuleCMPKey.getSubscriptionKey();
            newCombinedRule = new RulesetProcessor(presRuleCMPKey.getSubscriber(), presRuleCMPKey.getNotifier().getUri(), ruleset, documentSelector, sbb).getCombinedRule();
            combinedRules.put(entry.getKey(), newCombinedRule);
            if (oldCombinedRule.getSubHandling().getResponseCode() == newCombinedRule.getSubHandling().getResponseCode()) continue;
            sbb.getParentSbbCMP().authorizationChanged(presRuleCMPKey.getSubscriber(), presRuleCMPKey.getNotifier(), subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), newCombinedRule.getSubHandling().getResponseCode());
        }
    }

    public String getSphere(String notifier, PresenceSubscriptionControlSbbInterface sbb) {
        String notifierWithoutParams = notifier.split(";")[0];
        ComposedPublication composedPublication = sbb.getPublicationChildSbb().getComposedPublication(notifierWithoutParams, "presence");
        if (composedPublication != null && composedPublication.getUnmarshalledContent().getValue() instanceof Presence) {
            Presence presence = (Presence)composedPublication.getUnmarshalledContent().getValue();
            for (Object anyObject : presence.getAny()) {
                JAXBElement anyElement = (JAXBElement)anyObject;
                if (!(anyElement.getValue() instanceof Person)) continue;
                Person person = (Person)anyElement.getValue();
                for (Object anotherAnyObject : person.getAny()) {
                    JAXBElement anotherAnyElement = (JAXBElement)anotherAnyObject;
                    if (!(anotherAnyElement.getValue() instanceof Sphere)) continue;
                    Sphere sphere = (Sphere)anotherAnyElement.getValue();
                    String result = null;
                    for (Object contentObject : sphere.getContent()) {
                        if (contentObject instanceof String) {
                            if (result == null) {
                                result = (String)contentObject;
                                continue;
                            }
                            result = result + " " + (String)contentObject;
                            continue;
                        }
                        if (!(contentObject instanceof JAXBElement)) continue;
                        JAXBElement contentElement = (JAXBElement)contentObject;
                        if (result == null) {
                            result = contentElement.getName().getLocalPart();
                            continue;
                        }
                        result = result + " " + contentElement.getName().getLocalPart();
                    }
                    return result;
                }
            }
        }
        return null;
    }

    public NotifyContent getNotifyContent(Subscription subscription, PresenceSubscriptionControlSbbInterface sbb) {
        try {
            ComposedPublication composedPublication = sbb.getPublicationChildSbb().getComposedPublication(subscription.getNotifier().getUri(), subscription.getKey().getEventPackage());
            if (composedPublication != null && composedPublication.getUnmarshalledContent() != null) {
                return new NotifyContent((Object)composedPublication.getUnmarshalledContent(), sbb.getHeaderFactory().createContentTypeHeader(composedPublication.getContentType(), composedPublication.getContentSubType()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to get notify content", (Throwable)e);
        }
        return null;
    }

    public Object filterContentPerSubscriber(String subscriber, Notifier notifier, String eventPackage, Object unmarshalledContent) {
        return unmarshalledContent;
    }

    private Ruleset unmarshallRuleset(String documentAsString, Unmarshaller unmarshaller) {
        try {
            return (Ruleset)unmarshaller.unmarshal((Reader)new StringReader(documentAsString));
        }
        catch (JAXBException e) {
            logger.error((Object)"unmarshalling of ruleset failed", (Throwable)e);
            return null;
        }
    }

    private DocumentSelector getDocumentSelector(String user, String presRulesAUID, String presRulesDocumentName) {
        return new DocumentSelector(presRulesAUID, "users/" + user, presRulesDocumentName);
    }

    private String getUser(DocumentSelector documentSelector) {
        return documentSelector.getDocumentParent().substring("users/".length());
    }
}

