/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.subscription;

import java.util.HashMap;
import java.util.Map;
import javax.sip.ServerTransaction;
import javax.slee.ActivityContextInterface;
import javax.slee.resource.StartActivityException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.publication.data.ComposedPublication;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesActivity;
import org.mobicents.slee.sippresence.server.subscription.PresenceSubscriptionControlSbbInterface;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRule;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRuleDOMTransformer;
import org.mobicents.slee.sippresence.server.subscription.rules.PresRuleCMPKey;
import org.mobicents.slee.sippresence.server.subscription.rules.RulesetProcessor;
import org.mobicents.slee.sippresence.server.subscription.rules.SubHandlingAction;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.Ruleset;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresenceSubscriptionControl {
    private static Logger logger = Logger.getLogger(PresenceSubscriptionControl.class);
    private static final OMAPresRuleDOMTransformer PRES_RULE_TRANSFORMER = new OMAPresRuleDOMTransformer();
    private static final String[] eventPackages = new String[]{"presence"};

    public static String[] getEventPackages() {
        return eventPackages;
    }

    public void isSubscriberAuthorized(String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, boolean eventList, String presRulesAUID, String presRulesDocumentName, ServerTransaction serverTransaction, PresenceSubscriptionControlSbbInterface sbb) {
        DocumentSelector documentSelector = this.getDocumentSelector(notifier.getUri(), presRulesAUID, presRulesDocumentName);
        if (documentSelector == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to create document selector for notifier " + notifier.getUri() + ", can't proceed with subscription."));
            }
            sbb.getParentSbb().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 403, eventList, serverTransaction);
            return;
        }
        PresRulesActivity activity = null;
        try {
            activity = sbb.getPresRulesSbbInterface().getActivity(documentSelector);
        }
        catch (StartActivityException e) {
            logger.error((Object)"Failed to start activity, can't proceed, refusing subscription", (Throwable)e);
            sbb.getParentSbb().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 403, eventList, serverTransaction);
            return;
        }
        sbb.getPresRulesACIF().getActivityContextInterface(activity).attach(sbb.getSbbLocalObject());
        Ruleset ruleset = activity.getRuleset();
        if (ruleset == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Notifier " + notifier.getUri() + " has no ruleset, allowing subscription " + key));
            }
            OMAPresRule combinedRule = new OMAPresRule(documentSelector);
            combinedRule.setProvideAllDevices(true);
            combinedRule.setProvideAllAttributes(true);
            combinedRule.setProvideAllPersons(true);
            combinedRule.setProvideAllServices(true);
            combinedRule.setSubHandling(SubHandlingAction.allow);
            HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = sbb.getCombinedRules();
            if (combinedRules == null) {
                combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
            }
            combinedRules.put(new PresRuleCMPKey(subscriber, notifier, key), combinedRule);
            sbb.setCombinedRules(combinedRules);
            sbb.getParentSbb().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 200, eventList, serverTransaction);
            return;
        }
        RulesetProcessor rulesetProcessor = new RulesetProcessor(subscriber, notifier.getUri(), ruleset, documentSelector, sbb);
        OMAPresRule combinedRule = rulesetProcessor.getCombinedRule();
        int responseCode = combinedRule.getSubHandling().getResponseCode();
        if (responseCode < 300) {
            HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = sbb.getCombinedRules();
            if (combinedRules == null) {
                combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
            }
            combinedRules.put(new PresRuleCMPKey(subscriber, notifier, key), combinedRule);
            sbb.setCombinedRules(combinedRules);
        }
        sbb.getParentSbb().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, serverTransaction);
    }

    public void removingSubscription(Subscription subscription, String presRulesAUID, String presRulesDocumentName, PresenceSubscriptionControlSbbInterface sbb) {
        HashMap combinedRules;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removingSubscription(" + subscription + ")"));
        }
        if ((combinedRules = sbb.getCombinedRules()) != null) {
            OMAPresRule ruleRemoved;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("combined rules: " + combinedRules.keySet()));
            }
            if ((ruleRemoved = (OMAPresRule)combinedRules.remove(new PresRuleCMPKey(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey()))) != null) {
                boolean detachFromPresRulesActivity = true;
                for (OMAPresRule rule : combinedRules.values()) {
                    if (!rule.getDocumentSelector().equals((Object)ruleRemoved.getDocumentSelector())) continue;
                    detachFromPresRulesActivity = false;
                    break;
                }
                if (detachFromPresRulesActivity) {
                    PresRulesActivity activity = null;
                    try {
                        activity = sbb.getPresRulesSbbInterface().getActivity(ruleRemoved.getDocumentSelector());
                    }
                    catch (StartActivityException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    ActivityContextInterface aci = sbb.getPresRulesACIF().getActivityContextInterface(activity);
                    aci.detach(sbb.getSbbLocalObject());
                }
            }
        }
    }

    public void rulesetUpdated(DocumentSelector documentSelector, Ruleset ruleset, PresenceSubscriptionControlSbbInterface sbb) {
        HashMap combinedRules = sbb.getCombinedRules();
        if (combinedRules == null) {
            combinedRules = new HashMap();
        }
        OMAPresRule oldCombinedRule = null;
        OMAPresRule newCombinedRule = null;
        PresRuleCMPKey presRuleCMPKey = null;
        SubscriptionKey subscriptionKey = null;
        for (Map.Entry entry : combinedRules.entrySet()) {
            oldCombinedRule = (OMAPresRule)entry.getValue();
            if (!documentSelector.equals((Object)oldCombinedRule.getDocumentSelector())) continue;
            presRuleCMPKey = (PresRuleCMPKey)entry.getKey();
            subscriptionKey = presRuleCMPKey.getSubscriptionKey();
            newCombinedRule = new RulesetProcessor(presRuleCMPKey.getSubscriber(), presRuleCMPKey.getNotifier().getUri(), ruleset, documentSelector, sbb).getCombinedRule();
            combinedRules.put(entry.getKey(), newCombinedRule);
            if (oldCombinedRule.getSubHandling().getResponseCode() == newCombinedRule.getSubHandling().getResponseCode()) continue;
            sbb.getParentSbb().authorizationChanged(presRuleCMPKey.getSubscriber(), presRuleCMPKey.getNotifier(), subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), newCombinedRule.getSubHandling().getResponseCode());
        }
    }

    public String getSphere(String notifier, PresenceSubscriptionControlSbbInterface sbb) {
        String notifierWithoutParams = notifier.split(";")[0];
        ComposedPublication composedPublication = sbb.getPublicationChildSbb().getComposedPublication(notifierWithoutParams, "presence");
        if (composedPublication == null || composedPublication.getDocumentAsDOM() == null) {
            return null;
        }
        String sphere = null;
        Element presence = composedPublication.getDocumentAsDOM().getDocumentElement();
        NodeList presenceChilds = presence.getChildNodes();
        Node presenceChild = null;
        for (int i = 0; i < presenceChilds.getLength(); ++i) {
            presenceChild = presenceChilds.item(i);
            if (!DomUtils.isElementNamed((Node)presenceChild, (String)"person")) continue;
            NodeList personChilds = presenceChild.getChildNodes();
            Node personChild = null;
            for (int j = 0; j < personChilds.getLength(); ++j) {
                personChild = personChilds.item(j);
                if (!DomUtils.isElementNamed((Node)personChild, (String)"sphere")) continue;
                String tmpSphere = null;
                NodeList sphereChilds = personChild.getChildNodes();
                Node sphereChild = null;
                for (int l = 0; l < sphereChilds.getLength(); ++l) {
                    sphereChild = sphereChilds.item(l);
                    if (sphereChild.getNodeType() != 1) continue;
                    tmpSphere = tmpSphere == null ? DomUtils.getElementName((Node)sphereChild) : tmpSphere + " " + DomUtils.getElementName((Node)sphereChild);
                }
                if (sphere == null) {
                    sphere = tmpSphere;
                    continue;
                }
                if (sphere.equals(tmpSphere)) continue;
                return null;
            }
        }
        return sphere;
    }

    public NotifyContent getNotifyContent(Subscription subscription, PresenceSubscriptionControlSbbInterface sbb) {
        try {
            Object filteredContent;
            ComposedPublication composedPublication = sbb.getPublicationChildSbb().getComposedPublication(subscription.getNotifier().getUri(), subscription.getKey().getEventPackage());
            if (composedPublication != null && composedPublication.getDocumentAsDOM() != null && (filteredContent = this.filterContentPerSubscriber(subscription, composedPublication.getDocumentAsDOM(), false, sbb)) != null) {
                return new NotifyContent(filteredContent, sbb.getHeaderFactory().createContentTypeHeader(composedPublication.getContentType(), composedPublication.getContentSubType()), null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to get notify content", (Throwable)e);
        }
        return null;
    }

    public Object filterContentPerSubscriber(Subscription subscription, Object unmarshalledContent, PresenceSubscriptionControlSbbInterface sbb) {
        return this.filterContentPerSubscriber(subscription, unmarshalledContent, true, sbb);
    }

    private Object filterContentPerSubscriber(Subscription subscription, Object unmarshalledContent, boolean stateChange, PresenceSubscriptionControlSbbInterface sbb) {
        if (unmarshalledContent == null) {
            return null;
        }
        if (!(unmarshalledContent instanceof Document)) {
            logger.warn((Object)("request to filter notify content with an unexpected content of type: " + unmarshalledContent.getClass()));
            return unmarshalledContent;
        }
        HashMap combinedRules = sbb.getCombinedRules();
        if (combinedRules == null) {
            return unmarshalledContent;
        }
        OMAPresRule rule = (OMAPresRule)combinedRules.get(new PresRuleCMPKey(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey()));
        if (rule == null) {
            return unmarshalledContent;
        }
        if (rule.getSubHandling() == SubHandlingAction.allow) {
            try {
                return PRES_RULE_TRANSFORMER.transform((Document)unmarshalledContent, rule);
            }
            catch (Exception e) {
                logger.error((Object)("failed to apply rule in content filtering for " + subscription), (Throwable)e);
                return null;
            }
        }
        if (rule.getSubHandling() != SubHandlingAction.politeblock) {
            logger.warn((Object)("request to filter notify content with an unexpected sub-handling value: " + (Object)((Object)rule.getSubHandling())));
        }
        return null;
    }

    private DocumentSelector getDocumentSelector(String user, String presRulesAUID, String presRulesDocumentName) {
        return new DocumentSelector(presRulesAUID + "/users/" + user, presRulesDocumentName);
    }
}

