/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.subscription.rules;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.slee.sippresence.server.subscription.rules.GeoPrivTransformation;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRule;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRuleTransformer;
import org.mobicents.slee.sippresence.server.subscription.rules.UnknownBooleanAttributeTransformation;
import org.mobicents.slee.sippresence.server.subscription.rules.UserInputTransformation;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.openxdm.xcap.common.error.InternalServerErrorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMAPresRuleDOMTransformer
implements OMAPresRuleTransformer<Document> {
    @Override
    public Document transform(Document content, OMAPresRule rule) throws InternalServerErrorException {
        if (!rule.hasTransformations()) {
            return content;
        }
        Document result = null;
        try {
            result = DomUtils.DOCUMENT_BUILDER_NS_AWARE_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InternalServerErrorException("failed to setup DOM builder", (Throwable)e);
        }
        Node presence = result.appendChild(result.importNode(content.getDocumentElement(), true));
        NodeList presenceChilds = presence.getChildNodes();
        Node presenceChild = null;
        String nodeName = null;
        HashSet<Node> nodesToRemove = null;
        for (int i = 0; i < presenceChilds.getLength(); ++i) {
            presenceChild = presenceChilds.item(i);
            boolean keepChild = true;
            if (presenceChild.getNodeType() == 1) {
                nodeName = DomUtils.getElementName((Node)presenceChild);
                if (!(rule.isProvideAllDevices() && rule.isProvideAllAttributes() || !nodeName.equals("device"))) {
                    keepChild = this.keepDevice(presenceChild, rule);
                } else if (!(rule.isProvideAllPersons() && rule.isProvideAllAttributes() || !nodeName.equals("person"))) {
                    keepChild = this.keepPerson(presenceChild, rule);
                } else if (!(rule.isProvideAllServices() && rule.isProvideAllAttributes() || !nodeName.equals("tuple"))) {
                    keepChild = this.keepService(presenceChild, rule);
                } else if (!rule.isProvideAllAttributes()) {
                    keepChild = this.keepUnknownAttribute(nodeName, presenceChild.getNamespaceURI(), presenceChild, rule);
                }
            }
            if (keepChild) continue;
            if (nodesToRemove == null) {
                nodesToRemove = new HashSet<Node>();
            }
            nodesToRemove.add(presenceChild);
        }
        if (nodesToRemove != null) {
            for (Node node : nodesToRemove) {
                node.getParentNode().removeChild(node);
            }
        }
        return result;
    }

    private boolean keepService(Node presenceChild, OMAPresRule rule) {
        boolean keepNode = rule.isProvideAllServices();
        NodeList nodeList = presenceChild.getChildNodes();
        Node node = null;
        String nodeName = null;
        ArrayList<Node> otherNodes = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            nodeName = DomUtils.getElementName((Node)node);
            if (nodeName.equals("class")) {
                if (keepNode || rule.getProvideServiceClasses() == null || !rule.getProvideServiceClasses().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (nodeName.equals("contact")) {
                if (keepNode) continue;
                if (rule.getProvideServiceServiceURIs() != null && rule.getProvideServiceServiceURIs().contains(node.getTextContent().trim())) {
                    keepNode = true;
                    if (!rule.isProvideAllAttributes()) continue;
                    return true;
                }
                if (rule.getProvideServiceServiceURISchemes() == null || !rule.getProvideServiceServiceURISchemes().contains(URI.create(node.getTextContent().trim()).getScheme())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (nodeName.equals("id")) {
                if (keepNode || rule.getProvideServiceOccurenceIds() == null || !rule.getProvideServiceOccurenceIds().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (rule.isProvideAllAttributes()) continue;
            if (otherNodes == null) {
                otherNodes = new ArrayList<Node>();
            }
            otherNodes.add(node);
        }
        if (!keepNode) {
            return false;
        }
        if (otherNodes != null) {
            for (Node otherNode : otherNodes) {
                if (this.keepServiceAttribute(otherNode, rule)) continue;
                presenceChild.removeChild(otherNode);
            }
        }
        return true;
    }

    private boolean keepServiceAttribute(Node node, OMAPresRule rule) {
        String nodeName = DomUtils.getElementName((Node)node);
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf")) {
            if (nodeName.equals("status")) {
                return true;
            }
            if (nodeName.equals("timestamp")) {
                return true;
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:data-model")) {
            if (nodeName.equals("note")) {
                return rule.isProvideNote();
            }
            if (nodeName.equals("deviceID")) {
                return rule.isProvideDeviceID();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:rpid")) {
            if (nodeName.equals("class")) {
                return rule.isProvideClass();
            }
            if (nodeName.equals("privacy")) {
                return rule.isProvidePrivacy();
            }
            if (nodeName.equals("relationship")) {
                return rule.isProvideRelationship();
            }
            if (nodeName.equals("service-class")) {
                return true;
            }
            if (nodeName.equals("status-icon")) {
                return rule.isProvideStatusIcon();
            }
            if (nodeName.equals("user-input")) {
                return this.keepUserInput(node, rule);
            }
        } else if (nodeNamespaceURI.equals("urn:oma:xml:prs:pidf:oma-pres")) {
            if (nodeName.equals("willingness")) {
                return rule.isProvideWillingness();
            }
            if (nodeName.equals("service-description")) {
                return true;
            }
            if (nodeName.equals("barring-state")) {
                return rule.isProvideBarringState();
            }
            if (nodeName.equals("registration-state")) {
                return rule.isProvideRegistrationState();
            }
            if (nodeName.equals("session-participation")) {
                return rule.isProvideSessionParticipation();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:geopriv10") && nodeName.equals("geopriv")) {
            return rule.getProvideGeopriv() == GeoPrivTransformation.FULL;
        }
        return this.keepUnknownAttribute(nodeName, nodeNamespaceURI, node, rule);
    }

    private boolean keepUserInput(Node node, OMAPresRule rule) {
        UserInputTransformation uti = rule.getProvideUserInput();
        if (uti == null) {
            return false;
        }
        Element element = (Element)node;
        switch (uti) {
            case BARE: {
                element.removeAttribute("last-input");
                element.removeAttribute("idle-threshold");
                return true;
            }
            case THRESHOLDS: {
                element.removeAttribute("last-input");
                return true;
            }
            case FULL: {
                return true;
            }
        }
        return false;
    }

    private boolean keepPerson(Node presenceChild, OMAPresRule rule) {
        boolean keepNode = rule.isProvideAllPersons();
        NodeList nodeList = presenceChild.getChildNodes();
        Node node = null;
        String nodeName = null;
        ArrayList<Node> otherNodes = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            nodeName = DomUtils.getElementName((Node)node);
            if (nodeName.equals("class")) {
                if (keepNode || rule.getProvidePersonClasses() == null || !rule.getProvidePersonClasses().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (nodeName.equals("id")) {
                if (keepNode || rule.getProvidePersonOccurenceIds() == null || !rule.getProvidePersonOccurenceIds().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (rule.isProvideAllAttributes()) continue;
            if (otherNodes == null) {
                otherNodes = new ArrayList<Node>();
            }
            otherNodes.add(node);
        }
        if (!keepNode) {
            return false;
        }
        if (otherNodes != null) {
            for (Node otherNode : otherNodes) {
                if (this.keepPersonAttribute(otherNode, rule)) continue;
                presenceChild.removeChild(otherNode);
            }
        }
        return true;
    }

    private boolean keepPersonAttribute(Node node, OMAPresRule rule) {
        String nodeName = DomUtils.getElementName((Node)node);
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:data-model")) {
            if (nodeName.equals("timestamp")) {
                return true;
            }
            if (nodeName.equals("note")) {
                return rule.isProvideNote();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:rpid")) {
            if (nodeName.equals("activities")) {
                return rule.isProvideActivities();
            }
            if (nodeName.equals("class")) {
                return rule.isProvideClass();
            }
            if (nodeName.equals("mood")) {
                return rule.isProvideMood();
            }
            if (nodeName.equals("place-is")) {
                return rule.isProvidePlaceIs();
            }
            if (nodeName.equals("place-type")) {
                return rule.isProvidePlaceType();
            }
            if (nodeName.equals("privacy")) {
                return rule.isProvidePrivacy();
            }
            if (nodeName.equals("sphere")) {
                return rule.isProvideSphere();
            }
            if (nodeName.equals("status-icon")) {
                return rule.isProvideStatusIcon();
            }
            if (nodeName.equals("time-offset")) {
                return rule.isProvideTimeOffset();
            }
            if (nodeName.equals("user-input")) {
                return this.keepUserInput(node, rule);
            }
        } else if (nodeNamespaceURI.equals("urn:oma:xml:prs:pidf:oma-pres")) {
            if (nodeName.equals("overriding-willingness")) {
                return rule.isProvideWillingness();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:geopriv10") && nodeName.equals("geopriv")) {
            return rule.getProvideGeopriv() == GeoPrivTransformation.FULL;
        }
        return this.keepUnknownAttribute(nodeName, nodeNamespaceURI, node, rule);
    }

    private boolean keepDevice(Node presenceChild, OMAPresRule rule) {
        boolean keepNode = rule.isProvideAllDevices();
        NodeList nodeList = presenceChild.getChildNodes();
        Node node = null;
        String nodeName = null;
        ArrayList<Node> otherNodes = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            nodeName = DomUtils.getElementName((Node)node);
            if (nodeName.equals("class")) {
                if (keepNode || rule.getProvideDeviceClasses() == null || !rule.getProvideDeviceClasses().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (nodeName.equals("deviceID")) {
                if (keepNode || rule.getProvideDeviceDeviceIDs() == null || !rule.getProvideDeviceDeviceIDs().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (nodeName.equals("id")) {
                if (keepNode || rule.getProvideDeviceOccurenceIds() == null || !rule.getProvideDeviceOccurenceIds().contains(node.getTextContent().trim())) continue;
                keepNode = true;
                if (!rule.isProvideAllAttributes()) continue;
                return true;
            }
            if (rule.isProvideAllAttributes()) continue;
            if (otherNodes == null) {
                otherNodes = new ArrayList<Node>();
            }
            otherNodes.add(node);
        }
        if (!keepNode) {
            return false;
        }
        if (otherNodes != null) {
            for (Node otherNode : otherNodes) {
                if (this.keepDeviceAttribute(otherNode, rule)) continue;
                presenceChild.removeChild(otherNode);
            }
        }
        return true;
    }

    private boolean keepDeviceAttribute(Node node, OMAPresRule rule) {
        String nodeName = DomUtils.getElementName((Node)node);
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:data-model")) {
            if (nodeName.equals("timestamp")) {
                return true;
            }
            if (nodeName.equals("deviceID")) {
                return true;
            }
            if (nodeName.equals("note")) {
                return rule.isProvideNote();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:rpid")) {
            if (nodeName.equals("class")) {
                return rule.isProvideClass();
            }
            if (nodeName.equals("user-input")) {
                return this.keepUserInput(node, rule);
            }
        } else if (nodeNamespaceURI.equals("urn:oma:xml:prs:pidf:oma-pres")) {
            if (nodeName.equals("network-availability")) {
                return rule.isProvideNetworkAvailability();
            }
        } else if (nodeNamespaceURI.equals("urn:ietf:params:xml:ns:pidf:geopriv10") && nodeName.equals("geopriv")) {
            return rule.getProvideGeopriv() == GeoPrivTransformation.FULL;
        }
        return this.keepUnknownAttribute(nodeName, nodeNamespaceURI, node, rule);
    }

    private boolean keepUnknownAttribute(String nodeName, String nodeNamespaceURI, Node node, OMAPresRule rule) {
        if (rule.getUnknownBooleanAttributes() != null) {
            for (UnknownBooleanAttributeTransformation ubat : rule.getUnknownBooleanAttributes()) {
                if (!ubat.getName().equals(nodeName) || (nodeNamespaceURI == null ? ubat.getNamespace() != null : !nodeNamespaceURI.equals(ubat.getNamespace()))) continue;
                return true;
            }
        }
        return false;
    }
}

